% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_graphics.R
\name{rk.graph.on}
\alias{rk.graph.off}
\alias{rk.graph.on}
\title{Plot graphics to HTML output file}
\usage{
rk.graph.on(device.type = getOption("rk.graphics.type"),
  width = getOption("rk.graphics.width"),
  height = getOption("rk.graphics.height"), quality, ...)

rk.graph.off()
}
\arguments{
\item{device.type}{Type of device to create / graphics format to use. Currently, supported devices are "PNG", "SVG", or "JPG".
The default is to use the format configured in Settings -> Configure RKWard -> Output.}

\item{width}{Width of graphics in pixels. The default is to use the width configured in Settings -> Configure RKWard -> Output.}

\item{height}{Height of graphics in pixels. The default is to use the heigth configured in Settings -> Configure RKWard -> Output.}

\item{quality}{For device.type "JPG", quality of the JPG file from 0 to 100.
The default is to use the quality configured in Settings -> Configure RKWard -> Output.}

\item{...}{Further options will be passed to the graphics device used internally.

\bold{Warning}: It is advised to use \code{rk.graph.off} and \bold{not} \code{dev.off} to close the device opened by
\code{rk.graph.on}. \code{dev.print(device = rk.graph.on)} is a \bold{wrong} usage for this "device," and will result in errors.}
}
\description{
\code{rk.graph.on()} creates an R device that will plot to the output html page in RKWard (\url{rkward://page/rkward_output}).
The default settings for \code{device.type}, \code{width}, \code{height}, and \code{quality} can be modified from Settings -> Configure RKWard -> Output.

\code{rk.graph.off()} closes the device that was opened by \code{rk.graph.on}.
}
\examples{
require (rkward)

## Plot directly to the output (html) file, by-passing screen device:
rk.graph.on ("JPG", 480, 480, 75)
plot (rnorm (100))
rk.graph.off ()

## Copy the displayed plot to the output:
plot (rnorm (100))
dev.copy (device = rk.graph.on)
rk.graph.off ()

## WRONG USAGE: not run:
#plot (rnorm (100))
#dev.print (device = rk.graph.on)

}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\seealso{
\link{rk.results} \link{rk.print} \link{rk.get.output.html.file} \link{dev.off} \link{svg} \link{png} \link{jpg}
}
\keyword{devices}

