/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPERTIESDIALOG2_H
#define _SC_PROPERTIESDIALOG2_H

// sc
#include "util/String.h"
#include "svn/PropListItemTypes.h"
class WcViewModel;
class PropSetParam;

// qt
#include <QtGui/QDialog>
class QPushButton;
class Q3ListView;
class QTextEdit;
class Q3ComboBox;
class QCheckBox;
class Q3ListViewItem;


class PropertiesDialog2 : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  PropertiesDialog2( const sc::String& name, bool dir, WcViewModel* model,
    QWidget *parent = 0 );
  virtual ~PropertiesDialog2();

public slots:
  void pressed( Q3ListViewItem* lvi );
  void newProp(const QString& );
  void add();
  void del();
  void set();

  /** proplist callback */
  void proplist( const sc::String& name, const svn::PropListItems& items );
  /** propset callback */
  void confirmPropSet( PropSetParam* param, bool& proceed );

private:
  void addProperty( const QString& propName, const QString& propValue );
  void delProperty();

private:
  sc::String       _name;
  bool             _dir;

  WcViewModel*     _model;

  Q3ListView*      _props;
  Q3ComboBox*      _newProp;
  QPushButton*     _add;
  QPushButton*     _del;

  QTextEdit*       _propValue;
  QCheckBox*       _recursive;
  QPushButton*     _set;

  QPushButton*     _close;
};

#endif // _SC_PROPERTIESDIALOG2_H
