/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocument;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocumentUpdater;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.fordiac.ide.ui.widget.StyledTextCellEditor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public abstract class XtextStyledTextCellEditor
extends StyledTextCellEditor {
    private EmbeddedEditor embeddedEditor;
    private boolean proposalPopupOpen;
    private final LibraryElementXtextDocumentUpdater updater = STAlgorithmEmbeddedEditorUtil.getLibraryElementXtextDocumentUpdater();

    protected XtextStyledTextCellEditor() {
    }

    protected XtextStyledTextCellEditor(Composite parent) {
        super(parent);
    }

    protected XtextStyledTextCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected StyledText createStyledText(Composite parent) {
        this.embeddedEditor = STAlgorithmEmbeddedEditorUtil.getEmbeddedEditorFactory().newEditor(this.createEditedResourceProvider()).withStyle(this.getStyle()).withParent(parent);
        this.embeddedEditor.createPartialEditor();
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.embeddedEditor.getViewer());
        this.embeddedEditor.getViewer().getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                XtextStyledTextCellEditor.this.editOccured(null);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.embeddedEditor.getViewer().getContentAssistantFacade().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                XtextStyledTextCellEditor.this.proposalPopupOpen = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                XtextStyledTextCellEditor.this.proposalPopupOpen = false;
            }
        });
        XtextDocument xtextDocument = this.embeddedEditor.getDocument();
        if (xtextDocument instanceof LibraryElementXtextDocument) {
            LibraryElementXtextDocument libDocument = (LibraryElementXtextDocument)xtextDocument;
            this.updater.install(libDocument);
            this.embeddedEditor.getViewer().getControl().addDisposeListener(event -> this.updater.uninstall());
        }
        return (StyledText)this.embeddedEditor.getViewer().getControl();
    }

    protected abstract IEditedResourceProvider createEditedResourceProvider();

    protected void doSetValue(Object value) {
        super.doSetValue(value);
        this.embeddedEditor.getViewer().getUndoManager().reset();
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void performUndo() {
        this.embeddedEditor.getViewer().getUndoManager().undo();
    }

    public boolean isRedoEnabled() {
        return true;
    }

    public void performRedo() {
        this.embeddedEditor.getViewer().getUndoManager().redo();
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected boolean isProposalPopupOpen() {
        return this.proposalPopupOpen;
    }
}

