/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeDirectlyDerivedTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;

public class ChangeDirectlyDerivedBaseTypeCommand
extends AbstractChangeDirectlyDerivedTypeCommand {
    private final DataType dataType;
    private DataType oldDataType;

    private ChangeDirectlyDerivedBaseTypeCommand(DirectlyDerivedType directlyDerivedType, DataType dataType) {
        super(directlyDerivedType);
        this.dataType = dataType;
    }

    public static ChangeDirectlyDerivedBaseTypeCommand forTypeName(DirectlyDerivedType directlyDerivedType, String typeName) {
        DataType dataType = IecTypes.ElementaryTypes.getTypeByName((String)typeName);
        return ChangeDirectlyDerivedBaseTypeCommand.forDataType(directlyDerivedType, dataType);
    }

    public static ChangeDirectlyDerivedBaseTypeCommand forDataType(DirectlyDerivedType directlyDerivedType, DataType dataType) {
        return new ChangeDirectlyDerivedBaseTypeCommand(directlyDerivedType, (DataType)Objects.requireNonNullElse(dataType, IecTypes.ElementaryTypes.STRING));
    }

    @Override
    public void doExecute() {
        this.oldDataType = this.getDirectlyDerivedType().getBaseType();
        this.getDirectlyDerivedType().setBaseType(this.dataType);
    }

    @Override
    public void doUndo() {
        this.getDirectlyDerivedType().setBaseType(this.oldDataType);
    }

    @Override
    public void doRedo() {
        this.getDirectlyDerivedType().setBaseType(this.dataType);
    }
}

