/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore.impl;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedValue;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.UsintType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.function.Functions;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeature;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedInputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedOutputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallUnnamedArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STEnumLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultiBitAccessSpecifier;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSingleArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

final class ExpressionAnnotations {
    private ExpressionAnnotations() {
    }

    static LibraryElement getResultType(STBinaryExpression expr) {
        return ExpressionAnnotations.getResultType(expr, false);
    }

    static LibraryElement getDeclaredResultType(STBinaryExpression expr) {
        return ExpressionAnnotations.getResultType(expr, true);
    }

    static LibraryElement getResultType(STBinaryExpression expr, boolean declared) {
        BoolType _xifexpression = null;
        boolean _isComparison = STCoreUtil.isComparison(expr.getOp());
        if (_isComparison) {
            _xifexpression = IecTypes.ElementaryTypes.BOOL;
        } else {
            LibraryElement _xblockexpression = null;
            LibraryElement _xifexpression_1 = null;
            if (declared) {
                STExpression _left = expr.getLeft();
                LibraryElement _declaredResultType = null;
                if (_left != null) {
                    _declaredResultType = _left.getDeclaredResultType();
                }
                _xifexpression_1 = _declaredResultType;
            } else {
                STExpression _left_1 = expr.getLeft();
                LibraryElement _resultType = null;
                if (_left_1 != null) {
                    _resultType = _left_1.getResultType();
                }
                _xifexpression_1 = _resultType;
            }
            LibraryElement left = _xifexpression_1;
            LibraryElement _xifexpression_2 = null;
            if (declared) {
                STExpression _right = expr.getRight();
                LibraryElement _declaredResultType_1 = null;
                if (_right != null) {
                    _declaredResultType_1 = _right.getDeclaredResultType();
                }
                _xifexpression_2 = _declaredResultType_1;
            } else {
                STExpression _right_1 = expr.getRight();
                LibraryElement _resultType_1 = null;
                if (_right_1 != null) {
                    _resultType_1 = _right_1.getResultType();
                }
                _xifexpression_2 = _resultType_1;
            }
            LibraryElement right = _xifexpression_2;
            LibraryElement _xifexpression_3 = null;
            if (left instanceof DataType) {
                DataType _xifexpression_4 = null;
                if (right instanceof DataType) {
                    DataType _xifexpression_5 = null;
                    boolean _isArithmetic = STCoreUtil.isArithmetic(expr.getOp());
                    if (_isArithmetic) {
                        DataType _xifexpression_6 = null;
                        if (left instanceof AnyDurationType && right instanceof AnyNumType) {
                            _xifexpression_6 = (DataType)left;
                        } else {
                            DataType _xifexpression_7 = null;
                            if (left instanceof AnyDateType && right instanceof TimeType) {
                                _xifexpression_7 = (DataType)left;
                            } else {
                                DataType _xifexpression_8 = null;
                                if (left instanceof AnyDateType && right instanceof LtimeType) {
                                    _xifexpression_8 = STCoreUtil.getEquivalentAnyLDateType(left);
                                } else {
                                    TimeType _xifexpression_9 = null;
                                    if (STCoreUtil.isInstanceofAnySDateType(left) && STCoreUtil.isInstanceofAnySDateType(right)) {
                                        _xifexpression_9 = IecTypes.ElementaryTypes.TIME;
                                    } else {
                                        LtimeType _xifexpression_10 = null;
                                        if (left instanceof AnyDateType && right instanceof AnyDateType) {
                                            _xifexpression_10 = IecTypes.ElementaryTypes.LTIME;
                                        } else {
                                            DataType _xifexpression_11 = null;
                                            if (left instanceof AnyDurationType && right instanceof AnyDurationType) {
                                                _xifexpression_11 = ExpressionAnnotations.commonSupertype((DataType)left, (DataType)right);
                                            } else {
                                                DataType _commonSupertype_1;
                                                DataType _elvis = null;
                                                DataType _commonSupertype = ExpressionAnnotations.commonSupertype((DataType)STCoreUtil.getEquivalentAnyNumType(left), (DataType)STCoreUtil.getEquivalentAnyNumType(right));
                                                _elvis = _commonSupertype != null ? _commonSupertype : (_commonSupertype_1 = ExpressionAnnotations.commonSupertype((DataType)STCoreUtil.getEquivalentAnyUnsignedType(left), (DataType)STCoreUtil.getEquivalentAnyUnsignedType(right)));
                                                _xifexpression_11 = _elvis;
                                            }
                                            _xifexpression_10 = _xifexpression_11;
                                        }
                                        _xifexpression_9 = _xifexpression_10;
                                    }
                                    _xifexpression_8 = _xifexpression_9;
                                }
                                _xifexpression_7 = _xifexpression_8;
                            }
                            _xifexpression_6 = _xifexpression_7;
                        }
                        _xifexpression_5 = _xifexpression_6;
                    } else {
                        DataType _xifexpression_12 = null;
                        boolean _isLogical = STCoreUtil.isLogical(expr.getOp());
                        if (_isLogical) {
                            _xifexpression_12 = ExpressionAnnotations.commonSupertype((DataType)STCoreUtil.getEquivalentAnyBitType(left), (DataType)STCoreUtil.getEquivalentAnyBitType(right));
                        } else {
                            DataType _xifexpression_13 = null;
                            boolean _isRange = STCoreUtil.isRange(expr.getOp());
                            _xifexpression_13 = _isRange ? ExpressionAnnotations.commonSupertype((DataType)left, (DataType)right) : null;
                            _xifexpression_12 = _xifexpression_13;
                        }
                        _xifexpression_5 = _xifexpression_12;
                    }
                    _xifexpression_4 = _xifexpression_5;
                } else {
                    DataType _xifexpression_14 = null;
                    _xifexpression_14 = declared ? (DataType)left : null;
                    _xifexpression_4 = _xifexpression_14;
                }
                _xifexpression_3 = _xifexpression_4;
            } else {
                LibraryElement _xifexpression_15 = null;
                _xifexpression_15 = declared && right instanceof DataType ? right : null;
                _xifexpression_3 = _xifexpression_15;
            }
            _xblockexpression = _xifexpression_3;
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    static LibraryElement getResultType(STUnaryExpression expr) {
        STExpression _expression = expr.getExpression();
        LibraryElement _resultType = null;
        if (_expression != null) {
            _resultType = _expression.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STUnaryExpression expr) {
        STExpression _expression = expr.getExpression();
        LibraryElement _declaredResultType = null;
        if (_expression != null) {
            _declaredResultType = _expression.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STMemberAccessExpression expr) {
        STExpression _member = expr.getMember();
        LibraryElement _resultType = null;
        if (_member != null) {
            _resultType = _member.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STMemberAccessExpression expr) {
        STExpression _member = expr.getMember();
        LibraryElement _declaredResultType = null;
        if (_member != null) {
            _declaredResultType = _member.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STArrayAccessExpression expr) {
        return ExpressionAnnotations.getResultType(expr, false);
    }

    static LibraryElement getDeclaredResultType(STArrayAccessExpression expr) {
        return ExpressionAnnotations.getResultType(expr, true);
    }

    static LibraryElement getResultType(STArrayAccessExpression expr, boolean declared) {
        CharType _xblockexpression = null;
        LibraryElement _xifexpression = null;
        if (declared) {
            STExpression _receiver = expr.getReceiver();
            LibraryElement _declaredResultType = null;
            if (_receiver != null) {
                _declaredResultType = _receiver.getDeclaredResultType();
            }
            _xifexpression = _declaredResultType;
        } else {
            STExpression _receiver_1 = expr.getReceiver();
            LibraryElement _resultType = null;
            if (_receiver_1 != null) {
                _resultType = _receiver_1.getResultType();
            }
            _xifexpression = _resultType;
        }
        LibraryElement receiverType = _xifexpression;
        CharType _switchResult = null;
        boolean _matched = false;
        if (receiverType instanceof ArrayType) {
            int _size_1;
            boolean _lessThan;
            _matched = true;
            DataType _xifexpression_1 = null;
            int _size = expr.getIndex().size();
            boolean bl = _lessThan = _size < (_size_1 = ((ArrayType)receiverType).getSubranges().size());
            if (_lessThan) {
                Functions.Function1 _function = it -> (Subrange)EcoreUtil.copy((EObject)it);
                _xifexpression_1 = STCoreUtil.newArrayType(((ArrayType)receiverType).getBaseType(), IterableExtensions.map((Iterable)IterableExtensions.drop((Iterable)((ArrayType)receiverType).getSubranges(), (int)expr.getIndex().size()), (Functions.Function1)_function));
            } else {
                _xifexpression_1 = ((ArrayType)receiverType).getBaseType();
            }
            _switchResult = _xifexpression_1;
        }
        if (!_matched && receiverType instanceof StringType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.CHAR;
        }
        if (!_matched && receiverType instanceof WstringType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.WCHAR;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    static LibraryElement getResultType(STFeatureExpression expr) {
        INamedElement _feature;
        LibraryElement _switchResult = null;
        INamedElement feature = _feature = expr.getFeature();
        boolean _matched = false;
        if (feature instanceof STStandardFunction) {
            _matched = true;
            Supplier<DataType> _function = () -> {
                LibraryElement _expectedType;
                DataType _switchResult_1 = null;
                LibraryElement type = _expectedType = STCoreUtil.getExpectedType(expr);
                boolean _matched_1 = false;
                if (type instanceof DataType) {
                    _matched_1 = true;
                    _switchResult_1 = (DataType)type;
                }
                return _switchResult_1;
            };
            Supplier<List> _function_1 = () -> {
                Functions.Function1 _function_2 = it -> it.getResultType();
                return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map(expr.getParameters(), (Functions.Function1)_function_2), DataType.class));
            };
            _switchResult = Functions.inferReturnTypeFromDataTypes((Method)((STStandardFunction)feature).getJavaMethod(), _function, _function_1);
        }
        if (!_matched) {
            _switchResult = ExpressionAnnotations.getDeclaredResultType(expr);
        }
        return _switchResult;
    }

    static LibraryElement getDeclaredResultType(STFeatureExpression expr) {
        INamedElement _feature;
        LibraryElement _switchResult = null;
        INamedElement feature = _feature = expr.getFeature();
        boolean _matched = false;
        if (feature instanceof VarDeclaration) {
            _matched = true;
        }
        if (!_matched && feature instanceof STVarDeclaration) {
            _matched = true;
        }
        if (!_matched && feature instanceof AdapterDeclaration) {
            _matched = true;
        }
        if (!_matched && feature instanceof FB) {
            boolean _not;
            boolean _isCall = expr.isCall();
            boolean bl = _not = !_isCall;
            if (_not) {
                _matched = true;
            }
        }
        if (_matched) {
            _switchResult = STCoreUtil.getFeatureType(feature);
        }
        if (!_matched && feature instanceof STStandardFunction) {
            _matched = true;
            Supplier<List> _function = () -> {
                int _size_1;
                List _xblockexpression = null;
                Functions.Function1 _function_1 = it -> it.getDeclaredResultType();
                List argumentTypes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map(expr.getParameters(), (Functions.Function1)_function_1), DataType.class));
                List _xifexpression = null;
                int _size = argumentTypes.size();
                boolean _equals = _size == (_size_1 = expr.getParameters().size());
                _xifexpression = _equals ? argumentTypes : null;
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            };
            _switchResult = Functions.inferReturnTypeFromDataTypes((Method)((STStandardFunction)feature).getJavaMethod(), null, _function);
        }
        if (!_matched && feature instanceof ICallable) {
            _matched = true;
            _switchResult = ((ICallable)feature).getReturnType();
        }
        return _switchResult;
    }

    static LibraryElement getResultType(STBuiltinFeatureExpression expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STBuiltinFeatureExpression expr) {
        FBType _switchResult = null;
        STBuiltinFeature _feature = expr.getFeature();
        if (_feature != null) {
            switch (_feature) {
                case THIS: {
                    FBType _xifexpression = null;
                    boolean _isCall = expr.isCall();
                    if (_isCall) {
                        _xifexpression = null;
                    } else {
                        Resource _eResource = expr.eResource();
                        EList _contents = null;
                        if (_eResource != null) {
                            _contents = _eResource.getContents();
                        }
                        Iterable _filter = null;
                        if (_contents != null) {
                            _filter = Iterables.filter((Iterable)_contents, FBType.class);
                        }
                        FBType _head = null;
                        if (_filter != null) {
                            _head = (FBType)IterableExtensions.head((Iterable)_filter);
                        }
                        _xifexpression = _head;
                    }
                    _switchResult = _xifexpression;
                    break;
                }
            }
        }
        return _switchResult;
    }

    static LibraryElement getResultType(STMultibitPartialExpression expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STMultibitPartialExpression expr) {
        BoolType _switchResult = null;
        STMultiBitAccessSpecifier _specifier = expr.getSpecifier();
        boolean _matched = false;
        if (Objects.equals((Object)_specifier, null)) {
            _matched = true;
        }
        if (!_matched && Objects.equals((Object)_specifier, (Object)STMultiBitAccessSpecifier.X)) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = IecTypes.ElementaryTypes.BOOL;
        }
        if (!_matched && Objects.equals((Object)_specifier, (Object)STMultiBitAccessSpecifier.B)) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.BYTE;
        }
        if (!_matched && Objects.equals((Object)_specifier, (Object)STMultiBitAccessSpecifier.W)) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.WORD;
        }
        if (!_matched && Objects.equals((Object)_specifier, (Object)STMultiBitAccessSpecifier.D)) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.DWORD;
        }
        if (!_matched && Objects.equals((Object)_specifier, (Object)STMultiBitAccessSpecifier.L)) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LWORD;
        }
        return _switchResult;
    }

    static LibraryElement getResultType(STNumericLiteral expr) {
        DataType _elvis = null;
        DataType _elvis_1 = null;
        DataType _type = expr.getType();
        if (_type != null) {
            _elvis_1 = _type;
        } else {
            boolean _checkRangeUnsigned;
            boolean _matched_1;
            Object it;
            Object _value;
            boolean _isNumericValueValid;
            LibraryElement _expectedType;
            DataType _switchResult = null;
            LibraryElement result = _expectedType = STCoreUtil.getExpectedType(expr);
            boolean _matched = false;
            if (result instanceof DataType && (_isNumericValueValid = STCoreUtil.isNumericValueValid((DataType)result, expr.getValue()))) {
                _matched = true;
                _switchResult = (DataType)result;
            }
            if (!_matched && result instanceof AnyUnsignedType) {
                _matched = true;
                UsintType _switchResult_1 = null;
                it = _value = expr.getValue();
                _matched_1 = false;
                if (it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.USINT;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.UINT;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffffffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.UDINT;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffffffffffffffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.ULINT;
                }
                if (!_matched_1) {
                    _switchResult_1 = null;
                }
                _switchResult = _switchResult_1;
            }
            if (!_matched && result instanceof AnyBitType) {
                _matched = true;
                ByteType _switchResult_1 = null;
                it = _value = expr.getValue();
                _matched_1 = false;
                if (it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.BYTE;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.WORD;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffffffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.DWORD;
                }
                if (!_matched_1 && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffffffffffffffff", 16)))) {
                    _matched_1 = true;
                    _switchResult_1 = IecTypes.ElementaryTypes.LWORD;
                }
                if (!_matched_1) {
                    _switchResult_1 = null;
                }
                _switchResult = _switchResult_1;
            }
            if (!_matched) {
                _switchResult = null;
            }
            _elvis_1 = _switchResult;
        }
        if (_elvis_1 != null) {
            _elvis = _elvis_1;
        } else {
            LibraryElement _valueType = ExpressionAnnotations.getValueType(expr);
            _elvis = _valueType;
        }
        return _elvis;
    }

    static LibraryElement getDeclaredResultType(STNumericLiteral expr) {
        DataType _elvis = null;
        DataType _type = expr.getType();
        if (_type != null) {
            _elvis = _type;
        } else {
            LibraryElement _valueType = ExpressionAnnotations.getValueType(expr);
            _elvis = _valueType;
        }
        return _elvis;
    }

    static LibraryElement getValueType(STNumericLiteral expr) {
        boolean _checkRangeUnsigned;
        boolean _checkRange;
        Object _value;
        BoolType _switchResult = null;
        Object it = _value = expr.getValue();
        boolean _matched = false;
        if (it instanceof Boolean) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.BOOL;
        }
        if (!_matched && it instanceof BigDecimal) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LREAL;
        }
        if (!_matched && it instanceof BigInteger && (_checkRange = STCoreUtil.checkRange((BigInteger)it, -128L, 127L))) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.SINT;
        }
        if (!_matched && it instanceof BigInteger && (_checkRange = STCoreUtil.checkRange((BigInteger)it, -32768L, 32767L))) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.INT;
        }
        if (!_matched && it instanceof BigInteger && (_checkRange = STCoreUtil.checkRange((BigInteger)it, Integer.MIN_VALUE, Integer.MAX_VALUE))) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.DINT;
        }
        if (!_matched && it instanceof BigInteger && (_checkRange = STCoreUtil.checkRange((BigInteger)it, Long.MIN_VALUE, Long.MAX_VALUE))) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LINT;
        }
        if (!_matched && it instanceof BigInteger && (_checkRangeUnsigned = STCoreUtil.checkRangeUnsigned((BigInteger)it, new BigInteger("ffffffffffffffff", 16)))) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.ULINT;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    static LibraryElement getResultType(STDateLiteral expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STDateLiteral expr) {
        return expr.getType();
    }

    static LibraryElement getResultType(STTimeLiteral expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STTimeLiteral expr) {
        return expr.getType();
    }

    static LibraryElement getResultType(STTimeOfDayLiteral expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STTimeOfDayLiteral expr) {
        return expr.getType();
    }

    static LibraryElement getResultType(STDateAndTimeLiteral expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STDateAndTimeLiteral expr) {
        return expr.getType();
    }

    static LibraryElement getResultType(STStringLiteral expr) {
        DataType _elvis = null;
        DataType _elvis_1 = null;
        DataType _type = expr.getType();
        if (_type != null) {
            _elvis_1 = _type;
        } else {
            boolean _isStringValueValid;
            LibraryElement _expectedType;
            DataType _switchResult = null;
            LibraryElement result = _expectedType = STCoreUtil.getExpectedType(expr);
            boolean _matched = false;
            if (result instanceof DataType && (_isStringValueValid = STCoreUtil.isStringValueValid((DataType)result, expr.getValue()))) {
                _matched = true;
                _switchResult = (DataType)result;
            }
            if (!_matched) {
                _switchResult = null;
            }
            _elvis_1 = _switchResult;
        }
        if (_elvis_1 != null) {
            _elvis = _elvis_1;
        } else {
            LibraryElement _valueType = ExpressionAnnotations.getValueType(expr);
            _elvis = _valueType;
        }
        return _elvis;
    }

    static LibraryElement getDeclaredResultType(STStringLiteral expr) {
        DataType _elvis = null;
        DataType _type = expr.getType();
        if (_type != null) {
            _elvis = _type;
        } else {
            LibraryElement _valueType = ExpressionAnnotations.getValueType(expr);
            _elvis = _valueType;
        }
        return _elvis;
    }

    static LibraryElement getValueType(STStringLiteral expr) {
        boolean _equals;
        WcharType _xifexpression = null;
        int _length = expr.getValue().length();
        boolean bl = _equals = _length == 1;
        if (_equals) {
            Object _xifexpression_1 = null;
            boolean _isWide = expr.getValue().isWide();
            _xifexpression_1 = _isWide ? IecTypes.ElementaryTypes.WCHAR : IecTypes.ElementaryTypes.CHAR;
            _xifexpression = _xifexpression_1;
        } else {
            Object _xifexpression_2 = null;
            boolean _isWide_1 = expr.getValue().isWide();
            _xifexpression_2 = _isWide_1 ? IecTypes.ElementaryTypes.WSTRING : IecTypes.ElementaryTypes.STRING;
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    static LibraryElement getResultType(STEnumLiteral expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STEnumLiteral expr) {
        EnumeratedValue _value = expr.getValue();
        EnumeratedType _type = null;
        if (_value != null) {
            _type = _value.getType();
        }
        return _type;
    }

    static LibraryElement getResultType(STCallUnnamedArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _resultType = null;
        if (_argument != null) {
            _resultType = _argument.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STCallUnnamedArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _declaredResultType = null;
        if (_argument != null) {
            _declaredResultType = _argument.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STCallNamedInputArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _resultType = null;
        if (_argument != null) {
            _resultType = _argument.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STCallNamedInputArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _declaredResultType = null;
        if (_argument != null) {
            _declaredResultType = _argument.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STCallNamedOutputArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _resultType = null;
        if (_argument != null) {
            _resultType = _argument.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STCallNamedOutputArgument arg) {
        STExpression _argument = arg.getArgument();
        LibraryElement _declaredResultType = null;
        if (_argument != null) {
            _declaredResultType = _argument.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STElementaryInitializerExpression expr) {
        STExpression _value = expr.getValue();
        LibraryElement _resultType = null;
        if (_value != null) {
            _resultType = _value.getResultType();
        }
        return _resultType;
    }

    static LibraryElement getDeclaredResultType(STElementaryInitializerExpression expr) {
        STExpression _value = expr.getValue();
        LibraryElement _declaredResultType = null;
        if (_value != null) {
            _declaredResultType = _value.getDeclaredResultType();
        }
        return _declaredResultType;
    }

    static LibraryElement getResultType(STArrayInitializerExpression expr) {
        LibraryElement _elvis = null;
        LibraryElement _expectedType = STCoreUtil.getExpectedType(expr);
        if (_expectedType != null) {
            _elvis = _expectedType;
        } else {
            LibraryElement _addDimension;
            Functions.Function1 _function = it -> it.getResultType();
            Functions.Function2 _function_1 = (first, second) -> ExpressionAnnotations.commonSupertype(first, second);
            _elvis = _addDimension = ExpressionAnnotations.addDimension((INamedElement)IterableExtensions.reduce((Iterable)ListExtensions.map(expr.getValues(), (Functions.Function1)_function), (Functions.Function2)_function_1), expr);
        }
        return _elvis;
    }

    static LibraryElement getDeclaredResultType(STArrayInitializerExpression expr) {
        LibraryElement _elvis = null;
        LibraryElement _expectedType = STCoreUtil.getExpectedType(expr);
        if (_expectedType != null) {
            _elvis = _expectedType;
        } else {
            LibraryElement _addDimension;
            Functions.Function1 _function = it -> it.getDeclaredResultType();
            Functions.Function2 _function_1 = (first, second) -> ExpressionAnnotations.commonSupertype(first, second);
            _elvis = _addDimension = ExpressionAnnotations.addDimension((INamedElement)IterableExtensions.reduce((Iterable)ListExtensions.map(expr.getValues(), (Functions.Function1)_function), (Functions.Function2)_function_1), expr);
        }
        return _elvis;
    }

    static LibraryElement getResultType(STSingleArrayInitElement expr) {
        return expr.getInitExpression().getResultType();
    }

    static LibraryElement getDeclaredResultType(STSingleArrayInitElement expr) {
        return expr.getInitExpression().getDeclaredResultType();
    }

    static LibraryElement getResultType(STRepeatArrayInitElement expr) {
        Functions.Function1 _function = it -> it.getResultType();
        Functions.Function2 _function_1 = (first, second) -> ExpressionAnnotations.commonSupertype(first, second);
        return (LibraryElement)IterableExtensions.reduce((Iterable)ListExtensions.map(expr.getInitExpressions(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    static LibraryElement getDeclaredResultType(STRepeatArrayInitElement expr) {
        Functions.Function1 _function = it -> it.getDeclaredResultType();
        Functions.Function2 _function_1 = (first, second) -> ExpressionAnnotations.commonSupertype(first, second);
        return (LibraryElement)IterableExtensions.reduce((Iterable)ListExtensions.map(expr.getInitExpressions(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    static LibraryElement getResultType(STStructInitializerExpression expr) {
        LibraryElement _expectedType;
        LibraryElement _elvis = null;
        LibraryElement _declaredResultType = ExpressionAnnotations.getDeclaredResultType(expr);
        _elvis = _declaredResultType != null ? _declaredResultType : (_expectedType = STCoreUtil.getExpectedType(expr));
        return _elvis;
    }

    static LibraryElement getDeclaredResultType(STStructInitializerExpression expr) {
        return expr.getType();
    }

    static LibraryElement getResultType(STStructInitElement expr) {
        return ExpressionAnnotations.getDeclaredResultType(expr);
    }

    static LibraryElement getDeclaredResultType(STStructInitElement expr) {
        return STCoreUtil.getFeatureType(expr.getVariable());
    }

    static Map<ITypedElement, STCallArgument> getMappedInputArguments(STFeatureExpression expr) {
        return ExpressionAnnotations.computeMappedInputArguments(expr.getFeature(), expr.getParameters());
    }

    static Map<ITypedElement, STCallArgument> getMappedOutputArguments(STFeatureExpression expr) {
        return ExpressionAnnotations.computeMappedOutputArguments(expr.getFeature(), expr.getParameters());
    }

    static Map<ITypedElement, STCallArgument> getMappedInOutArguments(STFeatureExpression expr) {
        return ExpressionAnnotations.computeMappedInOutArguments(expr.getFeature(), expr.getParameters());
    }

    static Map<ITypedElement, STCallArgument> getMappedInputArguments(STBuiltinFeatureExpression expr) {
        Map<ITypedElement, STCallArgument> _switchResult = null;
        STBuiltinFeature _feature = expr.getFeature();
        if (_feature != null) {
            switch (_feature) {
                case THIS: {
                    Resource _eResource = expr.eResource();
                    EList _contents = null;
                    if (_eResource != null) {
                        _contents = _eResource.getContents();
                    }
                    Iterable _filter = null;
                    if (_contents != null) {
                        _filter = Iterables.filter((Iterable)_contents, FBType.class);
                    }
                    FBType _head = null;
                    if (_filter != null) {
                        _head = (FBType)IterableExtensions.head((Iterable)_filter);
                    }
                    Map<ITypedElement, STCallArgument> _computeMappedInputArguments = null;
                    if (_head != null) {
                        _computeMappedInputArguments = ExpressionAnnotations.computeMappedInputArguments((INamedElement)_head, expr.getParameters());
                    }
                    _switchResult = _computeMappedInputArguments;
                    break;
                }
            }
        }
        return _switchResult;
    }

    static Map<ITypedElement, STCallArgument> getMappedOutputArguments(STBuiltinFeatureExpression expr) {
        Map<ITypedElement, STCallArgument> _switchResult = null;
        STBuiltinFeature _feature = expr.getFeature();
        if (_feature != null) {
            switch (_feature) {
                case THIS: {
                    Resource _eResource = expr.eResource();
                    EList _contents = null;
                    if (_eResource != null) {
                        _contents = _eResource.getContents();
                    }
                    Iterable _filter = null;
                    if (_contents != null) {
                        _filter = Iterables.filter((Iterable)_contents, FBType.class);
                    }
                    FBType _head = null;
                    if (_filter != null) {
                        _head = (FBType)IterableExtensions.head((Iterable)_filter);
                    }
                    Map<ITypedElement, STCallArgument> _computeMappedOutputArguments = null;
                    if (_head != null) {
                        _computeMappedOutputArguments = ExpressionAnnotations.computeMappedOutputArguments((INamedElement)_head, expr.getParameters());
                    }
                    _switchResult = _computeMappedOutputArguments;
                    break;
                }
            }
        }
        return _switchResult;
    }

    static Map<ITypedElement, STCallArgument> getMappedInOutArguments(STBuiltinFeatureExpression expr) {
        Map<ITypedElement, STCallArgument> _switchResult = null;
        STBuiltinFeature _feature = expr.getFeature();
        if (_feature != null) {
            switch (_feature) {
                case THIS: {
                    Resource _eResource = expr.eResource();
                    EList _contents = null;
                    if (_eResource != null) {
                        _contents = _eResource.getContents();
                    }
                    Iterable _filter = null;
                    if (_contents != null) {
                        _filter = Iterables.filter((Iterable)_contents, FBType.class);
                    }
                    FBType _head = null;
                    if (_filter != null) {
                        _head = (FBType)IterableExtensions.head((Iterable)_filter);
                    }
                    Map<ITypedElement, STCallArgument> _computeMappedInOutArguments = null;
                    if (_head != null) {
                        _computeMappedInOutArguments = ExpressionAnnotations.computeMappedInOutArguments((INamedElement)_head, expr.getParameters());
                    }
                    _switchResult = _computeMappedInOutArguments;
                    break;
                }
            }
        }
        return _switchResult;
    }

    static Map<ITypedElement, STCallArgument> computeMappedInputArguments(INamedElement feature, Collection<STCallArgument> arguments) {
        Map _xifexpression = null;
        if (feature instanceof ICallable) {
            Map _xblockexpression = null;
            List<? extends ITypedElement> parameters = STCoreUtil.computeInputParameters((ICallable)feature, arguments);
            Map _xifexpression_1 = null;
            STCallArgument _head = (STCallArgument)IterableExtensions.head(arguments);
            if (_head instanceof STCallUnnamedArgument) {
                Functions.Function1 _function = parameter -> {
                    STCallArgument _xblockexpression_1 = null;
                    int index = parameters.indexOf(parameter);
                    STCallArgument _xifexpression_2 = null;
                    int _size = arguments.size();
                    boolean _lessThan = index < _size;
                    _xifexpression_2 = _lessThan ? ((STCallArgument[])Conversions.unwrapArray((Object)arguments, STCallArgument.class))[index] : null;
                    _xblockexpression_1 = _xifexpression_2;
                    return _xblockexpression_1;
                };
                _xifexpression_1 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function));
            } else {
                Map _xblockexpression_1 = null;
                Functions.Function1 _function_1 = it -> it.getParameter().getName();
                Map namedArguments = IterableExtensions.toMap((Iterable)Iterables.filter(arguments, STCallNamedInputArgument.class), (Functions.Function1)_function_1);
                Functions.Function1 _function_2 = parameter -> (STCallNamedInputArgument)namedArguments.get(parameter.getName());
                _xblockexpression_1 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function_2));
                _xifexpression_1 = _xblockexpression_1;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = CollectionLiterals.emptyMap();
        }
        return _xifexpression;
    }

    static Map<ITypedElement, STCallArgument> computeMappedOutputArguments(INamedElement feature, Collection<STCallArgument> arguments) {
        Map _xifexpression = null;
        if (feature instanceof ICallable) {
            Map _xblockexpression = null;
            List<? extends ITypedElement> parameters = STCoreUtil.computeOutputParameters((ICallable)feature, arguments);
            Map _xifexpression_1 = null;
            STCallArgument _head = (STCallArgument)IterableExtensions.head(arguments);
            if (_head instanceof STCallUnnamedArgument) {
                Map _xblockexpression_1 = null;
                int inputCount = ((ICallable)feature).getInputParameters().size();
                int inOutCount = ((ICallable)feature).getInOutParameters().size();
                Functions.Function1 _function = parameter -> {
                    STCallArgument _xblockexpression_2 = null;
                    int _indexOf = parameters.indexOf(parameter);
                    int index = inputCount + inOutCount + _indexOf;
                    STCallArgument _xifexpression_2 = null;
                    int _size = arguments.size();
                    boolean _lessThan = index < _size;
                    _xifexpression_2 = _lessThan ? ((STCallArgument[])Conversions.unwrapArray((Object)arguments, STCallArgument.class))[index] : null;
                    _xblockexpression_2 = _xifexpression_2;
                    return _xblockexpression_2;
                };
                _xblockexpression_1 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function));
                _xifexpression_1 = _xblockexpression_1;
            } else {
                Map _xblockexpression_2 = null;
                Functions.Function1 _function = it -> it.getParameter().getName();
                Map namedArguments = IterableExtensions.toMap((Iterable)Iterables.filter(arguments, STCallNamedOutputArgument.class), (Functions.Function1)_function);
                Functions.Function1 _function_1 = parameter -> (STCallNamedOutputArgument)namedArguments.get(parameter.getName());
                _xifexpression_1 = _xblockexpression_2 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function_1));
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = CollectionLiterals.emptyMap();
        }
        return _xifexpression;
    }

    static Map<ITypedElement, STCallArgument> computeMappedInOutArguments(INamedElement feature, Collection<STCallArgument> arguments) {
        Map _xifexpression = null;
        if (feature instanceof ICallable) {
            Map _xblockexpression = null;
            List<? extends ITypedElement> parameters = STCoreUtil.computeInOutParameters((ICallable)feature, arguments);
            Map _xifexpression_1 = null;
            STCallArgument _head = (STCallArgument)IterableExtensions.head(arguments);
            if (_head instanceof STCallUnnamedArgument) {
                Map _xblockexpression_1 = null;
                int inputCount = ((ICallable)feature).getInputParameters().size();
                Functions.Function1 _function = parameter -> {
                    STCallArgument _xblockexpression_2 = null;
                    int _indexOf = parameters.indexOf(parameter);
                    int index = inputCount + _indexOf;
                    STCallArgument _xifexpression_2 = null;
                    int _size = arguments.size();
                    boolean _lessThan = index < _size;
                    _xifexpression_2 = _lessThan ? ((STCallArgument[])Conversions.unwrapArray((Object)arguments, STCallArgument.class))[index] : null;
                    _xblockexpression_2 = _xifexpression_2;
                    return _xblockexpression_2;
                };
                _xifexpression_1 = _xblockexpression_1 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function));
            } else {
                Map _xblockexpression_2 = null;
                Functions.Function1 _function = it -> it.getParameter().getName();
                Map namedArguments = IterableExtensions.toMap((Iterable)Iterables.filter(arguments, STCallNamedInputArgument.class), (Functions.Function1)_function);
                Functions.Function1 _function_1 = parameter -> (STCallNamedInputArgument)namedArguments.get(parameter.getName());
                _xblockexpression_2 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap(parameters, (Functions.Function1)_function_1));
                _xifexpression_1 = _xblockexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = CollectionLiterals.emptyMap();
        }
        return _xifexpression;
    }

    static Map<INamedElement, STInitializerExpression> getMappedStructInitElements(STStructInitializerExpression expr) {
        Map _xblockexpression = null;
        LibraryElement struct = expr.getResultType();
        Map _xifexpression = null;
        if (struct instanceof StructuredType) {
            Map _xblockexpression_1 = null;
            Functions.Function1 _function = it -> it.getVariable();
            Map namedInitElements = IterableExtensions.toMap(expr.getValues(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = parameter -> {
                STStructInitElement _get = (STStructInitElement)namedInitElements.get(parameter);
                STInitializerExpression _value = null;
                if (_get != null) {
                    _value = _get.getValue();
                }
                return _value;
            };
            _xifexpression = _xblockexpression_1 = Collections.unmodifiableMap(IterableExtensions.toInvertedMap((Iterable)((StructuredType)struct).getMemberVariables(), (Functions.Function1)_function_1));
        } else {
            _xifexpression = CollectionLiterals.emptyMap();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    static LibraryElement addDimension(INamedElement type, STArrayInitializerExpression expr) {
        ArrayType _xtrycatchfinallyexpression = null;
        try {
            ArrayType _xblockexpression = null;
            Functions.Function1 _function = it -> {
                int _switchResult = 0;
                boolean _matched = false;
                if (it instanceof STRepeatArrayInitElement) {
                    _matched = true;
                    _switchResult = ((STRepeatArrayInitElement)it).getRepetitions().intValueExact();
                }
                if (!_matched) {
                    _switchResult = 1;
                }
                return _switchResult;
            };
            Functions.Function2 _function_1 = (a, b) -> a + b;
            Integer size = (Integer)IterableExtensions.fold((Iterable)ListExtensions.map(expr.getValues(), (Functions.Function1)_function), (Object)0, (Functions.Function2)_function_1);
            ArrayType _xifexpression = null;
            if (type instanceof ArrayType) {
                DataType _baseType = ((ArrayType)type).getBaseType();
                Subrange _newSubrange = STCoreUtil.newSubrange(0, size - 1);
                Functions.Function1 _function_2 = it -> (Subrange)EcoreUtil.copy((EObject)it);
                List _map = ListExtensions.map((List)((ArrayType)type).getSubranges(), (Functions.Function1)_function_2);
                Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Subrange[]{_newSubrange})), (Iterable)_map);
                _xifexpression = STCoreUtil.newArrayType(_baseType, _plus);
            } else {
                ArrayType _xifexpression_1 = null;
                if (type instanceof DataType) {
                    _xifexpression_1 = STCoreUtil.newArrayType((DataType)type, STCoreUtil.newSubrange(0, size - 1));
                }
                _xifexpression = _xifexpression_1;
            }
            _xtrycatchfinallyexpression = _xblockexpression = _xifexpression;
        }
        catch (Throwable _t) {
            if (_t instanceof ArithmeticException) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    static LibraryElement commonSupertype(LibraryElement first, LibraryElement second) {
        LibraryElement _xifexpression = null;
        boolean _equals = Objects.equals(first, second);
        if (_equals) {
            _xifexpression = first;
        } else {
            DataType _xifexpression_1 = null;
            if (first instanceof DataType) {
                DataType _xifexpression_2 = null;
                if (second instanceof DataType) {
                    DataType _xifexpression_3 = null;
                    boolean _isAssignableFrom = ((DataType)first).isAssignableFrom((DataType)second);
                    if (_isAssignableFrom) {
                        _xifexpression_3 = (DataType)first;
                    } else {
                        DataType _xifexpression_4 = null;
                        boolean _isAssignableFrom_1 = ((DataType)second).isAssignableFrom((DataType)first);
                        if (_isAssignableFrom_1) {
                            _xifexpression_4 = (DataType)second;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    static DataType commonSupertype(DataType first, DataType second) {
        DataType _xifexpression = null;
        if (first == null) {
            _xifexpression = second;
        } else {
            DataType _xifexpression_1 = null;
            if (second == null) {
                _xifexpression_1 = first;
            } else {
                DataType _xifexpression_2 = null;
                boolean _isAssignableFrom = first.isAssignableFrom(second);
                if (_isAssignableFrom) {
                    _xifexpression_2 = first;
                } else {
                    Object _xifexpression_3 = null;
                    boolean _isAssignableFrom_1 = second.isAssignableFrom(first);
                    _xifexpression_3 = _isAssignableFrom_1 ? second : null;
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }
}

