/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public final class ImportHelper {
    public static final String PACKAGE_NAME_DELIMITER = "::";
    public static final String WILDCARD_IMPORT = "*";
    public static final String WILDCARD_IMPORT_SUFFIX = "::*";
    public static final Set<String> IMPLICIT_IMPORTS = Set.of("eclipse4diac::convert", "eclipse4diac::core", "eclipse4diac::io", "eclipse4diac::reconfiguration", "eclipse4diac::rtevents", "eclipse4diac::utils", "eclipse4diac::utils::signals", "eclipse4diac::utils::timing", "iec61131::arithmetic", "iec61131::bistableElements", "iec61131::bitwiseOperators", "iec61131::charString", "iec61131::comparison", "iec61131::conversion", "iec61131::counters", "iec61131::edgeDetection", "iec61131::numerical", "iec61131::selection", "iec61131::timers", "iec61499::events", "iec61499::events::timers", "iec61499::net", "iec61499::system");

    public static List<Import> getImports(LibraryElement libraryElement) {
        CompilerInfo compilerInfo;
        if (libraryElement != null && (compilerInfo = libraryElement.getCompilerInfo()) != null) {
            return compilerInfo.getImports();
        }
        return Collections.emptyList();
    }

    public static EList<Import> getMutableImports(LibraryElement libraryElement) {
        CompilerInfo compilerInfo = libraryElement.getCompilerInfo();
        if (compilerInfo == null) {
            compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
            libraryElement.setCompilerInfo(compilerInfo);
        }
        return compilerInfo.getImports();
    }

    public static List<Import> getContainerImports(EObject object) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)object);
        if (eObject instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)eObject;
            return ImportHelper.getImports(libraryElement);
        }
        return Collections.emptyList();
    }

    public static <T> T resolveImport(String name, EObject context, Function<String, T> typeResolver, Function<String, T> fallbackTypeResolver) {
        String packageName = PackageNameHelper.getContainerPackageName(context);
        List<Import> imports = ImportHelper.getContainerImports(context);
        return ImportHelper.resolveImport(name, packageName, imports, typeResolver, fallbackTypeResolver);
    }

    public static <T> T resolveImport(String name, String packageName, List<Import> imports, Function<String, T> typeResolver, Function<String, T> fallbackTypeResolver) {
        T result = typeResolver.apply(name);
        if (result != null) {
            return result;
        }
        if (packageName != null && !packageName.isEmpty() && (result = typeResolver.apply(packageName + PACKAGE_NAME_DELIMITER + name)) != null) {
            return result;
        }
        for (Import imp : imports) {
            Object importedNamespace = imp.getImportedNamespace();
            if (((String)importedNamespace).endsWith(WILDCARD_IMPORT_SUFFIX)) {
                importedNamespace = ((String)importedNamespace).substring(0, ((String)importedNamespace).length() - 3) + PACKAGE_NAME_DELIMITER + name;
            } else if (!((String)importedNamespace).endsWith(PACKAGE_NAME_DELIMITER + name)) continue;
            T imported = typeResolver.apply((String)importedNamespace);
            if (imported == null) continue;
            if (result != null && result != imported) {
                return null;
            }
            result = imported;
        }
        if (result != null) {
            return result;
        }
        for (String importedNamespace : IMPLICIT_IMPORTS) {
            T imported = typeResolver.apply(importedNamespace + PACKAGE_NAME_DELIMITER + name);
            if (imported == null) continue;
            if (result != null && result != imported) {
                return null;
            }
            result = imported;
        }
        if (result != null) {
            return result;
        }
        return fallbackTypeResolver.apply(name);
    }

    public static String deresolveImport(LibraryElement imported, EObject context) {
        if (imported == null) {
            return null;
        }
        if (PackageNameHelper.getPackageName(imported).isEmpty()) {
            return imported.getName();
        }
        String importedName = PackageNameHelper.getFullTypeName(imported);
        String packageName = PackageNameHelper.getContainerPackageName(context);
        List<Import> imports = ImportHelper.getContainerImports(context);
        return ImportHelper.deresolveImport(importedName, packageName, imports);
    }

    public static String deresolveImport(String importedName, String packageName, List<Import> imports) {
        String name = PackageNameHelper.extractPlainTypeName(importedName);
        if (packageName != null && !packageName.isEmpty() && importedName.equalsIgnoreCase(packageName + PACKAGE_NAME_DELIMITER + name)) {
            return name;
        }
        for (Import imp : imports) {
            String importedNamespace = imp.getImportedNamespace();
            if (!importedName.equalsIgnoreCase(importedNamespace) && (!importedNamespace.endsWith(WILDCARD_IMPORT_SUFFIX) || !importedName.equalsIgnoreCase(importedNamespace.substring(0, importedNamespace.length() - 3) + PACKAGE_NAME_DELIMITER + name))) continue;
            return name;
        }
        return importedName;
    }

    public static void organizeImports(LibraryElement libraryElement, Set<String> usedTypes, boolean remove) {
        String packageName = PackageNameHelper.getPackageName(libraryElement);
        EList<Import> imports = ImportHelper.getMutableImports(libraryElement);
        HashSet imported = new HashSet(usedTypes.stream().filter(imp -> !ImportHelper.isImplicitImport(imp, packageName)).collect(Collectors.toMap(PackageNameHelper::extractPlainTypeName, Function.identity(), (a, b) -> ImportHelper.mergeImportedTypes(a, b, (List<Import>)imports))).values());
        if (remove) {
            imports.removeIf(imp -> !imported.remove(imp.getImportedNamespace()));
        } else {
            imports.forEach(imp -> {
                boolean bl = imported.remove(imp.getImportedNamespace());
            });
        }
        imported.stream().map(ImportHelper::createImport).forEachOrdered(arg_0 -> imports.add(arg_0));
        ECollections.sort(imports, Comparator.comparing(Import::getImportedNamespace));
    }

    private static String mergeImportedTypes(String first, String second, List<Import> imports) {
        if (ImportHelper.matchesImports(first, imports)) {
            return first;
        }
        if (ImportHelper.matchesImports(second, imports)) {
            return second;
        }
        return null;
    }

    public static boolean matchesImports(String name, LibraryElement libraryElement) {
        return ImportHelper.getImports(libraryElement).stream().anyMatch(imp -> ImportHelper.matchesImport(name, imp));
    }

    public static boolean matchesImports(String name, List<Import> imports) {
        return imports.stream().anyMatch(imp -> ImportHelper.matchesImport(name, imp));
    }

    private static boolean matchesImport(String name, Import imp) {
        String importedNamespace = imp.getImportedNamespace();
        return importedNamespace.equalsIgnoreCase(name) || importedNamespace.endsWith(WILDCARD_IMPORT_SUFFIX) && PackageNameHelper.extractPackageName(importedNamespace).equalsIgnoreCase(PackageNameHelper.extractPackageName(name));
    }

    public static boolean isImplicitImport(String imported, String packageName) {
        int lastDelimiterIndex = imported.lastIndexOf(PACKAGE_NAME_DELIMITER);
        return lastDelimiterIndex < 0 || imported.substring(0, lastDelimiterIndex).equals(packageName);
    }

    protected static Import createImport(String importedNamespace) {
        Import result = LibraryElementFactory.eINSTANCE.createImport();
        result.setImportedNamespace(importedNamespace);
        return result;
    }

    private ImportHelper() {
        throw new UnsupportedOperationException();
    }
}

