/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.evaluation.NumberUtil;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.UMLReflection;

public abstract class AbstractEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractVisitor<Object, C, O, P, EL, PM, S, COA, SSA, CT>
implements EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static Set<String> BOOLEAN_CONSTRAINTS = new HashSet<String>();
    private EvaluationEnvironment<C, O, P, CLS, E> evalEnv;
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env;
    private OCLStandardLibrary<C> stdlib;
    private Map<? extends CLS, ? extends Set<? extends E>> extentMap;
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor;

    static {
        BOOLEAN_CONSTRAINTS.add("invariant");
        BOOLEAN_CONSTRAINTS.add("precondition");
        BOOLEAN_CONSTRAINTS.add("postcondition");
    }

    protected AbstractEvaluationVisitor(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EvaluationEnvironment<C, O, P, CLS, E> evalEnv, Map<? extends CLS, ? extends Set<? extends E>> extentMap) {
        this.evalEnv = evalEnv;
        this.env = env;
        this.stdlib = env.getOCLStandardLibrary();
        this.extentMap = extentMap;
        this.visitor = this;
    }

    protected final EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getVisitor() {
        return this.visitor;
    }

    protected void setEvaluationEnvironment(EvaluationEnvironment<C, O, P, CLS, E> evaluationEnvironment) {
        if (evaluationEnvironment == null) {
            throw new IllegalArgumentException("null evaluation environment");
        }
        this.evalEnv = evaluationEnvironment;
    }

    void setVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor) {
        this.visitor = visitor;
    }

    @Override
    public EvaluationEnvironment<C, O, P, CLS, E> getEvaluationEnvironment() {
        return this.evalEnv;
    }

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEnvironment() {
        return this.env;
    }

    protected UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> getUMLReflection() {
        return this.env.getUMLReflection();
    }

    @Override
    public Map<? extends CLS, ? extends Set<? extends E>> getExtentMap() {
        return this.extentMap;
    }

    protected OCLStandardLibrary<C> getStandardLibrary() {
        return this.stdlib;
    }

    protected final Object getInvalid() {
        return this.getStandardLibrary().getInvalid();
    }

    protected final C getBoolean() {
        return this.getStandardLibrary().getBoolean();
    }

    protected final C getString() {
        return this.getStandardLibrary().getString();
    }

    protected final C getInteger() {
        return this.getStandardLibrary().getInteger();
    }

    protected final C getUnlimitedNatural() {
        return this.getStandardLibrary().getUnlimitedNatural();
    }

    protected final C getReal() {
        return this.getStandardLibrary().getReal();
    }

    protected String getName(Object namedElement) {
        return this.getEnvironment().getUMLReflection().getName(namedElement);
    }

    @Override
    public Object visitExpression(OCLExpression<C> expression) {
        try {
            return expression.accept(this.getVisitor());
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = OCLMessages.no_message;
            }
            OCLPlugin.log(2, 10, OCLMessages.bind(OCLMessages.EvaluationFailed_ERROR_, msg), e);
            return this.getInvalid();
        }
    }

    @Override
    public Object visitConstraint(CT constraint) {
        OCLExpression<C> body = this.getSpecification(constraint).getBodyExpression();
        boolean isBoolean = BOOLEAN_CONSTRAINTS.contains(this.getEnvironment().getUMLReflection().getStereotype(constraint));
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        if (isBoolean && body.getType() != this.getBoolean()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Object result = this.getVisitor().visitExpression(body);
        return isBoolean ? Boolean.valueOf(Boolean.TRUE.equals(result)) : result;
    }

    @Override
    protected ExpressionInOCL<C, PM> getSpecification(CT constraint) {
        return this.getEnvironment().getUMLReflection().getSpecification(constraint);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    protected boolean isUndefined(Object value) {
        return value == null || value == this.getEnvironment().getOCLStandardLibrary().getInvalid();
    }

    protected Object call(O operation, OCLExpression<C> body, Object target, Object[] args) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> myEnv = this.getEnvironment();
        EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> factory = myEnv.getFactory();
        EvaluationEnvironment<C, O, P, CLS, E> nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
        nested.add("self", target);
        if (args.length > 0) {
            int i = 0;
            for (PM param : myEnv.getUMLReflection().getParameters(operation)) {
                nested.add(myEnv.getUMLReflection().getName(param), args[i++]);
            }
        }
        return factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap()).visitExpression(body);
    }

    protected OCLExpression<C> getOperationBody(O operation) {
        OCLExpression<C> result = null;
        CT body = this.env.getDefinition(operation);
        if (body == null) {
            body = this.env.getBodyCondition(operation);
        }
        if (body != null) {
            result = this.env.getUMLReflection().getSpecification(body).getBodyExpression();
        }
        return result;
    }

    protected OCLExpression<C> getPropertyBody(P property) {
        OCLExpression<C> result = null;
        CT body = this.env.getDefinition(property);
        if (body == null) {
            body = this.env.getDeriveConstraint(property);
        }
        if (body != null) {
            result = this.env.getUMLReflection().getSpecification(body).getBodyExpression();
        }
        return result;
    }

    protected Object navigate(P property, OCLExpression<C> derivation, Object target) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> myEnv = this.getEnvironment();
        EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> factory = myEnv.getFactory();
        EvaluationEnvironment<C, O, P, CLS, E> nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
        nested.add("self", target);
        return factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap()).visitExpression(derivation);
    }

    protected Boolean oclIsTypeOf(Object value, Object typeArg) {
        Object type = typeArg;
        if (type == null) {
            return null;
        }
        if (value == null) {
            return this.isLaxNullHandling() ? Boolean.valueOf(type instanceof VoidType) : null;
        }
        if (value == this.stdlib.getInvalid()) {
            return this.isLaxNullHandling() ? Boolean.valueOf(type instanceof InvalidType) : null;
        }
        return this.getEvaluationEnvironment().isTypeOf(value, type);
    }

    protected Boolean oclIsKindOf(Object value, Object typeArg) {
        Object type = typeArg;
        if (type == null) {
            return null;
        }
        if (value == null) {
            return this.isLaxNullHandling() ? Boolean.valueOf(Boolean.valueOf(type instanceof InvalidType) == false) : null;
        }
        if (value == this.stdlib.getInvalid()) {
            return this.isLaxNullHandling() ? Boolean.TRUE : null;
        }
        return this.getEvaluationEnvironment().isKindOf(value, type);
    }

    protected Number coerceNumber(Number number) {
        return NumberUtil.coerceNumber(number);
    }

    protected Number higherPrecisionNumber(Number number) {
        return NumberUtil.higherPrecisionNumber(number);
    }

    protected boolean isLaxNullHandling() {
        return EvaluationOptions.getValue(this.getEvaluationEnvironment(), EvaluationOptions.LAX_NULL_HANDLING);
    }

    protected Object safeVisitExpression(OCLExpression<C> exp) {
        Object sourceVal;
        try {
            sourceVal = exp.accept(this.getVisitor());
        }
        catch (EvaluationHaltedException ehe) {
            throw ehe;
        }
        catch (RuntimeException e) {
            sourceVal = this.getInvalid();
        }
        return sourceVal;
    }
}

