/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

public class TypeUtil {
    private TypeUtil() {
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean isOclAnyOperation(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        return env.getUMLReflection().getOwningClassifier(operation) instanceof AnyType;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> O findOperationMatching(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name, List<? extends TypedElement<C>> args) {
        return TypeUtil.getTypeCheckerAdapter(env).findOperationMatching(owner, name, args);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C findSignalMatching(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C receiver, List<C> signals, String name, List<? extends TypedElement<C>> args) {
        return TypeUtil.getTypeCheckerAdapter(env).findSignalMatching(receiver, signals, name, args);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> List<O> getOperations(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner) {
        return TypeUtil.getTypeCheckerAdapter(env).getOperations(owner);
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> String getName(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object element) {
        return element == null ? null : env.getUMLReflection().getName(element);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> P findAttribute(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name) {
        return TypeUtil.getTypeCheckerAdapter(env).findAttribute(owner, name);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> List<P> getAttributes(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner) {
        return TypeUtil.getTypeCheckerAdapter(env).getAttributes(owner);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean matchArgs(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, List<?> paramsOrProperties, List<? extends TypedElement<C>> args) {
        return TypeUtil.getTypeCheckerAdapter(env).matchArgs(owner, paramsOrProperties, args);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> O resolveGenericSignature(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        return TypeUtil.getTypeCheckerAdapter(env).resolveGenericSignature(owner, oper);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getPropertyType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, P property) {
        return TypeUtil.getTypeCheckerAdapter(env).getPropertyType(owner, property);
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getResultType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        return TypeUtil.getResultType(null, env, owner, oper);
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getResultType(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        List<PM> parameters = uml.getParameters(oper);
        ArrayList args = new ArrayList(parameters.size());
        for (PM param : parameters) {
            C paramType = TypeUtil.resolveType(env, uml.getOCLType(param));
            Variable var = env.getOCLFactory().createVariable();
            if (paramType instanceof TypeType) {
                TypeType typeType = (TypeType)paramType;
                if (typeType.getReferredType() == null) {
                    var.setType(stdlib.getT());
                } else {
                    var.setType(typeType.getReferredType());
                }
            } else {
                CollectionType ct;
                if (paramType instanceof CollectionType && (ct = (CollectionType)paramType).getElementType() == stdlib.getT2()) {
                    paramType = TypeUtil.resolveCollectionType(env, ct.getKind(), stdlib.getT());
                }
                var.setType(paramType);
            }
            args.add(var);
        }
        return TypeUtil.getResultType(problemObject, env, owner, oper, args);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getResultType(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O operation, List<? extends TypedElement<C>> args) {
        return TypeUtil.getTypeCheckerAdapter(env).getResultType(problemObject, owner, operation, args);
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean type1AsType2(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) throws SemanticException {
        if (TypeUtil.typeCompare(env, type1, type2) != -1) {
            return true;
        }
        String message = OCLMessages.bind(OCLMessages.CastTypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
        throw new SemanticException(message);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean exactTypeMatch(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        return TypeUtil.getTypeCheckerAdapter(env).exactTypeMatch(type1, type2);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean compatibleTypeMatch(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        return TypeUtil.getTypeCheckerAdapter(env).compatibleTypeMatch(type1, type2);
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> int typeCompare(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        switch (TypeUtil.getRelationship(env, type1, type2)) {
            case 1: {
                return 0;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 1;
            }
        }
        String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(TypeUtil.class, "typeCompare", error);
        throw error;
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void checkMutuallyComparable(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2, int opcode) throws SemanticException {
        if (!(type1 instanceof PrimitiveType && type2 instanceof PrimitiveType || TypeUtil.commonSuperType(env, type1, type2) != null)) {
            String message = OCLMessages.bind(OCLMessages.Noncomforming_ERROR_, TypeUtil.getName(env, type1), OCLStandardLibraryUtil.getOperationName(opcode));
            throw new SemanticException(message);
        }
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean checkMutuallyComparable(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2, int opcode) {
        return TypeUtil.getTypeCheckerAdapter(env).checkMutuallyComparable(problemObject, type1, type2, opcode);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> int getRelationship(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        return TypeUtil.getTypeCheckerAdapter(env).getRelationship(type1, type2);
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C commonSuperType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) throws SemanticException {
        return TypeUtil.commonSuperType(null, env, type1, type2);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C commonSuperType(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        return TypeUtil.getTypeCheckerAdapter(env).commonSuperType(problemObject, type1, type2);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        return type != null ? env.getTypeResolver().resolve(type) : type;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.SET_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveOrderedSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.ORDERED_SET_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveBagType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.BAG_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSequenceType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.SEQUENCE_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveCollectionType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CollectionKind kind, C elementType) {
        return (C)env.getTypeResolver().resolveCollectionType(kind, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveTupleType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EList<? extends TypedElement<C>> parts) {
        return (C)env.getTypeResolver().resolveTupleType(parts);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveTypeType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        return (C)env.getTypeResolver().resolveTypeType(type);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveOperationMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        return (C)env.getTypeResolver().resolveOperationMessageType(operation);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSignalMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C signal) {
        return (C)env.getTypeResolver().resolveSignalMessageType(signal);
    }

    public static <C> boolean isStandardLibraryFeature(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, C owner, Object feature) {
        return TypeUtil.getTypeCheckerAdapter(env).isStandardLibraryFeature(owner, feature);
    }

    private static <C, O, P> TypeChecker<C, O, P> getTypeCheckerAdapter(Environment<?, C, O, P, ?, ?, ?, ?, ?, ?, ?, ?> env) {
        return OCLUtil.getAdapter(env, TypeChecker.class);
    }
}

