/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class PropertiesActionProvider
extends CommonActionProvider {
    private PropertyDialogAction propertiesAction;
    private ISelectionProvider delegateSelectionProvider;

    public void init(ICommonActionExtensionSite aSite) {
        this.delegateSelectionProvider = new DelegateSelectionProvider(aSite.getViewSite().getSelectionProvider());
        this.propertiesAction = new PropertyDialogAction(() -> aSite.getViewSite().getShell(), this.delegateSelectionProvider);
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.propertiesAction.isApplicableForSelection()) {
            menu.appendToGroup("group.properties", (IAction)this.propertiesAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.propertiesAction.selectionChanged(this.delegateSelectionProvider.getSelection());
    }

    private static class DelegateIAdaptable
    implements IAdaptable {
        private final Object delegate;

        private DelegateIAdaptable(Object o) {
            this.delegate = o;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance(this.delegate) || this.delegate == null) {
                return (T)this.delegate;
            }
            return (T)Platform.getAdapterManager().getAdapter(this.delegate, adapter);
        }
    }

    private static class DelegateSelectionProvider
    implements ISelectionProvider {
        private final ISelectionProvider delegate;

        private DelegateSelectionProvider(ISelectionProvider s) {
            this.delegate = s;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.delegate.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sSel = (IStructuredSelection)this.delegate.getSelection();
                if (sSel.getFirstElement() instanceof IAdaptable) {
                    return sSel;
                }
                return new StructuredSelection((Object)new DelegateIAdaptable(sSel.getFirstElement()));
            }
            return this.delegate.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
            this.delegate.setSelection(selection);
        }
    }
}

