/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.tools;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.gef.EditPartViewer;

final class ColLocatedConnectionFinder {
    public static List<ConnectionEditPart> getCoLocatedConnections(ConnectionEditPart connEP, EditPartViewer viewer, Point loc) {
        Set<Connection> conns = ColLocatedConnectionFinder.getAllRelatedConnections(connEP);
        Point location = ColLocatedConnectionFinder.getRelativeLocation((IFigure)connEP.getFigure(), loc);
        return conns.stream().map(con -> (ConnectionEditPart)viewer.getEditPartForModel(con)).filter(Objects::nonNull).filter(ep -> ep.getFigure().findFigureAt(location) != null).toList();
    }

    public static List<ConnectionEditPart> getLeftCoLocatedConnections(ConnectionEditPart connEP, EditPartViewer viewer, Point loc) {
        Set<Connection> conns = ColLocatedConnectionFinder.getAllRelatedConnections(connEP);
        Point location = ColLocatedConnectionFinder.getRelativeLocation((IFigure)connEP.getFigure(), loc);
        return conns.stream().map(con -> (ConnectionEditPart)viewer.getEditPartForModel(con)).filter(Objects::nonNull).filter(ep -> ep.getFigure().findFigureAt(location) == null).toList();
    }

    private static Set<Connection> getAllRelatedConnections(ConnectionEditPart connEP) {
        HashSet<Connection> conns = new HashSet<Connection>();
        if (connEP.getModel() != null) {
            if (connEP.getModel().getSource() != null) {
                conns.addAll((Collection<Connection>)connEP.getModel().getSource().getOutputConnections());
            }
            if (connEP.getModel().getDestination() != null) {
                conns.addAll((Collection<Connection>)connEP.getModel().getDestination().getInputConnections());
            }
        }
        return conns;
    }

    private static Point getRelativeLocation(IFigure figure, Point loc) {
        if (figure.getParent() != null) {
            Point location = ColLocatedConnectionFinder.getRelativeLocation(figure.getParent(), loc);
            figure.translateFromParent((Translatable)location);
            return location;
        }
        return loc;
    }

    private ColLocatedConnectionFinder() {
        throw new UnsupportedOperationException("Helper class should not be instantiated");
    }
}

