/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.elk.alg.common.compaction.oned.CGroup;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.ICompactionAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.common.networksimplex.NEdge;
import org.eclipse.elk.alg.common.networksimplex.NGraph;
import org.eclipse.elk.alg.common.networksimplex.NNode;
import org.eclipse.elk.alg.common.networksimplex.NetworkSimplex;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.compaction.HorizontalGraphCompactor;
import org.eclipse.elk.alg.layered.intermediate.compaction.VerticalSegment;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NetworkSimplexCompaction
implements ICompactionAlgorithm {
    private OneDimensionalCompactor compactor;
    private NGraph networkSimplexGraph;
    private NNode[] nNodes;
    private int index;
    private static final int SEPARATION_WEIGHT = 1;
    private static final int EDGE_WEIGHT = 100;

    public void compact(OneDimensionalCompactor theCompactor) {
        this.compactor = theCompactor;
        this.networkSimplexGraph = new NGraph();
        this.nNodes = new NNode[this.compactor.cGraph.cGroups.size()];
        this.index = 0;
        for (CGroup cGroup : this.compactor.cGraph.cGroups) {
            NNode nNode;
            cGroup.id = this.index;
            this.nNodes[this.index] = nNode = NNode.of().id(this.index).origin((Object)cGroup).create(this.networkSimplexGraph);
            ++this.index;
        }
        this.addSeparationConstraints();
        this.addEdgeConstraints();
        this.addArtificialSourceNode();
        NetworkSimplex.forGraph((NGraph)this.networkSimplexGraph).execute((IElkProgressMonitor)new BasicProgressMonitor());
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            cNode.hitbox.x = (double)this.nNodes[cNode.cGroup.id].layer + cNode.cGroupOffset.x;
        }
    }

    private void addSeparationConstraints() {
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            for (CNode incNode : cNode.constraints) {
                if (cNode.cGroup == incNode.cGroup) continue;
                double spacing = this.compactor.direction.isHorizontal() ? this.compactor.spacingsHandler.getHorizontalSpacing(cNode, incNode) : this.compactor.spacingsHandler.getVerticalSpacing(cNode, incNode);
                double delta = cNode.cGroupOffset.x + cNode.hitbox.width + spacing - incNode.cGroupOffset.x;
                delta = Math.ceil(delta);
                delta = Math.max(0.0, delta);
                if (!HorizontalGraphCompactor.isVerticalSegmentsOfSameEdge(cNode, incNode)) {
                    double weight = 1.0;
                    if (cNode.origin instanceof VerticalSegment && incNode.origin instanceof LNode || incNode.origin instanceof VerticalSegment && cNode.origin instanceof LNode) {
                        weight = 2.0;
                    }
                    NEdge.of().delta((int)delta).weight(weight).source(this.nNodes[cNode.cGroup.id]).target(this.nNodes[incNode.cGroup.id]).create();
                    continue;
                }
                NNode helper = NNode.of().create(this.networkSimplexGraph);
                int offsetDelta = (int)Math.ceil(incNode.cGroupOffset.x - cNode.cGroupOffset.x);
                double adjust = (double)offsetDelta - (incNode.cGroupOffset.x - cNode.cGroupOffset.x);
                LPort port = HorizontalGraphCompactor.getVerticalSegmentOrNull((CNode)cNode).aPort;
                CNode alterOffset = cNode;
                if (port == null) {
                    port = HorizontalGraphCompactor.getVerticalSegmentOrNull((CNode)incNode).aPort;
                    adjust = -adjust;
                    alterOffset = incNode;
                }
                if (port != null) {
                    alterOffset.cGroupOffset.x -= adjust;
                    port.getPosition().x -= adjust;
                }
                NEdge.of().delta(Math.max(0, offsetDelta)).weight(1.0).source(helper).target(this.nNodes[cNode.cGroup.id]).create();
                NEdge.of().delta(Math.max(0, -offsetDelta)).weight(1.0).source(helper).target(this.nNodes[incNode.cGroup.id]).create();
            }
        }
    }

    private void addEdgeConstraints() {
        LNode lNode;
        HashMap lNodeMap = Maps.newHashMap();
        HashMultimap lEdgeMap = HashMultimap.create();
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            lNode = HorizontalGraphCompactor.getLNodeOrNull(cNode);
            if (lNode != null) {
                lNodeMap.put(lNode, cNode);
                continue;
            }
            VerticalSegment vs = HorizontalGraphCompactor.getVerticalSegmentOrNull(cNode);
            if (vs == null) continue;
            for (LEdge e : vs.representedLEdges) {
                lEdgeMap.put((Object)e, (Object)cNode);
            }
        }
        for (CNode cNode : this.compactor.cGraph.cNodes) {
            lNode = HorizontalGraphCompactor.getLNodeOrNull(cNode);
            if (lNode == null) continue;
            for (LEdge lEdge : lNode.getOutgoingEdges()) {
                NNode tgt;
                NNode src;
                if (lEdge.isSelfLoop()) continue;
                LPort srcPort = lEdge.getSource();
                LPort tgtPort = lEdge.getTarget();
                if (PortSide.SIDES_NORTH_SOUTH.contains(lEdge.getSource().getSide()) && PortSide.SIDES_NORTH_SOUTH.contains(lEdge.getTarget().getSide())) continue;
                CNode target = (CNode)lNodeMap.get((Object)lEdge.getTarget().getNode());
                NEdge.of().delta(0).weight(100.0).source(this.nNodes[cNode.cGroup.id]).target(this.nNodes[target.cGroup.id]).create();
                if (srcPort.getSide() == PortSide.WEST && LPort.OUTPUT_PREDICATE.apply((Object)srcPort)) {
                    for (CNode n : lEdgeMap.get((Object)lEdge)) {
                        if (!(n.hitbox.x < cNode.hitbox.x) || (src = this.nNodes[n.cGroup.id]) == (tgt = this.nNodes[cNode.cGroup.id])) continue;
                        NEdge.of().delta(1).weight(100.0).source(src).target(tgt).create();
                    }
                }
                if (tgtPort.getSide() != PortSide.EAST || !LPort.INPUT_PREDICATE.apply((Object)tgtPort)) continue;
                for (CNode n : lEdgeMap.get((Object)lEdge)) {
                    if (!(n.hitbox.x > cNode.hitbox.x) || (src = this.nNodes[cNode.cGroup.id]) == (tgt = this.nNodes[n.cGroup.id])) continue;
                    NEdge.of().delta(1).weight(100.0).source(src).target(tgt).create();
                }
            }
        }
    }

    private void addArtificialSourceNode() {
        LinkedList sources = Lists.newLinkedList();
        for (NNode n : this.networkSimplexGraph.nodes) {
            if (!n.getIncomingEdges().isEmpty()) continue;
            sources.add(n);
        }
        if (sources.size() > 1) {
            NNode dummySource = NNode.of().id(this.index++).create(this.networkSimplexGraph);
            for (NNode src : sources) {
                NEdge.of().delta(1).weight(0.0).source(dummySource).target(src).create();
            }
        }
    }
}

