/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.labeling;

import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarPlainDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.ui.Messages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class STCoreLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public STCoreLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String text(STSource element) {
        LibraryElementXtextResource libResource;
        Resource resource = element.eResource();
        if (resource instanceof LibraryElementXtextResource && (libResource = (LibraryElementXtextResource)resource).getInternalLibraryElement() != null) {
            return libResource.getInternalLibraryElement().getName();
        }
        return null;
    }

    public ImageDescriptor image(STSource element) {
        return FordiacImage.ICON_ALGORITHM.getImageDescriptor();
    }

    public String text(VarDeclaration element) {
        return MessageFormat.format(Messages.STCoreLabelProvider_VarDeclarationText, element.getName(), element.getFullTypeName());
    }

    public String text(FB element) {
        return MessageFormat.format(Messages.STCoreLabelProvider_FBText, element.getName(), element.getFullTypeName());
    }

    public String text(STVarDeclaration element) {
        return MessageFormat.format(Messages.STCoreLabelProvider_VarDeclarationText, element.getName(), element.getFullTypeName());
    }

    public String text(STVarPlainDeclarationBlock element) {
        if (element.isConstant()) {
            return Messages.STCoreLabelProvider_VarPlainDeclarationBlockConstantText;
        }
        return Messages.STCoreLabelProvider_VarPlainDeclarationBlockText;
    }

    public ImageDescriptor image(STVarPlainDeclarationBlock element) {
        return FordiacImage.ICON_DATA.getImageDescriptor();
    }

    public String text(STVarTempDeclarationBlock element) {
        if (element.isConstant()) {
            return Messages.STCoreLabelProvider_VarTempDeclarationBlockConstantText;
        }
        return Messages.STCoreLabelProvider_VarTempDeclarationBlockText;
    }

    public ImageDescriptor image(STVarTempDeclarationBlock element) {
        return FordiacImage.ICON_DATA.getImageDescriptor();
    }

    public String text(STVarInputDeclarationBlock element) {
        return Messages.STCoreLabelProvider_VarInputDeclarationBlockText;
    }

    public ImageDescriptor image(STVarInputDeclarationBlock element) {
        return FordiacImage.ICON_DATA_INPUT.getImageDescriptor();
    }

    public String text(STVarInOutDeclarationBlock element) {
        return Messages.STCoreLabelProvider_VarInOutDeclarationBlockText;
    }

    public ImageDescriptor image(STVarInOutDeclarationBlock element) {
        return FordiacImage.ICON_DATA_INPUT.getImageDescriptor();
    }

    public String text(STVarOutputDeclarationBlock element) {
        return Messages.STCoreLabelProvider_VarOutputDeclarationBlockText;
    }

    public ImageDescriptor image(STVarOutputDeclarationBlock element) {
        return FordiacImage.ICON_DATA_OUTPUT.getImageDescriptor();
    }
}

