/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.delete;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteInternalFBModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.SafeStructDeletionChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;

public class DeleteTypeRefactoringParticipant
extends DeleteParticipant {
    private TypeEntry typeEntry;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            this.typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            return this.typeEntry != null;
        }
        return false;
    }

    public String getName() {
        return Messages.DeleteFBTypeParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            LibraryElement libraryElement;
            pm.beginTask("Creating change...", 1);
            if (this.typeEntry instanceof DataTypeEntry && (libraryElement = this.typeEntry.getType()) instanceof StructuredType) {
                StructuredType struct = (StructuredType)libraryElement;
                SafeStructDeletionChange safeStructDeletionChange = new SafeStructDeletionChange(struct);
                return safeStructDeletionChange;
            }
            TypeEntry typeEntry = this.typeEntry;
            if (typeEntry instanceof FBTypeEntry) {
                FBTypeEntry fbTypeEntry = (FBTypeEntry)typeEntry;
                CompositeChange compositeChange = DeleteTypeRefactoringParticipant.createFBTypeDeletionChange(fbTypeEntry.getType());
                return compositeChange;
            }
            return null;
        }
        finally {
            pm.done();
        }
    }

    private static CompositeChange createFBTypeDeletionChange(FBType type) {
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(type.getTypeEntry());
        return ModelEditChange.fromModelEdits(MessageFormat.format(Messages.DeleteFBTypeParticipant_Change_SafeDeletionChangeTitle, type.getName()), search.performSearch().stream().filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).filter(fbnEl -> fbnEl instanceof FB && fbnEl.eContainer() instanceof BaseFBType).map(FB.class::cast).map(DeleteInternalFBModelEdit::new).toList());
    }
}

