/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizardPage;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewTypeWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewFBTypeWizardPage page1;
    private TypeEntry entry;

    public NewTypeWizard() {
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void addPages() {
        this.page1 = this.createNewFBTypeWizardPage();
        this.addPage((IWizardPage)this.page1);
    }

    protected NewFBTypeWizardPage createNewFBTypeWizardPage() {
        return new NewFBTypeWizardPage(this.selection);
    }

    public boolean performFinish() {
        File template = this.page1.getTemplate();
        if (!NewTypeWizard.checkTemplateAvailable(template.getAbsolutePath())) {
            return false;
        }
        IFile targetTypeFile = this.getTargetFile();
        String packageName = this.page1.getPackageName();
        TypeFromTemplateCreator creator = new TypeFromTemplateCreator(this.getTargetFile(), template, packageName);
        try {
            this.getContainer().run(false, true, creator::createTypeFromTemplate);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.entry = creator.getTypeEntry();
        if (this.entry != null) {
            if (this.page1.getOpenType()) {
                NewTypeWizard.openTypeEditor(targetTypeFile);
            }
            return true;
        }
        return false;
    }

    public static void openTypeEditor(IFile file) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(file), (String)desc.getId());
    }

    private IFile getTargetFile() {
        String typeName = this.page1.getFileName();
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(this.page1.getContainerFullPath()) + File.separator + typeName));
    }

    private static boolean checkTemplateAvailable(String templatePath) {
        if (!new File(templatePath).exists()) {
            NewTypeWizard.templateNotAvailable(templatePath);
            return false;
        }
        return true;
    }

    private static void templateNotAvailable(String templatePath) {
        MessageBox mbx = new MessageBox(Display.getDefault().getActiveShell());
        mbx.setMessage(MessageFormat.format(Messages.NewFBTypeWizard_TemplateNotAvailable, templatePath));
        mbx.open();
    }

    public TypeEntry getTypeEntry() {
        return this.entry;
    }
}

