/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.view;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.fb.interpreter.api.CoverageCalculator;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GetCoverageDialog
extends MessageDialog {
    Map<String, Integer> visitedStates;
    Map<List<String>, Integer> visitedPaths;

    public GetCoverageDialog(Shell parentShell, Map<String, Integer> visitedStates, Map<List<String>, Integer> visitedPaths) {
        super(parentShell, Messages.Coverage_NAME, null, "Shows the Coverage of the given Tests:", 2, 0, new String[]{"OK"});
        this.visitedStates = visitedStates;
        this.visitedPaths = visitedPaths;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        dialogArea.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        dialogArea.setLayout((Layout)layout);
        Group vistedStatesGroup = new Group(dialogArea, 0);
        vistedStatesGroup.setText(Messages.Coverage_VISITED_STATES);
        vistedStatesGroup.setLayout((Layout)new GridLayout(1, false));
        vistedStatesGroup.setLayoutData((Object)new GridData(16384, 128, true, true));
        this.visitedStates.entrySet().forEach(entry -> {
            Label label = new Label((Composite)vistedStatesGroup, 0);
            label.setText((String)entry.getKey() + "   :    " + String.valueOf(entry.getValue()) + " \n");
        });
        Label label = new Label((Composite)vistedStatesGroup, 0);
        label.setText(MessageFormat.format(Messages.Coverage_NODECOVERAGE, Float.toString(CoverageCalculator.calculateNodeCoverageOfSuiteBy(this.visitedStates) * 100.0f)));
        Group vistedPathsGroup = new Group(dialogArea, 0);
        vistedPathsGroup.setText(Messages.Coverage_VISITED_PATHS);
        vistedPathsGroup.setLayout((Layout)new GridLayout(1, false));
        vistedPathsGroup.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        this.visitedPaths.entrySet().forEach(entry -> {
            Label label2 = new Label((Composite)vistedPathsGroup, 0);
            StringBuilder pathString = new StringBuilder();
            for (String state : (List)entry.getKey()) {
                pathString.append(state);
                pathString.append(" -> ");
            }
            if (!((List)entry.getKey()).isEmpty()) {
                pathString.setLength(pathString.length() - 4);
            }
            pathString.append("   :    ");
            pathString.append(entry.getValue());
            pathString.append(" \n");
            label2.setText(pathString.toString());
        });
        label = new Label((Composite)vistedPathsGroup, 0);
        label.setText(MessageFormat.format(Messages.Coverage_PATHCOVERAGE, Float.toString(CoverageCalculator.calculatePathCoverageOfSuiteBy(this.visitedPaths) * 100.0f)));
        return dialogArea;
    }
}

