/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLEvaluator;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class CompleteOCLEvaluationTask
implements Callable<EvaluationResult> {
    private final EvaluationContext context;
    private final EnvironmentFactory environmentFactory;

    public CompleteOCLEvaluationTask(EvaluationContext context, EnvironmentFactory environmentFactory) {
        this.context = context;
        this.environmentFactory = environmentFactory;
    }

    @Override
    public EvaluationResult call() throws Exception {
        EvaluationResult result;
        this.checkCancelled();
        CompilationResult compilationResult = this.context.getCompilationResult();
        EvaluationResult shortcut = null;
        if (compilationResult == null || !this.checkExpression(compilationResult)) {
            shortcut = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Compilation error in expression."));
        } else if (compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0) {
            shortcut = new EvaluationResult(compilationResult.getStatus());
        }
        if (shortcut != null) {
            return shortcut;
        }
        assert (compilationResult != null);
        this.checkCancelled();
        if (this.context.getTargetNotifiers().isEmpty()) {
            return new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "No context selected."));
        }
        CompleteOCLEvaluator evaluator = new CompleteOCLEvaluator(this.environmentFactory);
        Notifier evaluationTarget = (Notifier)this.context.getTargetNotifiers().get(0);
        if (compilationResult.getCompiledExpression() instanceof ExpressionInOCL) {
            ExpressionInOCL expressionInOCL = (ExpressionInOCL)compilationResult.getCompiledExpression();
            result = evaluationTarget instanceof EObject ? evaluator.evaluateExpression(expressionInOCL, (EObject)evaluationTarget) : new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + expressionInOCL + " on the selected Notifier."));
        } else {
            result = compilationResult.getCompiledExpression() instanceof OCLExpression ? (evaluationTarget instanceof EObject ? evaluator.evaluateExpression((OCLExpression)compilationResult.getCompiledExpression(), (EObject)evaluationTarget) : new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + compilationResult.getCompiledExpression() + " on the selected Notifier."))) : (compilationResult.getCompiledExpression() instanceof Element ? evaluator.evaluateCompleteOCLElement((Element)compilationResult.getCompiledExpression(), evaluationTarget) : new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression.")));
        }
        return result;
    }

    private boolean checkExpression(CompilationResult compilationResult) {
        Object expression = compilationResult.getCompiledExpression();
        boolean knownExpression = false;
        knownExpression = expression instanceof Model || expression instanceof Package || expression instanceof Type || expression instanceof Constraint || expression instanceof Operation ? true : expression instanceof OCLExpression || expression instanceof ExpressionInOCL;
        return knownExpression;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }
}

