/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.act.tests;

import org.eclipse.emf.common.util.EList;
import org.metaabm.IAct;
import org.metaabm.IValue;
import org.metaabm.MetaABMFactory;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SContext;
import org.metaabm.act.AAct;
import org.metaabm.act.AEvaluate;
import org.metaabm.act.AGroup;
import org.metaabm.act.ASelect;
import org.metaabm.act.ASet;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.tests.IIDTest;

public abstract class AActTest
extends IIDTest {
    SContext context;

    public AActTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.context = MetaABMFactory.eINSTANCE.createSContext();
        this.context.setRootActivity((IAct)MetaABMActFactory.eINSTANCE.createAGroup());
        ((AGroup)this.context.getRootActivity()).getMembers().add((Object)this.getFixture());
        this.getFixture().setLabel("Label");
        super.setUp();
    }

    protected AAct getFixture() {
        return (AAct)this.fixture;
    }

    public void testGetReference() {
        AActTest.assertEquals((Object)this.getFixture().getReference(), (Object)this.context);
    }

    public void testGetAllSources() {
        ASet act0 = MetaABMActFactory.eINSTANCE.createASet();
        ASet act1_0 = MetaABMActFactory.eINSTANCE.createASet();
        act1_0.getTargets().add((Object)act0);
        ASet act1_1 = MetaABMActFactory.eINSTANCE.createASet();
        act1_1.getTargets().add((Object)act0);
        EList list0 = act1_1.getAllTargets();
        AActTest.assertTrue((boolean)list0.contains(act0));
        AActTest.assertFalse((boolean)list0.contains(act1_1));
        AActTest.assertEquals((int)list0.size(), (int)1);
        ASet act2_1 = MetaABMActFactory.eINSTANCE.createASet();
        act2_1.getTargets().add((Object)act1_1);
        EList list1 = act2_1.getAllTargets();
        AActTest.assertTrue((boolean)list1.contains(act0));
        AActTest.assertTrue((boolean)list1.contains(act1_1));
        AActTest.assertFalse((boolean)list1.contains(act1_0));
        AActTest.assertFalse((boolean)list1.contains(act2_1));
        AActTest.assertEquals((int)list1.size(), (int)2);
    }

    public void testGetAllTargets() {
        ASet act0 = MetaABMActFactory.eINSTANCE.createASet();
        ASet act1_0 = MetaABMActFactory.eINSTANCE.createASet();
        act1_0.getSources().add((Object)act0);
        ASet act1_1 = MetaABMActFactory.eINSTANCE.createASet();
        act1_1.getSources().add((Object)act0);
        EList list0 = act1_1.getAllSources();
        AActTest.assertTrue((boolean)list0.contains(act0));
        AActTest.assertFalse((boolean)list0.contains(act1_1));
        AActTest.assertEquals((int)list0.size(), (int)1);
        ASet act2_1 = MetaABMActFactory.eINSTANCE.createASet();
        act2_1.getSources().add((Object)act1_1);
        EList list1 = act2_1.getAllSources();
        AActTest.assertTrue((boolean)list1.contains(act0));
        AActTest.assertTrue((boolean)list1.contains(act1_1));
        AActTest.assertFalse((boolean)list1.contains(act1_0));
        AActTest.assertFalse((boolean)list1.contains(act2_1));
        AActTest.assertEquals((int)list1.size(), (int)2);
    }

    public void testReachable() {
        SAgent agent = MetaABMFactory.eINSTANCE.createSAgent();
        SAttribute testAttr = MetaABMFactory.eINSTANCE.createSAttribute();
        agent.getAttributes().add((Object)testAttr);
        AGroup rootAct = MetaABMActFactory.eINSTANCE.createAGroup();
        agent.setRootActivity((IAct)rootAct);
        AEvaluate eval = MetaABMActFactory.eINSTANCE.createAEvaluate();
        ASelect select = MetaABMActFactory.eINSTANCE.createASelect();
        select.setAgent(agent);
        eval.setSelected(select);
        testAttr.setSType(SAttributeType.REAL_LITERAL);
        select.getTargets().add((Object)eval);
        AActTest.assertTrue((boolean)eval.isTargetOf((Object)select));
        AActTest.assertFalse((boolean)select.isTargetOf((Object)eval));
        AActTest.assertTrue((boolean)agent.isReachable((IValue)testAttr));
        AActTest.assertTrue((boolean)select.isReachable((IValue)testAttr));
        AActTest.assertTrue((boolean)eval.isReachable((IValue)testAttr));
    }
}

