/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.HandlerManager;
import org.eclipse.amp.axf.ide.LifeCycleListeners;
import org.eclipse.amp.axf.ide.ModelManagerListeners;
import org.eclipse.amp.axf.ide.ModelManagerViewPart;
import org.eclipse.amp.axf.ide.handlers.CloseHandler;
import org.eclipse.amp.axf.ide.handlers.ModelRunHandler;
import org.eclipse.amp.axf.ide.handlers.PauseHandler;
import org.eclipse.amp.axf.ide.handlers.RestartHandler;
import org.eclipse.amp.axf.ide.handlers.ResumeHandler;
import org.eclipse.amp.axf.ide.handlers.StartHandler;
import org.eclipse.amp.axf.ide.handlers.StepHandler;
import org.eclipse.amp.axf.ide.handlers.StopHandler;
import org.eclipse.amp.axf.ide.view.StatusLineView;
import org.eclipse.amp.axf.view.IModelPart;
import org.eclipse.amp.axf.view.ModelInput;
import org.eclipse.amp.axf.view.ModelViewPart;
import org.eclipse.amp.axf.view.SelectionSynchronizer;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelViewManager
implements IAdapterFactory {
    public static final String EXECUTION_PERSPECTIVE_ID = "org.eclipse.amp.axf.ExecutionPerspective";
    private IContextService contextService;
    private IContextActivation ideContext;
    private IContextActivation partContext;
    List<IModel> models = new ArrayList<IModel>();
    List<IViewPart> views = new ArrayList<IViewPart>();
    Map<IModel, IEngine> runnerForModel;
    Map<IEngine, IModel> modelForRunner = new HashMap<IEngine, IModel>();
    Map<Object, IModel> modelForArbitrary = new HashMap<Object, IModel>();
    Map<IModel, List<IViewPart>> viewsForModel;
    LifeCycleListeners activeModelListeners;
    ModelManagerListeners managerListeners = new ModelManagerListeners();
    HandlerManager handlers = new HandlerManager();
    IModel activeModel;
    IPartListener modelActivationListener;
    private int updateCount;
    private IObservationProvider[] modelSlots = new IObservationProvider[16];
    private SelectionSynchronizer editSelection;
    private String priorPerspectiveID;
    private StatusLineView statusLineView;
    private ModelManagerViewPart managerViewPart;
    private boolean updated;

    public IObservationProvider getActiveModel() {
        return this.activeModel;
    }

    public synchronized void setActiveModel(IModel newModel) {
        if (newModel != null && !this.models.contains(newModel)) {
            return;
        }
        IModel oldModel = this.activeModel;
        this.activeModel = newModel;
        if (newModel != oldModel) {
            this.getActiveModelListeners().replaceModel(oldModel, newModel);
            if (newModel != null) {
                this.managerListeners.notifyModelActivated(newModel);
            }
        }
    }

    public List<IModel> getModels() {
        return this.models;
    }

    public int getSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == model) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public int assignSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == null) {
                this.modelSlots[i] = model;
                return i;
            }
            ++i;
            ++n2;
        }
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.axf.ui", "Currently, the execution engine only supports " + this.modelSlots.length + " slots. The UI may not perform properly."));
        return -1;
    }

    public int releaseSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == model) {
                this.modelSlots[i] = null;
                return i;
            }
            ++i;
            ++n2;
        }
        throw new RuntimeException(model + " has not been assigned to a slot.");
    }

    public synchronized void register(IModel model, IEngine executor, Object modelObject) {
        if (model == null) {
            throw new RuntimeException("Tried to register a null model.");
        }
        if (executor == null) {
            throw new RuntimeException("Tried to register a null executor.");
        }
        if (this.modelActivationListener == null) {
            this.activate();
        }
        this.models.add(model);
        this.modelForRunner.put(executor, model);
        this.runnerForModel.put(model, executor);
        this.assignSlot((IObservationProvider)model);
        if (modelObject != null) {
            this.modelForArbitrary.put(modelObject, model);
        }
        this.managerListeners.notifyModelAdded(model);
        this.viewsForModel.put(model, new ArrayList());
        this.setActiveModel(model);
    }

    public void register(IModel model, IEngine executor) {
        this.register(model, executor, null);
    }

    public synchronized void register(IViewPart part) {
        this.views.add(part);
    }

    public synchronized void removed(IViewPart part) {
        this.views.remove(part);
        List<IViewPart> modelViews = this.getViews(this.activeModel);
        if (modelViews != null) {
            modelViews.remove(part);
        }
        this.managerListeners.notifyViewRemoved(part);
    }

    public List<IViewPart> getViews(IModel model) {
        return this.viewsForModel.get(model);
    }

    public IViewPart createViewPart(String id, ModelInput editorInput, String name) {
        this.updated = false;
        PartCreator creator = new PartCreator(name, editorInput, id);
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)creator);
        while (!this.updated) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return creator.getPart();
    }

    public void closeView(final IViewPart part) {
        if (PlatformUI.getWorkbench() != null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        if (workbenchWindow != null && workbenchWindow.getActivePage() != null) {
                            workbenchWindow.getActivePage().hideView(part);
                        }
                    }
                });
            }
        } else {
            new Thread(){

                public void run() {
                    ModelViewManager.this.removed(part);
                }
            }.start();
        }
    }

    public synchronized void remove(IModel model) {
        if (this.models.remove(model)) {
            this.modelForRunner.remove(model.getEngine());
            this.runnerForModel.remove(model);
            this.managerListeners.notifyModelRemoved(model);
            for (IViewPart part : this.viewsForModel.get(model)) {
                this.closeView(part);
            }
            this.viewsForModel.remove(model);
            ArrayList<Object> arbitraries = new ArrayList<Object>();
            for (Map.Entry<Object, IModel> entry : this.modelForArbitrary.entrySet()) {
                if (entry.getValue() != model) continue;
                arbitraries.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : arbitraries) {
                this.modelForArbitrary.remove(entry);
            }
            this.releaseSlot((IObservationProvider)model);
            if (!model.getEngine().isCloseRequested()) {
                model.getEngine().close();
            }
            if (this.models.size() > 0) {
                this.setActiveModel(this.models.get(this.models.size() - 1));
            } else {
                this.setActiveModel(null);
                this.deactivate();
            }
        } else {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.axf.ui", "Removing a model that no longer exists:" + model, (Throwable)new Exception()));
        }
    }

    private IWorkbenchPage getPage() {
        IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        return wb.getWorkbenchWindows()[0].getPages()[0];
    }

    private synchronized void activate() {
        final IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        wb.addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                if (!forced) {
                    ModelViewManager modelViewManager = ModelViewManager.this;
                    synchronized (modelViewManager) {
                        for (IModel model : new ArrayList<IModel>(ModelViewManager.this.getModels())) {
                            ModelViewManager.this.remove(model);
                        }
                    }
                }
                return true;
            }
        });
        this.viewsForModel = new HashMap<IModel, List<IViewPart>>();
        this.runnerForModel = new HashMap<IModel, IEngine>();
        this.modelActivationListener = new ActivationListener();
        this.activeModelListeners = new LifeCycleListeners();
        this.getPage().addPartListener(this.modelActivationListener);
        this.statusLineView = StatusLineView.getDefault();
        this.getPage().addPartListener((IPartListener)this.statusLineView);
        this.getActiveModelListeners().addListener((ILifeCycleListener)this.statusLineView);
        this.activatePerspective(wb, EXECUTION_PERSPECTIVE_ID, false);
        wb.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    ModelViewManager.this.contextService = (IContextService)wb.getService(IContextService.class);
                    ModelViewManager.this.ideContext = ModelViewManager.this.contextService.activateContext("org.eclipse.amp.axf.executionContext");
                    ModelViewManager.this.partContext = ModelViewManager.this.contextService.activateContext("org.eclipse.amp.axf.activeEditorContext");
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't activate services.", e);
                }
            }
        });
        this.handlers.activate();
        this.addHandler("org.eclipse.amp.axf.ui.start", new StartHandler());
        this.addHandler("org.eclipse.amp.axf.ui.stop", new StopHandler());
        this.addHandler("org.eclipse.amp.axf.ui.pause", new PauseHandler());
        this.addHandler("org.eclipse.amp.axf.ui.resume", new ResumeHandler());
        this.addHandler("org.eclipse.amp.axf.ui.restart", new RestartHandler());
        this.addHandler("org.eclipse.amp.axf.ui.close", new CloseHandler());
        this.addHandler("org.eclipse.amp.axf.ui.step", new StepHandler());
    }

    public void addHandler(String id, ModelRunHandler handler) {
        this.handlers.addHandler(id, handler);
        this.getActiveModelListeners().addListener(handler);
        this.getManagerListeners().addModelManagerListener(handler);
    }

    private void activatePerspective(final IWorkbench wb, final String perspectiveID, final boolean editors) {
        wb.getDisplay().syncExec(new Runnable(){

            public void run() {
                IPerspectiveDescriptor perspective = wb.getPerspectiveRegistry().findPerspectiveWithId(perspectiveID);
                if (perspective != null) {
                    IWorkbenchPage activePage;
                    IWorkbenchPage iWorkbenchPage = activePage = wb.getActiveWorkbenchWindow() != null ? wb.getActiveWorkbenchWindow().getActivePage() : null;
                    if (activePage != null) {
                        if (ModelViewManager.this.priorPerspectiveID == null || !activePage.getPerspective().getId().equals(ModelViewManager.EXECUTION_PERSPECTIVE_ID)) {
                            ModelViewManager.this.priorPerspectiveID = activePage.getPerspective().getId();
                        }
                        activePage.setPerspective(perspective);
                        activePage.setEditorAreaVisible(editors);
                    }
                }
                ModelViewManager modelViewManager = ModelViewManager.this;
                modelViewManager.updateCount = modelViewManager.updateCount + 1;
            }
        });
    }

    private synchronized void deactivate() {
        IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        if (wb != null) {
            wb.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ModelViewManager.this.contextService != null) {
                        ModelViewManager.this.contextService.deactivateContext(ModelViewManager.this.ideContext);
                        ModelViewManager.this.contextService.deactivateContext(ModelViewManager.this.partContext);
                    }
                    ModelViewManager.this.handlers.deactivate();
                }
            });
            this.getPage().removePartListener(this.modelActivationListener);
            this.getPage().removePartListener((IPartListener)this.statusLineView);
            if (this.priorPerspectiveID != null) {
                this.activatePerspective(wb, this.priorPerspectiveID, true);
            }
            this.modelActivationListener = null;
            this.statusLineView = null;
            this.activeModelListeners = null;
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IEngine.class && adaptableObject instanceof IModel) {
            return this.runnerForModel.get(adaptableObject);
        }
        if (adapterType == IModel.class) {
            if (adaptableObject instanceof IEngine) {
                return this.modelForRunner.get(adaptableObject);
            }
            return this.modelForArbitrary.get(adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IEngine.class, IModel.class};
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.editSelection;
    }

    public void setSelectionSynchronizer(SelectionSynchronizer editSelection) {
        if (this.editSelection != null) {
            editSelection.replace(this.editSelection);
        }
        this.editSelection = editSelection;
    }

    public ModelManagerListeners getManagerListeners() {
        return this.managerListeners;
    }

    public LifeCycleListeners getActiveModelListeners() {
        return this.activeModelListeners;
    }

    public HandlerManager getHandlers() {
        return this.handlers;
    }

    public ModelManagerViewPart getManagerViewPart() {
        return this.managerViewPart;
    }

    public void setManagerViewPart(ModelManagerViewPart managerViewPart) {
        this.managerViewPart = managerViewPart;
    }

    private final class ActivationListener
    implements IPartListener {
        private ActivationListener() {
        }

        private void assignPart(final IWorkbenchPart part) {
            if (part instanceof IModelPart && ((IModelPart)part).getAdapter(IModel.class) != null) {
                new Thread(){

                    public void run() {
                        IModel model = (IModel)((IModelPart)part).getAdapter(IModel.class);
                        ModelViewManager.this.setActiveModel(model);
                    }
                }.start();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            this.assignPart(part);
        }

        public void partActivated(IWorkbenchPart part) {
            this.assignPart(part);
        }

        public void partClosed(final IWorkbenchPart part) {
            if (part instanceof IModelPart && ((IModelPart)part).getAdapter(IModel.class) != null) {
                new Thread(){

                    public void run() {
                        ModelViewManager.this.removed((IViewPart)part);
                    }
                }.start();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            this.assignPart(part);
        }
    }

    private final class PartCreator
    implements Runnable {
        private final String name;
        private final ModelInput editorInput;
        private final String id;
        private IViewPart part;

        private PartCreator(String name, ModelInput editorInput, String id) {
            this.name = name;
            this.editorInput = editorInput;
            this.id = id;
        }

        public void run() {
            try {
                try {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    int slot = ModelViewManager.this.getSlot((IObservationProvider)this.editorInput.getModel());
                    String secondaryID = String.valueOf(slot);
                    int viewCount = 0;
                    for (IViewPart part : ModelViewManager.this.viewsForModel.get(this.editorInput.getModel())) {
                        if (!part.getViewSite().getId().equals(this.id)) continue;
                        ++viewCount;
                    }
                    secondaryID = String.valueOf(secondaryID) + "-" + viewCount;
                    this.part = page.showView(this.id, secondaryID, 2);
                    if (this.part instanceof ModelViewPart) {
                        ModelViewManager.this.register(this.part);
                        ((ModelViewPart)this.part).setInput((IEditorInput)this.editorInput);
                        ((ModelViewPart)this.part).setPartName(String.valueOf(this.editorInput.getName()) + " " + this.name);
                        ((ModelViewPart)this.part).createModelListeners();
                        ModelViewManager.this.getViews(this.editorInput.getModel()).add(this.part);
                        new Thread(){

                            public void run() {
                                ((PartCreator)PartCreator.this).ModelViewManager.this.managerListeners.notifyViewAdded(PartCreator.this.part);
                            }
                        }.start();
                    } else if (!(this.part instanceof ErrorViewPart)) {
                        throw new RuntimeException("Couldn't create model view part.");
                    }
                }
                catch (PartInitException e) {
                    throw new RuntimeException("Couldn't instantiate model view " + this, e);
                }
            }
            finally {
                ModelViewManager.this.updated = true;
            }
        }

        public IViewPart getPart() {
            return this.part;
        }
    }
}

