/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.tools;

import java.util.logging.Logger;
import org.eclipse.draw3d.ui.camera.CameraInputHandler;
import org.eclipse.draw3d.ui.preferences.CameraPreferenceDistributor;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef3d.tools.AbstractTool3D;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CameraTool
extends AbstractTool3D {
    private static final Logger logger = Logger.getLogger(CameraTool.class.getName());
    protected CameraInputHandler m_handler;
    protected CameraPreferenceDistributor m_prefDistributor;
    private Cursor m_pushedCursor;

    public void activate() {
        super.activate();
        if (this.m_handler == null) {
            this.m_handler = new CameraInputHandler();
        }
        if (this.m_prefDistributor == null) {
            this.m_prefDistributor = new CameraPreferenceDistributor(this.m_handler);
        }
        this.m_prefDistributor.start();
    }

    public void deactivate() {
        super.deactivate();
        this.m_prefDistributor.stop();
    }

    protected String getCommandName() {
        return "Camera Tool";
    }

    private int getStateMask(AbstractTool.Input i_input) {
        int stateMask = 0;
        if (i_input.isAltKeyDown()) {
            stateMask |= 0x10000;
        }
        if (i_input.isControlKeyDown()) {
            stateMask |= 0x40000;
        }
        if (i_input.isShiftKeyDown()) {
            stateMask |= 0x20000;
        }
        if (i_input.isModKeyDown(SWT.MOD1)) {
            stateMask |= SWT.MOD1;
        }
        if (i_input.isModKeyDown(SWT.MOD2)) {
            stateMask |= SWT.MOD2;
        }
        if (i_input.isModKeyDown(SWT.MOD3)) {
            stateMask |= SWT.MOD3;
        }
        if (i_input.isModKeyDown(SWT.MOD4)) {
            stateMask |= SWT.MOD4;
        }
        if (i_input.isMouseButtonDown(524288)) {
            stateMask |= 0x80000;
        }
        if (i_input.isMouseButtonDown(0x100000)) {
            stateMask |= 0x100000;
        }
        if (i_input.isMouseButtonDown(0x200000)) {
            stateMask |= 0x200000;
        }
        if (i_input.isMouseButtonDown(0x800000)) {
            stateMask |= 0x800000;
        }
        if (i_input.isMouseButtonDown(0x2000000)) {
            stateMask |= 0x2000000;
        }
        return stateMask;
    }

    protected boolean handleButtonDown(int i_button) {
        this.setCursor(2);
        this.m_handler.setScene(this.getScene());
        AbstractTool3D.Input3D input = this.getCurrentInput3D();
        this.m_handler.buttonDown(i_button, this.getStateMask(input), input.getRealMouseLocation().x, input.getRealMouseLocation().y);
        return true;
    }

    protected boolean handleButtonUp(int i_button) {
        this.restoreCursor();
        this.m_handler.setScene(this.getScene());
        AbstractTool3D.Input3D input = this.getCurrentInput3D();
        this.m_handler.buttonUp(i_button, this.getStateMask(input), input.getRealMouseLocation().x, input.getRealMouseLocation().y);
        return true;
    }

    protected boolean handleDrag() {
        this.m_handler.setScene(this.getScene());
        AbstractTool3D.Input3D input = this.getCurrentInput3D();
        this.m_handler.mouseMove(this.getStateMask(input), input.getRealMouseLocation().x, input.getRealMouseLocation().y);
        return true;
    }

    protected boolean handleKeyDown(KeyEvent i_e) {
        this.m_handler.setScene(this.getScene());
        this.m_handler.keyDown(i_e);
        return true;
    }

    protected boolean handleKeyUp(KeyEvent i_e) {
        this.m_handler.setScene(this.getScene());
        this.m_handler.keyUp(i_e);
        return true;
    }

    protected boolean handleNativeDragFinished(DragSourceEvent i_event) {
        this.restoreCursor();
        this.m_handler.setScene(this.getScene());
        AbstractTool3D.Input3D input = this.getCurrentInput3D();
        this.m_handler.nativeDragFinished(input.getRealMouseLocation().x, input.getRealMouseLocation().y);
        return true;
    }

    protected boolean handleNativeDragStarted(DragSourceEvent i_event) {
        this.setCursor(2);
        this.m_handler.setScene(this.getScene());
        AbstractTool3D.Input3D input = this.getCurrentInput3D();
        this.m_handler.nativeDragStarted(input.getRealMouseLocation().x, input.getRealMouseLocation().y);
        return true;
    }

    public void keyUp(KeyEvent i_evt, EditPartViewer i_viewer) {
        super.keyUp(i_evt, i_viewer);
        this.m_handler.setScene(this.getScene());
        this.m_handler.keyUp(i_evt);
    }

    public void mouseWheelScrolled(Event i_event, EditPartViewer i_viewer) {
        super.mouseWheelScrolled(i_event, i_viewer);
        this.m_handler.setScene(this.getScene());
        this.m_handler.mouseWheelScrolled(i_event.count);
    }

    private void restoreCursor() {
        if (this.m_pushedCursor != null) {
            Control ctrl = this.getCurrentViewer().getControl();
            ctrl.setCursor(this.m_pushedCursor);
            this.m_pushedCursor = null;
        }
    }

    private void setCursor(int i_cursorId) {
        Control ctrl = this.getCurrentViewer().getControl();
        while (ctrl != null) {
            if (ctrl.getCursor() != null) {
                this.m_pushedCursor = ctrl.getCursor();
                break;
            }
            ctrl = ctrl.getParent();
        }
        this.m_pushedCursor = this.getCurrentViewer().getControl().getDisplay().getSystemCursor(0);
        ctrl = this.getCurrentViewer().getControl();
        Display display = ctrl.getDisplay();
        Cursor cursor = display.getSystemCursor(i_cursorId);
        ctrl.setCursor(cursor);
    }
}

