/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;

public class ArcRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = -8516218845415390970L;
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    protected transient Location loTopLeft = null;
    protected double dWidth;
    protected double dHeight;
    protected double dStartInDegrees;
    protected double dExtentInDegrees;
    protected double dInnerRadius;
    protected double dOuterRadius;
    protected transient LineAttributes outline;
    protected transient Fill ifBackground = null;
    protected int iStyle = 3;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    public static final int SECTOR = 3;

    public ArcRenderEvent(Object oSource) {
        super(oSource);
    }

    @Override
    public void reset() {
        this.loTopLeft = null;
        this.dWidth = 0.0;
        this.dHeight = 0.0;
        this.dStartInDegrees = 0.0;
        this.dExtentInDegrees = 0.0;
        this.dInnerRadius = 0.0;
        this.dOuterRadius = 0.0;
        this.outline = null;
        this.ifBackground = null;
        this.iStyle = 3;
    }

    public final int getStyle() {
        return this.iStyle;
    }

    public final void setStyle(int style) {
        this.iStyle = style;
    }

    public final Location getTopLeft() {
        return this.loTopLeft;
    }

    public final void setTopLeft(Location loTopLeft) {
        this.loTopLeft = loTopLeft;
    }

    public final double getAngleExtent() {
        return this.dExtentInDegrees;
    }

    public final void setAngleExtent(double angleExtent) {
        this.dExtentInDegrees = angleExtent;
    }

    @Deprecated
    public final void setEndAngle(double endAngle) {
        this.dExtentInDegrees = endAngle;
    }

    @Override
    public final Fill getBackground() {
        return this.ifBackground;
    }

    public final void setBackground(Fill ifBackground) {
        this.ifBackground = ifBackground;
    }

    public double getWidth() {
        return this.dWidth;
    }

    public void setWidth(double width) {
        this.dWidth = width;
    }

    public double getHeight() {
        return this.dHeight;
    }

    public void setHeight(double height) {
        this.dHeight = height;
    }

    public final double getStartAngle() {
        return this.dStartInDegrees;
    }

    public final void setStartAngle(double startAngle) {
        this.dStartInDegrees = startAngle;
    }

    public final void setBounds(Bounds bo) {
        this.setTopLeft(goFactory.createLocation(bo.getLeft(), bo.getTop()));
        this.setWidth(bo.getWidth());
        this.setHeight(bo.getHeight());
    }

    public Bounds getEllipseBounds() {
        return goFactory.createBounds(this.loTopLeft.getX(), this.loTopLeft.getY(), this.dWidth, this.dHeight);
    }

    private double normalizeDegrees(double angle) {
        if (angle > 180.0) {
            if (angle <= 540.0) {
                angle -= 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        } else if (angle <= -180.0) {
            if (angle > -540.0) {
                angle += 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        }
        return angle;
    }

    private boolean containsAngle(double angle) {
        boolean backwards;
        double angExt = this.getAngleExtent();
        boolean bl = backwards = angExt < 0.0;
        if (backwards) {
            angExt = -angExt;
        }
        if (angExt >= 360.0) {
            return true;
        }
        angle = this.normalizeDegrees(angle) - this.normalizeDegrees(this.getStartAngle());
        if (backwards) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle >= 0.0 && angle < angExt;
    }

    @Override
    public Bounds getBounds() {
        double x1;
        double y1;
        double x2;
        double y2;
        if (this.getStyle() == 3) {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        } else {
            y1 = 1.0;
            x1 = 1.0;
            y2 = -1.0;
            x2 = -1.0;
        }
        double angle = 0.0;
        int i = 0;
        while (i < 6) {
            block5: {
                block4: {
                    block3: {
                        if (i >= 4) break block3;
                        if (this.containsAngle(angle += 90.0)) break block4;
                        break block5;
                    }
                    angle = i == 4 ? this.getStartAngle() : (angle += this.getAngleExtent());
                }
                double rads = Math.toRadians(-angle);
                double xe = Math.cos(rads);
                double ye = Math.sin(rads);
                x1 = Math.min(x1, xe);
                y1 = Math.min(y1, ye);
                x2 = Math.max(x2, xe);
                y2 = Math.max(y2, ye);
            }
            ++i;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        x2 = (x2 - x1) * 0.5 * w;
        y2 = (y2 - y1) * 0.5 * h;
        x1 = this.getTopLeft().getX() + (x1 * 0.5 + 0.5) * w;
        y1 = this.getTopLeft().getY() + (y1 * 0.5 + 0.5) * h;
        return goFactory.createBounds(x1, y1, x2, y2);
    }

    public final LineAttributes getOutline() {
        return this.outline;
    }

    public final void setOutline(LineAttributes outline) {
        this.outline = outline;
    }

    public double getInnerRadius() {
        return this.dInnerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this.dInnerRadius = innerRadius;
    }

    public double getOuterRadius() {
        return this.dOuterRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this.dOuterRadius = outerRadius;
    }

    @Override
    public PrimitiveRenderEvent copy() throws ChartException {
        ArcRenderEvent are = new ArcRenderEvent(this.source);
        if (this.outline != null) {
            are.setOutline(goFactory.copyOf(this.outline));
        }
        if (this.ifBackground != null) {
            are.setBackground(goFactory.copyOf(this.ifBackground));
        }
        if (this.loTopLeft != null) {
            are.setTopLeft(this.loTopLeft.copyInstance());
        }
        are.setStyle(this.iStyle);
        are.setWidth(this.dWidth);
        are.setHeight(this.dHeight);
        are.setStartAngle(this.dStartInDegrees);
        are.setEndAngle(this.dExtentInDegrees);
        are.setInnerRadius(this.dInnerRadius);
        are.setOuterRadius(this.dOuterRadius);
        return are;
    }

    @Override
    public void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawArc(this);
    }

    @Override
    public void fill(IDeviceRenderer idr) throws ChartException {
        idr.fillArc(this);
    }

    @Override
    public LineAttributes getLineAttributes() {
        return this.getOutline();
    }
}

