/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.gradle;

import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;

public final class GradleDistributionWrapper {
    private final DistributionType type;
    private final String configuration;

    private GradleDistributionWrapper(DistributionType type, String configuration) {
        this.type = (DistributionType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.configuration = configuration;
    }

    public DistributionType getType() {
        return this.type;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public GradleDistribution toGradleDistribution() {
        if (this.type == DistributionType.LOCAL_INSTALLATION) {
            return GradleDistribution.forLocalInstallation((File)new File(this.configuration));
        }
        if (this.type == DistributionType.REMOTE_DISTRIBUTION) {
            return GradleDistribution.forRemoteDistribution((URI)this.createURI(this.configuration));
        }
        if (this.type == DistributionType.VERSION) {
            return GradleDistribution.forVersion((String)this.configuration);
        }
        return GradleDistribution.fromBuild();
    }

    private URI createURI(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static GradleDistributionWrapper from(DistributionType type, String configuration) {
        return new GradleDistributionWrapper(type, configuration);
    }

    public static GradleDistributionWrapper from(GradleDistribution distribution) {
        Preconditions.checkNotNull((Object)distribution);
        try {
            Field localInstallationDirField = GradleDistribution.class.getDeclaredField("localInstallationDir");
            localInstallationDirField.setAccessible(true);
            File localInstallationDir = (File)localInstallationDirField.get(distribution);
            if (localInstallationDir != null) {
                return GradleDistributionWrapper.from(DistributionType.LOCAL_INSTALLATION, localInstallationDir.getAbsolutePath());
            }
            Field remoteDistributionUriField = GradleDistribution.class.getDeclaredField("remoteDistributionUri");
            remoteDistributionUriField.setAccessible(true);
            URI remoteDistributionUri = (URI)remoteDistributionUriField.get(distribution);
            if (remoteDistributionUri != null) {
                return GradleDistributionWrapper.from(DistributionType.REMOTE_DISTRIBUTION, remoteDistributionUri.toString());
            }
            Field versionField = GradleDistribution.class.getDeclaredField("version");
            versionField.setAccessible(true);
            String version = (String)versionField.get(distribution);
            if (version != null) {
                return GradleDistributionWrapper.from(DistributionType.VERSION, version);
            }
            return GradleDistributionWrapper.from(DistributionType.WRAPPER, null);
        }
        catch (Exception e) {
            String message = String.format("Cannot serialize Gradle distribution '%s.'", distribution);
            throw new RuntimeException(message, e);
        }
    }

    public static enum DistributionType {
        WRAPPER,
        LOCAL_INSTALLATION,
        REMOTE_DISTRIBUTION,
        VERSION;

    }
}

