/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReflectionUtil {
    public static <T> Map<String, PropertyAccessor> readableProperties(Class<T> target) {
        HashMap<String, PropertyAccessor> properties = new HashMap<String, PropertyAccessor>();
        for (Method method : target.getMethods()) {
            String propertyName;
            if (method.getName().startsWith("get") && JavaReflectionUtil.isGetter(method)) {
                propertyName = method.getName().substring(3);
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                properties.put(propertyName, new GetterMethodBackedPropertyAccessor(propertyName, Object.class, method));
                continue;
            }
            if (!method.getName().startsWith("is") || !JavaReflectionUtil.isBooleanGetter(method)) continue;
            propertyName = method.getName().substring(2);
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            properties.put(propertyName, new GetterMethodBackedPropertyAccessor(propertyName, Object.class, method));
        }
        return properties;
    }

    public static <T, F> PropertyAccessor<T, F> readableProperty(Class<T> target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Method getterMethod = JavaReflectionUtil.findGetterMethod(target, property);
        if (getterMethod == null) {
            throw new NoSuchPropertyException(String.format("Could not find getter method for property '%s' on class %s.", property, target.getSimpleName()));
        }
        return new GetterMethodBackedPropertyAccessor(property, returnType, getterMethod);
    }

    public static <T, F> PropertyAccessor<T, F> readableProperty(T target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.readableProperty(targetClass, returnType, property);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(Class<T> target, Class<F> fieldType, String fieldName) throws NoSuchPropertyException {
        Field field;
        try {
            field = target.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchPropertyException(String.format("Could not find field '%s' on class %s.", fieldName, target.getSimpleName()));
        }
        return new FieldBackedPropertyAccessor(fieldName, fieldType, field);
    }

    public static <T, F> PropertyAccessor<T, F> readableField(T target, Class<F> fieldType, String fieldName) throws NoSuchPropertyException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.readableField(targetClass, fieldType, fieldName);
    }

    private static Method findGetterMethod(Class<?> target, String property) {
        Method getterMethod;
        try {
            getterMethod = target.getMethod(JavaReflectionUtil.toMethodName("get", property), new Class[0]);
            if (JavaReflectionUtil.isGetter(getterMethod)) {
                return getterMethod;
            }
        }
        catch (java.lang.NoSuchMethodException e) {
            // empty catch block
        }
        try {
            getterMethod = target.getMethod(JavaReflectionUtil.toMethodName("is", property), new Class[0]);
            if (JavaReflectionUtil.isBooleanGetter(getterMethod)) {
                return getterMethod;
            }
        }
        catch (java.lang.NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers()) && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isBooleanGetter(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers()) && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class));
    }

    public static PropertyMutator writeableProperty(Class<?> target, String property) throws NoSuchPropertyException {
        String setterName = JavaReflectionUtil.toMethodName("set", property);
        for (Method method : target.getMethods()) {
            if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers())) continue;
            return new MethodBackedPropertyMutator(property, method);
        }
        throw new NoSuchPropertyException(String.format("Could not find setter method for property '%s' on class %s.", property, target.getSimpleName()));
    }

    private static String toMethodName(String prefix, String propertyName) {
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type) {
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know the wrapper type for primitive type %s.", type));
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> staticMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, true, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(T target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        return JavaReflectionUtil.method(targetClass, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, Method method) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, method);
    }

    public static <T, R> JavaMethod<T, R> method(T target, Class<R> returnType, Method method) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        return new JavaMethod(targetClass, returnType, method);
    }

    public static void searchMethods(Class<?> target, final Transformer<Boolean, Method> stopIndicator) {
        Spec<Method> stopIndicatorAsSpec = new Spec<Method>(){

            @Override
            public boolean isSatisfiedBy(Method element) {
                return (Boolean)stopIndicator.transform(element);
            }
        };
        JavaReflectionUtil.findAllMethodsInternal(target, stopIndicatorAsSpec, new MultiMap<String, Method>(), new ArrayList<Method>(1), true);
    }

    public static Method findMethod(Class<?> target, Spec<Method> predicate) {
        List<Method> methods = JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(1), true);
        return methods.isEmpty() ? null : methods.get(0);
    }

    public static List<Method> findAllMethods(Class<?> target, Spec<Method> predicate) {
        return JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(), false);
    }

    public static boolean propertyExists(Object target, String propertyName) {
        Class<?> targetType = target.getClass();
        Method getterMethod = JavaReflectionUtil.findGetterMethod(target.getClass(), propertyName);
        if (getterMethod == null) {
            try {
                targetType.getField(propertyName);
                return true;
            }
            catch (NoSuchFieldException ignore) {}
        } else {
            return true;
        }
        return false;
    }

    private static List<Method> findAllMethodsInternal(Class<?> target, Spec<Method> predicate, MultiMap<String, Method> seen, List<Method> collector, boolean stopAtFirst) {
        for (final Method method : target.getDeclaredMethods()) {
            Object seenWithName = seen.get(method.getName());
            Method override = CollectionUtils.findFirst(seenWithName, new Spec<Method>(){

                @Override
                public boolean isSatisfiedBy(Method potentionOverride) {
                    return potentionOverride.getName().equals(method.getName()) && Arrays.equals(potentionOverride.getParameterTypes(), method.getParameterTypes());
                }
            });
            if (override != null) continue;
            seenWithName.add(method);
            if (!predicate.isSatisfiedBy(method)) continue;
            collector.add(method);
            if (!stopAtFirst) continue;
            return collector;
        }
        Class<?> parent = target.getSuperclass();
        if (parent != null) {
            return JavaReflectionUtil.findAllMethodsInternal(parent, predicate, seen, collector, stopAtFirst);
        }
        return collector;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return JavaReflectionUtil.getAnnotation(type, annotationType, true);
    }

    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType, boolean checkType) {
        A annotation;
        if (checkType && (annotation = type.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        if (annotationType.getAnnotation(Inherited.class) != null) {
            for (Class<?> anInterface : type.getInterfaces()) {
                annotation = JavaReflectionUtil.getAnnotation(anInterface, annotationType, true);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if (type.isInterface() || type.equals(Object.class)) {
            return null;
        }
        return JavaReflectionUtil.getAnnotation(type.getSuperclass(), annotationType, false);
    }

    public static <T> Factory<T> factory(Instantiator instantiator, Class<? extends T> type, Object ... args) {
        return new InstantiatingFactory<T>(instantiator, type, args);
    }

    public static boolean hasDefaultToString(Object object) {
        try {
            return object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class;
        }
        catch (java.lang.NoSuchMethodException e) {
            throw new UncheckedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Field field;
        private final Class<F> fieldType;

        public FieldBackedPropertyAccessor(String property, Class<F> fieldType, Field field) {
            this.property = property;
            this.field = field;
            this.fieldType = fieldType;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.fieldType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.fieldType.cast(this.field.get(target));
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetterMethodBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Method method;
        private final Class<F> returnType;

        public GetterMethodBackedPropertyAccessor(String property, Class<F> returnType, Method method) {
            this.property = property;
            this.method = method;
            this.returnType = returnType;
        }

        public String toString() {
            return String.format("property %s.%s", this.method.getDeclaringClass().getSimpleName(), this.property);
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.returnType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.returnType.cast(this.method.invoke(target, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow(e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstantiatingFactory<T>
    implements Factory<T> {
        private final Instantiator instantiator;
        private final Class<? extends T> type;
        private final Object[] args;

        public InstantiatingFactory(Instantiator instantiator, Class<? extends T> type, Object ... args) {
            this.instantiator = instantiator;
            this.type = type;
            this.args = args;
        }

        @Override
        public T create() {
            return this.instantiator.newInstance(this.type, this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodBackedPropertyMutator
    implements PropertyMutator {
        private final String property;
        private final Method method;

        public MethodBackedPropertyMutator(String property, Method method) {
            this.property = property;
            this.method = method;
        }

        public String toString() {
            return String.format("property %s.%s", this.method.getDeclaringClass().getSimpleName(), this.property);
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<?> getType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            try {
                this.method.invoke(target, value);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow(e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiMap<K, V>
    extends HashMap<K, List<V>> {
        private MultiMap() {
        }

        @Override
        public List<V> get(Object key) {
            if (!this.containsKey(key)) {
                Object keyCast = key;
                this.put(keyCast, new LinkedList());
            }
            return (List)super.get(key);
        }
    }
}

