/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.core.internal.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.internal.view.task.TaskViewActionStateRules;
import org.eclipse.core.resources.IProject;
import org.gradle.tooling.model.HierarchicalElement;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskNodeSelectionUtils {
    private TaskNodeSelectionUtils() {
    }

    public static boolean isValidRunConfiguration(NodeSelection selection) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean() || TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection);
    }

    public static Optional<GradleRunConfigurationAttributes> tryGetRunConfigurationAttributes(NodeSelection selection) {
        if (TaskNodeSelectionUtils.isValidRunConfiguration(selection)) {
            return Optional.of((Object)TaskNodeSelectionUtils.getRunConfigurationAttributes(selection));
        }
        return Optional.absent();
    }

    public static GradleRunConfigurationAttributes getRunConfigurationAttributes(NodeSelection selection) {
        Preconditions.checkNotNull((Object)selection);
        ImmutableList<String> tasks = TaskNodeSelectionUtils.getTaskPathStrings(selection);
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean()) {
            return TaskNodeSelectionUtils.runConfigAttributesForTask(selection, tasks);
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            return TaskNodeSelectionUtils.runConfigAttributesForProject(selection, tasks);
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }

    private static GradleRunConfigurationAttributes runConfigAttributesForTask(NodeSelection selection, List<String> tasks) {
        TaskNode taskNode = selection.getFirstElement(TaskNode.class);
        File rootDir = ((EclipseProject)HierarchicalElementUtils.getRoot((HierarchicalElement)taskNode.getParentProjectNode().getEclipseProject())).getProjectDirectory();
        File workingDir = TaskNodeSelectionUtils.workingDirForTask(taskNode, rootDir);
        return TaskNodeSelectionUtils.createARunConfigAttributes(rootDir, workingDir, tasks);
    }

    private static File workingDirForTask(TaskNode taskNode, File rootDir) {
        if (taskNode instanceof ProjectTaskNode) {
            return taskNode.getParentProjectNode().getBuildNode().getBuildTreeNode().getRootProjectDir();
        }
        if (taskNode instanceof TaskSelectorNode) {
            return taskNode.getParentProjectNode().getEclipseProject().getProjectDirectory();
        }
        throw new GradlePluginsRuntimeException("Unrecognized task type " + taskNode.getClass().getName());
    }

    private static GradleRunConfigurationAttributes runConfigAttributesForProject(NodeSelection selection, List<String> tasks) {
        ProjectNode projectNode = selection.getFirstElement(ProjectNode.class);
        File rootDir = ((EclipseProject)HierarchicalElementUtils.getRoot((HierarchicalElement)projectNode.getEclipseProject())).getProjectDirectory();
        return TaskNodeSelectionUtils.createARunConfigAttributes(rootDir, rootDir, tasks);
    }

    private static GradleRunConfigurationAttributes createARunConfigAttributes(File rootDir, File workingDir, List<String> tasks) {
        BuildConfiguration buildConfig = CorePlugin.configurationManager().loadBuildConfiguration(rootDir);
        return new GradleRunConfigurationAttributes(tasks, TaskNodeSelectionUtils.projectDirectoryExpression(workingDir), buildConfig.getGradleDistribution().toString(), TaskNodeSelectionUtils.gradleUserHomeExpression(buildConfig.getGradleUserHome()), TaskNodeSelectionUtils.javaHomeExpression(buildConfig.getJavaHome()), buildConfig.getJvmArguments(), buildConfig.getArguments(), buildConfig.isShowExecutionsView(), buildConfig.isShowExecutionsView(), buildConfig.isOverrideWorkspaceSettings(), buildConfig.isOfflineMode(), buildConfig.isBuildScansEnabled());
    }

    private static String projectDirectoryExpression(File rootProjectDir) {
        Optional project = CorePlugin.workspaceOperations().findProjectByLocation(rootProjectDir);
        if (project.isPresent()) {
            return ExpressionUtils.encodeWorkspaceLocation((IProject)((IProject)project.get()));
        }
        return rootProjectDir.getAbsolutePath();
    }

    private static String gradleUserHomeExpression(File gradleUserHome) {
        return gradleUserHome == null ? "" : gradleUserHome.getAbsolutePath();
    }

    private static String javaHomeExpression(File javaHome) {
        return javaHome == null ? "" : javaHome.getAbsolutePath();
    }

    private static ImmutableList<String> getTaskPathStrings(NodeSelection selection) {
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean()) {
            ImmutableList.Builder taskStrings = ImmutableList.builder();
            block4: for (TaskNode node : selection.toList(TaskNode.class)) {
                TaskNode.TaskNodeType type = node.getType();
                switch (type) {
                    case PROJECT_TASK_NODE: {
                        taskStrings.add((Object)((ProjectTaskNode)node).getPath());
                        continue block4;
                    }
                    case TASK_SELECTOR_NODE: {
                        taskStrings.add((Object)((TaskSelectorNode)node).getName());
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unsupported Task node type: " + (Object)((Object)type));
            }
            return taskStrings.build();
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            return ImmutableList.of();
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }
}

