/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.buildship.core.internal.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProject;
import org.eclipse.buildship.core.internal.util.gradle.JavaVersionUtil;
import org.eclipse.buildship.core.internal.workspace.EclipseVmUtil;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.gradle.tooling.model.eclipse.EclipseClasspathContainer;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;
import org.gradle.tooling.model.eclipse.EclipseJavaSourceSettings;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class ClasspathContainerUpdater {
    private static final IPath DEFAULT_JRE_PATH = JavaRuntime.newDefaultJREContainerPath();
    private final IJavaProject project;
    private final boolean gradleSupportsContainers;
    private final Iterable<? extends EclipseClasspathContainer> containers;
    private final EclipseJavaSourceSettings sourceSettings;

    private ClasspathContainerUpdater(IJavaProject project, EclipseProject eclipseProject) {
        this.project = project;
        this.gradleSupportsContainers = CompatEclipseProject.supportsClasspathContainers(eclipseProject);
        this.containers = eclipseProject.getClasspathContainers();
        this.sourceSettings = eclipseProject.getJavaSourceSettings();
    }

    private void updateContainers(IProgressMonitor monitor) throws CoreException {
        ArrayList classpath = Lists.newArrayList((Object[])this.project.getRawClasspath());
        this.updateContainers(classpath);
        this.project.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), monitor);
    }

    private void updateContainers(List<IClasspathEntry> classpath) throws JavaModelException {
        if (this.gradleSupportsContainers) {
            this.overWriteContainers(classpath);
        } else {
            this.updateJre(classpath);
        }
    }

    private void overWriteContainers(List<IClasspathEntry> classpath) {
        this.removeOldContainers(classpath);
        LinkedHashMap containersToAdd = Maps.newLinkedHashMap();
        for (EclipseClasspathContainer eclipseClasspathContainer : this.containers) {
            IClasspathEntry entry = ClasspathContainerUpdater.createContainerEntry(eclipseClasspathContainer);
            containersToAdd.put(entry.getPath(), entry);
        }
        this.ensureGradleContainerIsPresent(containersToAdd);
        classpath.addAll(this.indexOfNewContainers(classpath), containersToAdd.values());
    }

    private void updateJre(List<IClasspathEntry> classpath) {
        Map<IPath, IClasspathEntry> oldContainers = this.removeOldContainers(classpath);
        LinkedHashMap containersToAdd = Maps.newLinkedHashMap();
        IClasspathEntry jreEntry = ClasspathContainerUpdater.createContainerEntry(this.getJrePathFromSourceSettings());
        containersToAdd.put(jreEntry.getPath(), jreEntry);
        containersToAdd.putAll(oldContainers);
        this.ensureGradleContainerIsPresent(containersToAdd);
        classpath.addAll(this.indexOfNewContainers(classpath), containersToAdd.values());
    }

    private Map<IPath, IClasspathEntry> removeOldContainers(List<IClasspathEntry> classpath) {
        LinkedHashMap retainedEntries = Maps.newLinkedHashMap();
        ListIterator<IClasspathEntry> iterator = classpath.listIterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = iterator.next();
            if (entry.getEntryKind() != 5) continue;
            if (this.shouldRetainContainer(entry)) {
                retainedEntries.put(entry.getPath(), entry);
            }
            iterator.remove();
        }
        return retainedEntries;
    }

    private boolean shouldRetainContainer(IClasspathEntry entry) {
        return !DEFAULT_JRE_PATH.isPrefixOf(entry.getPath());
    }

    private void ensureGradleContainerIsPresent(LinkedHashMap<IPath, IClasspathEntry> containersToAdd) {
        if (!containersToAdd.containsKey(GradleClasspathContainer.CONTAINER_PATH)) {
            containersToAdd.put((IPath)GradleClasspathContainer.CONTAINER_PATH, ClasspathContainerUpdater.createContainerEntry((IPath)GradleClasspathContainer.CONTAINER_PATH));
        }
    }

    private IPath getJrePathFromSourceSettings() {
        String targetVersion = JavaVersionUtil.adaptVersionToEclipseNamingConversions(this.sourceSettings.getTargetBytecodeVersion());
        File vmLocation = this.sourceSettings.getJdk().getJavaHome();
        IVMInstall vm = EclipseVmUtil.findOrRegisterStandardVM(targetVersion, vmLocation);
        Optional<IExecutionEnvironment> executionEnvironment = EclipseVmUtil.findExecutionEnvironment(targetVersion);
        return executionEnvironment.isPresent() ? JavaRuntime.newJREContainerPath((IExecutionEnvironment)((IExecutionEnvironment)executionEnvironment.get())) : JavaRuntime.newJREContainerPath((IVMInstall)vm);
    }

    private int indexOfNewContainers(List<IClasspathEntry> classpath) {
        int index = 0;
        for (int i = 0; i < classpath.size(); ++i) {
            if (classpath.get(i).getEntryKind() != 3) continue;
            index = i + 1;
        }
        return index;
    }

    private static IClasspathEntry createContainerEntry(EclipseClasspathContainer container) {
        Path containerPath = new Path(container.getPath());
        boolean isExported = container.isExported();
        IAccessRule[] accessRules = ClasspathUtils.createAccessRules((EclipseClasspathEntry)container);
        IClasspathAttribute[] attributes = ClasspathUtils.createClasspathAttributes((EclipseClasspathEntry)container);
        return JavaCore.newContainerEntry((IPath)containerPath, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)isExported);
    }

    private static IClasspathEntry createContainerEntry(IPath path) {
        return JavaCore.newContainerEntry((IPath)path);
    }

    public static void update(IJavaProject project, EclipseProject eclipseProject, IProgressMonitor monitor) throws CoreException {
        new ClasspathContainerUpdater(project, eclipseProject).updateContainers(monitor);
    }
}

