/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.operation.ToolingApiJob;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class ReloadTaskViewJob
extends ToolingApiJob<TaskViewContent> {
    private final TaskView taskView;
    private final FetchStrategy modelFetchStrategy;

    public ReloadTaskViewJob(TaskView taskView, FetchStrategy modelFetchStrategy) {
        super("Loading tasks of all Gradle projects");
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
        this.setResultHandler(new ResultHandler());
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public TaskViewContent runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        return this.loadContent(tokenSource, monitor);
    }

    private TaskViewContent loadContent(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        LinkedHashMap<File, Map<String, EclipseProject>> allModels = new LinkedHashMap<File, Map<String, EclipseProject>>();
        LinkedHashMap<File, BuildEnvironment> environments = new LinkedHashMap<File, BuildEnvironment>();
        ArrayList<InternalGradleBuild> faultyBuilds = new ArrayList<InternalGradleBuild>();
        for (InternalGradleBuild gradleBuild : CorePlugin.internalGradleWorkspace().getGradleBuilds()) {
            try {
                BuildEnvironment buildEnvironment = (BuildEnvironment)gradleBuild.getModelProvider().fetchModel(BuildEnvironment.class, this.modelFetchStrategy, tokenSource, monitor);
                Map models = gradleBuild.getModelProvider().fetchModels(EclipseProject.class, this.modelFetchStrategy, tokenSource, monitor);
                if (buildEnvironment != null && models != null) {
                    allModels.put(gradleBuild.getBuildConfig().getRootProjectDirectory(), models);
                    environments.put(gradleBuild.getBuildConfig().getRootProjectDirectory(), buildEnvironment);
                    continue;
                }
                faultyBuilds.add(gradleBuild);
            }
            catch (RuntimeException e) {
                CorePlugin.logger().warn("Tasks can't be loaded for project located at " + gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath(), (Throwable)e);
                faultyBuilds.add(gradleBuild);
            }
        }
        return TaskViewContent.from(allModels, environments, faultyBuilds);
    }

    private void refreshTaskView(final TaskViewContent content) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ReloadTaskViewJob.this.taskView.setContent(content);
            }
        });
    }

    public boolean shouldSchedule() {
        Job[] jobs;
        for (Job job : jobs = Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof ReloadTaskViewJob)) continue;
            return false;
        }
        return true;
    }

    private class ResultHandler
    implements ToolingApiJobResultHandler<TaskViewContent> {
        private ResultHandler() {
        }

        public void onSuccess(TaskViewContent content) {
            ReloadTaskViewJob.this.refreshTaskView(content);
        }

        public void onFailure(ToolingApiStatus status) {
            CorePlugin.getInstance().getLog().log((IStatus)status);
        }
    }
}

