/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.TestRunConfiguration;
import org.eclipse.buildship.core.internal.launch.RunGradleTestLaunchRequestJob;
import org.eclipse.buildship.ui.internal.util.gradle.GradleUtils;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionPage;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.jface.action.Action;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class RunTestAction
extends Action
implements SelectionSpecificAction {
    private static final TestOperationItemPredicate TEST_OPERATION_ITEM_PREDICATE = new TestOperationItemPredicate();
    private final ExecutionPage executionPage;

    public RunTestAction(ExecutionPage executionPage) {
        super(ExecutionViewMessages.Action_RunTest_Text);
        this.executionPage = (ExecutionPage)Preconditions.checkNotNull((Object)executionPage);
    }

    public void run() {
        List<TestOperationDescriptor> tests = this.collectSelectedTests(this.executionPage.getSelection());
        List<TestOperationDescriptor> filteredTests = GradleUtils.filterChildren(tests);
        TestRunConfiguration runConfig = CorePlugin.configurationManager().loadTestRunConfiguration(this.executionPage.getProcessDescription().getRunConfig());
        RunGradleTestLaunchRequestJob runTestsJob = new RunGradleTestLaunchRequestJob(filteredTests, runConfig);
        runTestsJob.schedule();
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        return !selection.isEmpty() && FluentIterable.from(selection.toList(OperationItem.class)).anyMatch((Predicate)TEST_OPERATION_ITEM_PREDICATE);
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        return !selection.isEmpty() && FluentIterable.from(selection.toList(OperationItem.class)).allMatch((Predicate)TEST_OPERATION_ITEM_PREDICATE);
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }

    private List<TestOperationDescriptor> collectSelectedTests(NodeSelection nodeSelection) {
        return FluentIterable.from(nodeSelection.toList(OperationItem.class)).filter((Predicate)TEST_OPERATION_ITEM_PREDICATE).transform((Function)new Function<OperationItem, TestOperationDescriptor>(){

            public TestOperationDescriptor apply(OperationItem operationItem) {
                return (TestOperationDescriptor)operationItem.getDescriptor();
            }
        }).toList();
    }

    private static final class TestOperationItemPredicate
    implements Predicate<OperationItem> {
        private TestOperationItemPredicate() {
        }

        public boolean apply(OperationItem operationItem) {
            return operationItem.getDescriptor() instanceof TestOperationDescriptor;
        }
    }
}

