/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.extension;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class ProjectConfiguratorContribution {
    private final IConfigurationElement extension;
    private final String contributorPluginId;
    private final String id;
    private final List<String> runsBefore;
    private final List<String> runsAfter;
    private ProjectConfigurator configurator;

    private ProjectConfiguratorContribution(IConfigurationElement extension, String id, String contributorPluginId, List<String> runsBefore, List<String> runsAfter) {
        this.extension = extension;
        this.id = id;
        this.contributorPluginId = contributorPluginId;
        this.runsBefore = runsBefore;
        this.runsAfter = runsAfter;
    }

    public ProjectConfigurator createConfigurator() throws CoreException {
        if (this.configurator == null) {
            this.configurator = (ProjectConfigurator)ProjectConfigurator.class.cast(this.extension.createExecutableExtension("class"));
        }
        return this.configurator;
    }

    public String getId() {
        return this.id;
    }

    public String getContributorPluginId() {
        return this.contributorPluginId;
    }

    public List<String> getRunsBefore() {
        return this.runsBefore;
    }

    public List<String> getRunsAfter() {
        return this.runsAfter;
    }

    static ProjectConfiguratorContribution from(IConfigurationElement extension) {
        String pluginId = extension.getContributor().getName();
        String id = extension.getAttribute("id");
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        String runsBeforeString = extension.getAttribute("runsBefore");
        ArrayList runsBefore = runsBeforeString == null ? Collections.emptyList() : Lists.newArrayList((Iterable)splitter.split((CharSequence)runsBeforeString));
        String runsAfterString = extension.getAttribute("runsAfter");
        ArrayList runsAfter = runsAfterString == null ? Collections.emptyList() : Lists.newArrayList((Iterable)splitter.split((CharSequence)runsAfterString));
        return new ProjectConfiguratorContribution(extension, id, pluginId, runsBefore, runsAfter);
    }

    public static ProjectConfiguratorContribution from(ProjectConfiguratorContribution contribuion, List<String> runsBefore, List<String> runsAfter) {
        return new ProjectConfiguratorContribution(contribuion.extension, contribuion.id, contribuion.contributorPluginId, runsBefore, runsAfter);
    }

    public String toString() {
        return "ProjectConfiguratorContribution [id=" + this.getId() + ", runsBefore=" + String.valueOf(this.runsBefore) + ", runsAfter=" + String.valueOf(this.runsAfter) + "]";
    }
}

