/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProviderFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.buildship.core.Logger;
import org.eclipse.buildship.core.configuration.ConfigurationManager;
import org.eclipse.buildship.core.configuration.internal.DefaultConfigurationManager;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.console.internal.StdProcessStreamsProvider;
import org.eclipse.buildship.core.event.ListenerRegistry;
import org.eclipse.buildship.core.event.internal.DefaultListenerRegistry;
import org.eclipse.buildship.core.invocation.InvocationCustomizer;
import org.eclipse.buildship.core.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.launch.internal.DefaultGradleLaunchConfigurationManager;
import org.eclipse.buildship.core.notification.UserNotification;
import org.eclipse.buildship.core.notification.internal.ConsoleUserNotification;
import org.eclipse.buildship.core.preferences.ModelPersistence;
import org.eclipse.buildship.core.preferences.internal.DefaultModelPersistence;
import org.eclipse.buildship.core.util.extension.InvocationCustomizerCollector;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.util.logging.EclipseLogger;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.internal.DefaultWorkspaceOperations;
import org.eclipse.buildship.core.workspace.internal.ProjectChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.core";
    public static final String GRADLE_JOB_FAMILY = "org.eclipse.buildship.core.jobs";
    private static CorePlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration publishedGradleVersionsService;
    private ServiceRegistration toolingClientService;
    private ServiceRegistration modelRepositoryProviderService;
    private ServiceRegistration workspaceOperationsService;
    private ServiceRegistration gradleWorkspaceManagerService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration gradleLaunchConfigurationService;
    private ServiceRegistration listenerRegistryService;
    private ServiceRegistration userNotificationService;
    private ServiceTracker loggerServiceTracker;
    private ServiceTracker publishedGradleVersionsServiceTracker;
    private ServiceTracker toolingClientServiceTracker;
    private ServiceTracker modelRepositoryProviderServiceTracker;
    private ServiceTracker workspaceOperationsServiceTracker;
    private ServiceTracker gradleWorkspaceManagerServiceTracker;
    private ServiceTracker processStreamsProviderServiceTracker;
    private ServiceTracker gradleLaunchConfigurationServiceTracker;
    private ServiceTracker listenerRegistryServiceTracker;
    private ServiceTracker userNotificationServiceTracker;
    private DefaultModelPersistence modelPersistence;
    private ProjectChangeListener projectChangeListener;
    private InvocationCustomizer invocationCustomizer;
    private ConfigurationManager configurationManager;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.ensureProxySettingsApplied();
        this.registerServices(bundleContext);
    }

    public void stop(BundleContext context) throws Exception {
        CorePlugin.toolingClient().stop(ToolingClient.CleanUpStrategy.GRACEFULLY);
        this.unregisterServices();
        plugin = null;
        super.stop(context);
    }

    private void ensureProxySettingsApplied() throws Exception {
        Platform.getBundle((String)"org.eclipse.core.net").start(1);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        this.loggerServiceTracker = this.createServiceTracker(context, Logger.class);
        this.publishedGradleVersionsServiceTracker = this.createServiceTracker(context, PublishedGradleVersionsWrapper.class);
        this.toolingClientServiceTracker = this.createServiceTracker(context, ToolingClient.class);
        this.modelRepositoryProviderServiceTracker = this.createServiceTracker(context, ModelRepositoryProvider.class);
        this.workspaceOperationsServiceTracker = this.createServiceTracker(context, WorkspaceOperations.class);
        this.gradleWorkspaceManagerServiceTracker = this.createServiceTracker(context, GradleWorkspaceManager.class);
        this.processStreamsProviderServiceTracker = this.createServiceTracker(context, ProcessStreamsProvider.class);
        this.gradleLaunchConfigurationServiceTracker = this.createServiceTracker(context, GradleLaunchConfigurationManager.class);
        this.listenerRegistryServiceTracker = this.createServiceTracker(context, ListenerRegistry.class);
        this.userNotificationServiceTracker = this.createServiceTracker(context, UserNotification.class);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.publishedGradleVersionsService = this.registerService(context, PublishedGradleVersionsWrapper.class, this.createPublishedGradleVersions(), preferences);
        this.toolingClientService = this.registerService(context, ToolingClient.class, this.createToolingClient(), preferences);
        this.modelRepositoryProviderService = this.registerService(context, ModelRepositoryProvider.class, this.createModelRepositoryProvider(), preferences);
        this.workspaceOperationsService = this.registerService(context, WorkspaceOperations.class, this.createWorkspaceOperations(), preferences);
        this.gradleWorkspaceManagerService = this.registerService(context, GradleWorkspaceManager.class, this.createGradleWorkspaceManager(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createProcessStreamsProvider(), preferences);
        this.gradleLaunchConfigurationService = this.registerService(context, GradleLaunchConfigurationManager.class, this.createGradleLaunchConfigurationManager(), preferences);
        this.listenerRegistryService = this.registerService(context, ListenerRegistry.class, this.createListenerRegistry(), preferences);
        this.userNotificationService = this.registerService(context, UserNotification.class, this.createUserNotification(), preferences);
        this.modelPersistence = DefaultModelPersistence.createAndRegister();
        this.projectChangeListener = ProjectChangeListener.createAndRegister();
        this.invocationCustomizer = new InvocationCustomizerCollector();
        this.configurationManager = new DefaultConfigurationManager();
    }

    private ServiceTracker createServiceTracker(BundleContext context, Class<?> clazz) {
        ServiceTracker serviceTracker = new ServiceTracker(context, clazz.getName(), null);
        serviceTracker.open();
        return serviceTracker;
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        return new EclipseLogger(this.getLog(), PLUGIN_ID, this.isDebugging());
    }

    private PublishedGradleVersionsWrapper createPublishedGradleVersions() {
        return new PublishedGradleVersionsWrapper();
    }

    private ToolingClient createToolingClient() {
        return ToolingClient.newClient();
    }

    private ModelRepositoryProvider createModelRepositoryProvider() {
        ToolingClient toolingClient = (ToolingClient)this.toolingClientServiceTracker.getService();
        return ModelRepositoryProviderFactory.create((ToolingClient)toolingClient);
    }

    private WorkspaceOperations createWorkspaceOperations() {
        return new DefaultWorkspaceOperations();
    }

    private GradleWorkspaceManager createGradleWorkspaceManager() {
        return new DefaultGradleWorkspaceManager();
    }

    private ProcessStreamsProvider createProcessStreamsProvider() {
        return new StdProcessStreamsProvider();
    }

    private GradleLaunchConfigurationManager createGradleLaunchConfigurationManager() {
        return new DefaultGradleLaunchConfigurationManager();
    }

    private ListenerRegistry createListenerRegistry() {
        return new DefaultListenerRegistry();
    }

    private UserNotification createUserNotification() {
        return new ConsoleUserNotification();
    }

    private void unregisterServices() {
        this.projectChangeListener.close();
        this.modelPersistence.close();
        this.userNotificationService.unregister();
        this.listenerRegistryService.unregister();
        this.gradleLaunchConfigurationService.unregister();
        this.processStreamsProviderService.unregister();
        this.gradleWorkspaceManagerService.unregister();
        this.workspaceOperationsService.unregister();
        this.modelRepositoryProviderService.unregister();
        this.toolingClientService.unregister();
        this.publishedGradleVersionsService.unregister();
        this.loggerService.unregister();
        this.userNotificationServiceTracker.close();
        this.listenerRegistryServiceTracker.close();
        this.gradleLaunchConfigurationServiceTracker.close();
        this.processStreamsProviderServiceTracker.close();
        this.gradleWorkspaceManagerServiceTracker.close();
        this.workspaceOperationsServiceTracker.close();
        this.modelRepositoryProviderServiceTracker.close();
        this.toolingClientServiceTracker.close();
        this.publishedGradleVersionsServiceTracker.close();
        this.loggerServiceTracker.close();
    }

    public static CorePlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)CorePlugin.getInstance().loggerServiceTracker.getService();
    }

    public static PublishedGradleVersionsWrapper publishedGradleVersions() {
        return (PublishedGradleVersionsWrapper)CorePlugin.getInstance().publishedGradleVersionsServiceTracker.getService();
    }

    public static ToolingClient toolingClient() {
        return (ToolingClient)CorePlugin.getInstance().toolingClientServiceTracker.getService();
    }

    public static ModelRepositoryProvider modelRepositoryProvider() {
        return (ModelRepositoryProvider)CorePlugin.getInstance().modelRepositoryProviderServiceTracker.getService();
    }

    public static WorkspaceOperations workspaceOperations() {
        return (WorkspaceOperations)CorePlugin.getInstance().workspaceOperationsServiceTracker.getService();
    }

    public static GradleWorkspaceManager gradleWorkspaceManager() {
        return (GradleWorkspaceManager)CorePlugin.getInstance().gradleWorkspaceManagerServiceTracker.getService();
    }

    public static ProcessStreamsProvider processStreamsProvider() {
        return (ProcessStreamsProvider)CorePlugin.getInstance().processStreamsProviderServiceTracker.getService();
    }

    public static GradleLaunchConfigurationManager gradleLaunchConfigurationManager() {
        return (GradleLaunchConfigurationManager)CorePlugin.getInstance().gradleLaunchConfigurationServiceTracker.getService();
    }

    public static ListenerRegistry listenerRegistry() {
        return (ListenerRegistry)CorePlugin.getInstance().listenerRegistryServiceTracker.getService();
    }

    public static UserNotification userNotification() {
        return (UserNotification)CorePlugin.getInstance().userNotificationServiceTracker.getService();
    }

    public static ModelPersistence modelPersistence() {
        return CorePlugin.getInstance().modelPersistence;
    }

    public static InvocationCustomizer invocationCustomizer() {
        return CorePlugin.getInstance().invocationCustomizer;
    }

    public static ConfigurationManager configurationManager() {
        return CorePlugin.getInstance().configurationManager;
    }
}

