/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.workspace.internal.ManagedModelMergingStrategy;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class BuildCommandUpdater {
    BuildCommandUpdater() {
    }

    public static void update(IProject project, Optional<List<OmniEclipseBuildCommand>> buildCommands, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ImmutableSet current = ImmutableSet.copyOf((Object[])description.getBuildSpec());
        Set<ICommand> model = BuildCommandUpdater.toCommands(buildCommands, description);
        PersistentModel previousModel = persistentModel.getPrevious();
        LinkedHashSet managed = previousModel.isPresent() ? Sets.newLinkedHashSet(previousModel.getManagedBuilders()) : Sets.newLinkedHashSet();
        ManagedModelMergingStrategy.Result<ICommand> result = ManagedModelMergingStrategy.calculate(current, model, managed);
        description.setBuildSpec(result.getNextElements().toArray(new ICommand[0]));
        project.setDescription(description, monitor);
        persistentModel.managedBuilders(result.getNextManaged());
    }

    private static Set<ICommand> toCommands(Optional<List<OmniEclipseBuildCommand>> buildCommands, IProjectDescription description) {
        LinkedHashSet commands = Sets.newLinkedHashSet();
        if (buildCommands.isPresent()) {
            commands.addAll(BuildCommandUpdater.toCommands((List)buildCommands.get(), description));
        }
        commands.add(BuildCommandUpdater.toCommand("org.eclipse.buildship.core.gradleprojectbuilder", Collections.emptyMap(), description));
        return commands;
    }

    private static Set<? extends ICommand> toCommands(List<OmniEclipseBuildCommand> buildCommands, IProjectDescription description) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (OmniEclipseBuildCommand buildCommand : buildCommands) {
            result.add(BuildCommandUpdater.toCommand(buildCommand.getName(), buildCommand.getArguments(), description));
        }
        return result;
    }

    private static ICommand toCommand(String name, Map<String, String> arguments, IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName(name);
        command.setArguments(arguments);
        return command;
    }
}

