/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.LongRunningOperationPromise;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;

public final class ResultHandlerPromise<T>
extends LongRunningOperationPromise<T> {
    private final PromiseCompatibleResultHandler<T> resultHandler = new PromiseCompatibleResultHandler();

    public ResultHandler<T> getResultHandler() {
        return this.resultHandler;
    }

    @Override
    public LongRunningOperationPromise<T> onComplete(Consumer<? super T> completeHandler) {
        Preconditions.checkNotNull(completeHandler);
        ((PromiseCompatibleResultHandler)this.resultHandler).invokeOnComplete(completeHandler);
        return this;
    }

    @Override
    public LongRunningOperationPromise<T> onFailure(Consumer<? super GradleConnectionException> failureHandler) {
        Preconditions.checkNotNull(failureHandler);
        ((PromiseCompatibleResultHandler)this.resultHandler).invokeOnFailure(failureHandler);
        return this;
    }

    private static final class PromiseCompatibleResultHandler<T>
    implements ResultHandler<T> {
        private final Object LOCK = new Object();
        private Optional<? extends Consumer<? super T>> completeHandler = Optional.absent();
        private Optional<Optional<T>> completeResult = Optional.absent();
        private Optional<? extends Consumer<? super GradleConnectionException>> failureHandler = Optional.absent();
        private Optional<GradleConnectionException> failureException = Optional.absent();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(T result) {
            Consumer handler;
            Object object = this.LOCK;
            synchronized (object) {
                this.completeResult = Optional.of((Object)Optional.fromNullable(result));
                handler = (Consumer)this.completeHandler.orNull();
            }
            if (handler != null) {
                handler.accept(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(GradleConnectionException exception) {
            Consumer handler;
            Object object = this.LOCK;
            synchronized (object) {
                this.failureException = Optional.of((Object)exception);
                handler = (Consumer)this.failureHandler.orNull();
            }
            if (handler != null) {
                handler.accept(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeOnComplete(Consumer<? super T> completeHandler) {
            Optional result;
            Object object = this.LOCK;
            synchronized (object) {
                this.completeHandler = Optional.of(completeHandler);
                result = (Optional)this.completeResult.orNull();
            }
            if (result != null) {
                completeHandler.accept(result.orNull());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeOnFailure(Consumer<? super GradleConnectionException> failureHandler) {
            GradleConnectionException exception;
            Object object = this.LOCK;
            synchronized (object) {
                this.failureHandler = Optional.of(failureHandler);
                exception = (GradleConnectionException)this.failureException.orNull();
            }
            if (exception != null) {
                failureHandler.accept((GradleConnectionException)exception);
            }
        }
    }
}

