/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Set;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.CompositeGradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;

public class DefaultCompositeGradleBuild
implements CompositeGradleBuild {
    private final ImmutableSet<FixedRequestAttributes> attributes;
    private final ImmutableSet<GradleBuild> builds;

    public DefaultCompositeGradleBuild(Set<FixedRequestAttributes> attributes) {
        this.attributes = ImmutableSet.copyOf(attributes);
        ImmutableSet.Builder builds = ImmutableSet.builder();
        for (FixedRequestAttributes attribute : attributes) {
            builds.add((Object)new DefaultGradleBuild(attribute));
        }
        this.builds = builds.build();
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        new SynchronizeGradleBuildsJob((Set<FixedRequestAttributes>)this.attributes, newProjectHandler, AsyncHandler.NO_OP).schedule();
    }

    @Override
    public Set<GradleBuild> getParticipantBuilds() {
        return this.builds;
    }
}

