/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.image;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static ImageDescriptor findImageDescriptor(Bundle bundle, String path) {
        Preconditions.checkNotNull((Object)bundle);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)String.format("Invalid image path %s.", path));
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static Image getOverlayImage(String baseImageId, List<String> overlayImageIds, ImageRegistry imageRegistry) {
        String finalId = ImageUtils.getOrCreateOverlayImage(baseImageId, overlayImageIds, imageRegistry);
        return imageRegistry.get(finalId);
    }

    public static ImageDescriptor getOverlayImageDescriptor(String baseImageId, List<String> overlayImageIds, ImageRegistry imageRegistry) {
        String finalId = ImageUtils.getOrCreateOverlayImage(baseImageId, overlayImageIds, imageRegistry);
        return imageRegistry.getDescriptor(finalId);
    }

    private static String getOrCreateOverlayImage(String baseImageId, List<String> overlayImageIds, final ImageRegistry imageRegistry) {
        Image baseImage = imageRegistry.get(baseImageId);
        String finalId = Joiner.on((char)',').join((Iterable)ImmutableList.builder().add((Object)baseImageId).addAll(overlayImageIds).build());
        ImageDescriptor finalDescriptor = imageRegistry.getDescriptor(finalId);
        if (finalDescriptor == null) {
            ImageDescriptor[] overlayDescriptors = (ImageDescriptor[])FluentIterable.from(overlayImageIds).transform((Function)new Function<String, ImageDescriptor>(){

                public ImageDescriptor apply(String imageId) {
                    return imageRegistry.getDescriptor(imageId);
                }
            }).toArray(ImageDescriptor.class);
            imageRegistry.put(finalId, (ImageDescriptor)new DecorationOverlayIcon(baseImage, overlayDescriptors));
        }
        return finalId;
    }
}

