/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.gradle;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class GradleUtils {
    private GradleUtils() {
    }

    public static List<TestOperationDescriptor> filterChildren(List<TestOperationDescriptor> testDescriptors) {
        ImmutableList.Builder withoutChildren = ImmutableList.builder();
        for (TestOperationDescriptor testDescriptor : testDescriptors) {
            if (GradleUtils.isParentSelected(testDescriptor, testDescriptors)) continue;
            withoutChildren.add((Object)testDescriptor);
        }
        return withoutChildren.build();
    }

    private static boolean isParentSelected(TestOperationDescriptor candidate, List<TestOperationDescriptor> selectedTestDescriptors) {
        OperationDescriptor parent = candidate.getParent();
        if (parent instanceof TestOperationDescriptor) {
            return selectedTestDescriptors.contains(parent) || GradleUtils.isParentSelected((TestOperationDescriptor)parent, selectedTestDescriptors);
        }
        return false;
    }
}

