/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.CountdownTimer;

class CountdownClock
extends Clock
implements CountdownTimer {
    private final long timeoutMillis;

    CountdownClock(long timeout, TimeUnit unit) {
        this.timeoutMillis = unit.toMillis(timeout);
    }

    public boolean hasExpired() {
        if (this.timeoutMillis <= 0L) {
            return false;
        }
        return this.getElapsedMillis() > this.timeoutMillis;
    }

    public Date getExpiryTime() {
        return new Date(this.getStartTime() + this.timeoutMillis);
    }
}

