/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class GradleRunConfigurationAttributes {
    private static final String TASKS = "tasks";
    private static final String WORKING_DIR = "working_dir";
    private static final String GRADLE_DISTRIBUTION = "gradle_distribution";
    private static final String GRADLE_USER_HOME = "gradle_user_home";
    private static final String JAVA_HOME = "java_home";
    private static final String JVM_ARGUMENTS = "jvm_arguments";
    private static final String ARGUMENTS = "arguments";
    private static final String SHOW_EXECUTION_VIEW = "show_execution_view";
    private static final String SHOW_CONSOLE_VIEW = "show_console_view";
    private static final String OVERRIDE_BUILD_SETTINGS = "override_workspace_settings";
    private static final String OFFLINE_MODE = "offline_mode";
    private static final String BUILD_SCANS_ENABLED = "build_scans_enabled";
    private final ImmutableList<String> tasks;
    private final String workingDirExpression;
    private final String gradleDistribution;
    private final String gradleUserHomeExpression;
    private final String javaHomeExpression;
    private final ImmutableList<String> jvmArgumentExpressions;
    private final ImmutableList<String> argumentExpressions;
    private final boolean showExecutionView;
    private final boolean showConsoleView;
    private final boolean overrideBuildSettings;
    private final boolean isOffline;
    private final boolean isBuildScansEnabled;

    public GradleRunConfigurationAttributes(List<String> tasks, String workingDirExpression, String gradleDistribution, String gradleUserHomeExpression, String javaHomeExpression, List<String> jvmArgumentExpressions, List<String> argumentExpressions, boolean showExecutionView, boolean showConsoleView, boolean overrideWorkspaceSettings, boolean isOffline, boolean isBuildScansEnabled) {
        this.tasks = ImmutableList.copyOf(tasks);
        this.workingDirExpression = (String)Preconditions.checkNotNull((Object)workingDirExpression);
        this.gradleDistribution = gradleDistribution;
        this.gradleUserHomeExpression = gradleUserHomeExpression;
        this.javaHomeExpression = javaHomeExpression;
        this.jvmArgumentExpressions = ImmutableList.copyOf(jvmArgumentExpressions);
        this.argumentExpressions = ImmutableList.copyOf(argumentExpressions);
        this.showExecutionView = showExecutionView;
        this.showConsoleView = showConsoleView;
        this.overrideBuildSettings = overrideWorkspaceSettings;
        this.isOffline = isOffline;
        this.isBuildScansEnabled = isBuildScansEnabled;
    }

    public ImmutableList<String> getTasks() {
        return this.tasks;
    }

    public String getWorkingDirExpression() {
        return this.workingDirExpression;
    }

    public File getWorkingDir() {
        try {
            String location = ExpressionUtils.decode(this.workingDirExpression);
            return new File(location).getAbsoluteFile();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve working directory expression %s.", this.workingDirExpression));
        }
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution != null ? GradleDistributionSerializer.INSTANCE.deserializeFromString(this.gradleDistribution) : GradleDistribution.fromBuild();
    }

    public String getGradleUserHomeHomeExpression() {
        return this.gradleUserHomeExpression;
    }

    public File getGradleUserHome() {
        try {
            String location = ExpressionUtils.decode(this.gradleUserHomeExpression);
            return (File)FileUtils.getAbsoluteFile(location).orNull();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve Gradle user home directory expression %s.", this.javaHomeExpression));
        }
    }

    public String getJavaHomeExpression() {
        return this.javaHomeExpression;
    }

    public File getJavaHome() {
        try {
            String location = ExpressionUtils.decode(this.javaHomeExpression);
            return (File)FileUtils.getAbsoluteFile(location).orNull();
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot resolve Java home directory expression %s.", this.javaHomeExpression));
        }
    }

    public ImmutableList<String> getJvmArgumentExpressions() {
        return this.jvmArgumentExpressions;
    }

    public ImmutableList<String> getJvmArguments() {
        return FluentIterable.from(this.jvmArgumentExpressions).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                try {
                    return ExpressionUtils.decode(input);
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException(String.format("Cannot resolve JVM argument expression %s.", input));
                }
            }
        }).toList();
    }

    public ImmutableList<String> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    public ImmutableList<String> getArguments() {
        return FluentIterable.from(this.argumentExpressions).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                try {
                    return ExpressionUtils.decode(input);
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException(String.format("Cannot resolve argument expression %s.", input));
                }
            }
        }).toList();
    }

    public boolean isShowExecutionView() {
        return this.showExecutionView;
    }

    public boolean isShowConsoleView() {
        return this.showConsoleView;
    }

    public boolean isOverrideBuildSettings() {
        return this.overrideBuildSettings;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public boolean isBuildScansEnabled() {
        return this.isBuildScansEnabled;
    }

    public boolean hasSameUniqueAttributes(ILaunchConfiguration launchConfiguration) {
        try {
            return this.tasks.equals((Object)launchConfiguration.getAttribute(TASKS, (List)ImmutableList.of())) && this.workingDirExpression.equals(launchConfiguration.getAttribute(WORKING_DIR, ""));
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read Gradle launch configuration %s.", launchConfiguration), e);
        }
    }

    public void apply(ILaunchConfigurationWorkingCopy launchConfiguration) {
        GradleRunConfigurationAttributes.applyTasks(this.tasks, launchConfiguration);
        GradleRunConfigurationAttributes.applyWorkingDirExpression(this.workingDirExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyGradleDistribution(this.gradleDistribution, launchConfiguration);
        GradleRunConfigurationAttributes.applyGradleUserHomeExpression(this.gradleUserHomeExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyJavaHomeExpression(this.javaHomeExpression, launchConfiguration);
        GradleRunConfigurationAttributes.applyJvmArgumentExpressions(this.jvmArgumentExpressions, launchConfiguration);
        GradleRunConfigurationAttributes.applyArgumentExpressions(this.argumentExpressions, launchConfiguration);
        GradleRunConfigurationAttributes.applyShowExecutionView(this.showExecutionView, launchConfiguration);
        GradleRunConfigurationAttributes.applyShowConsoleView(this.showConsoleView, launchConfiguration);
        GradleRunConfigurationAttributes.applyOverrideBuildSettings(this.overrideBuildSettings, launchConfiguration);
        GradleRunConfigurationAttributes.applyOfflineMode(this.isOffline, launchConfiguration);
        GradleRunConfigurationAttributes.applyBuildScansEnabled(this.isBuildScansEnabled, launchConfiguration);
    }

    public static void applyTasks(List<String> tasks, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(TASKS, tasks);
    }

    public static void applyWorkingDirExpression(String workingDirExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(WORKING_DIR, (String)Preconditions.checkNotNull((Object)workingDirExpression));
    }

    public static void applyGradleDistribution(String gradleDistribution, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(GRADLE_DISTRIBUTION, gradleDistribution);
    }

    public static void applyGradleDistribution(GradleDistribution gradleDistribution, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(GRADLE_DISTRIBUTION, (String)Preconditions.checkNotNull((Object)GradleDistributionSerializer.INSTANCE.serializeToString(gradleDistribution)));
    }

    public static void applyGradleUserHomeExpression(String gradleUserHomeExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(GRADLE_USER_HOME, gradleUserHomeExpression);
    }

    public static void applyJavaHomeExpression(String javaHomeExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(JAVA_HOME, javaHomeExpression);
    }

    public static void applyJvmArgumentExpressions(List<String> jvmArgumentsExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(JVM_ARGUMENTS, jvmArgumentsExpression);
    }

    public static void applyArgumentExpressions(List<String> argumentsExpression, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(ARGUMENTS, argumentsExpression);
    }

    public static void applyShowExecutionView(boolean showExecutionView, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(SHOW_EXECUTION_VIEW, showExecutionView);
    }

    public static void applyShowConsoleView(boolean showConsoleView, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(SHOW_CONSOLE_VIEW, showConsoleView);
    }

    public static void applyOverrideBuildSettings(boolean overrideWorkspaceSettings, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(OVERRIDE_BUILD_SETTINGS, overrideWorkspaceSettings);
    }

    public static void applyOfflineMode(boolean offlineMode, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(OFFLINE_MODE, offlineMode);
    }

    public static void applyBuildScansEnabled(boolean buildScansEnabled, ILaunchConfigurationWorkingCopy launchConfiguration) {
        launchConfiguration.setAttribute(BUILD_SCANS_ENABLED, buildScansEnabled);
    }

    public static GradleRunConfigurationAttributes from(ILaunchConfiguration launchConfiguration) {
        Preconditions.checkNotNull((Object)launchConfiguration);
        List<String> tasks = GradleRunConfigurationAttributes.getListAttribute(TASKS, launchConfiguration);
        String workingDirExpression = GradleRunConfigurationAttributes.getStringAttribute(WORKING_DIR, "", launchConfiguration);
        String gradleDistribution = GradleRunConfigurationAttributes.getStringAttribute(GRADLE_DISTRIBUTION, GradleDistributionSerializer.INSTANCE.serializeToString(GradleDistribution.fromBuild()), launchConfiguration);
        String gradleUserHomeExpression = GradleRunConfigurationAttributes.getStringAttribute(GRADLE_USER_HOME, null, launchConfiguration);
        String javaHomeExpression = GradleRunConfigurationAttributes.getStringAttribute(JAVA_HOME, null, launchConfiguration);
        List<String> jvmArgumentExpressions = GradleRunConfigurationAttributes.getListAttribute(JVM_ARGUMENTS, launchConfiguration);
        List<String> argumentExpressions = GradleRunConfigurationAttributes.getListAttribute(ARGUMENTS, launchConfiguration);
        boolean showExecutionView = GradleRunConfigurationAttributes.getBooleanAttribute(SHOW_EXECUTION_VIEW, true, launchConfiguration);
        boolean showConsoleView = GradleRunConfigurationAttributes.getBooleanAttribute(SHOW_CONSOLE_VIEW, true, launchConfiguration);
        boolean overrideWorkspaceSettings = GradleRunConfigurationAttributes.getBooleanAttribute(OVERRIDE_BUILD_SETTINGS, false, launchConfiguration);
        boolean isOffline = GradleRunConfigurationAttributes.getBooleanAttribute(OFFLINE_MODE, false, launchConfiguration);
        boolean isBuildScansEnabled = GradleRunConfigurationAttributes.getBooleanAttribute(BUILD_SCANS_ENABLED, false, launchConfiguration);
        return new GradleRunConfigurationAttributes(tasks, workingDirExpression, gradleDistribution, gradleUserHomeExpression, javaHomeExpression, jvmArgumentExpressions, argumentExpressions, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled);
    }

    private static List<String> getListAttribute(String name, ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(name, (List)ImmutableList.of());
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", name));
        }
    }

    private static String getStringAttribute(String name, String defaultValue, ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", name));
        }
    }

    private static boolean getBooleanAttribute(String name, boolean defaultValue, ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot read launch configuration attribute '%s'.", name));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GradleRunConfigurationAttributes) {
            GradleRunConfigurationAttributes other = (GradleRunConfigurationAttributes)obj;
            return Objects.equal((Object)this.workingDirExpression, (Object)other.workingDirExpression) && Objects.equal((Object)this.gradleDistribution, (Object)other.gradleDistribution) && Objects.equal((Object)this.gradleUserHomeExpression, (Object)other.gradleUserHomeExpression) && Objects.equal((Object)this.javaHomeExpression, (Object)other.javaHomeExpression) && Objects.equal(this.jvmArgumentExpressions, other.jvmArgumentExpressions) && Objects.equal(this.argumentExpressions, other.argumentExpressions) && Objects.equal((Object)this.showExecutionView, (Object)other.showExecutionView) && Objects.equal((Object)this.showConsoleView, (Object)other.showConsoleView) && Objects.equal((Object)this.overrideBuildSettings, (Object)other.overrideBuildSettings) && Objects.equal((Object)this.isOffline, (Object)other.isOffline) && Objects.equal((Object)this.isBuildScansEnabled, (Object)other.isBuildScansEnabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.workingDirExpression, this.gradleDistribution, this.gradleUserHomeExpression, this.javaHomeExpression, this.jvmArgumentExpressions, this.argumentExpressions, this.showExecutionView, this.showConsoleView, this.overrideBuildSettings, this.isOffline, this.isBuildScansEnabled});
    }
}

