/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class CompositeModelQuery<T>
implements BuildAction<Collection<T>> {
    private static final long serialVersionUID = 1L;
    private final Class<T> modelType;

    public CompositeModelQuery(Class<T> modelType) {
        this.modelType = modelType;
    }

    public Collection<T> execute(BuildController controller) {
        ArrayList models = new ArrayList();
        this.collectRootModels(controller, controller.getBuildModel(), models);
        return models;
    }

    private void collectRootModels(BuildController controller, GradleBuild build, Collection<T> models) {
        models.add(controller.getModel((Model)build.getRootProject(), this.modelType));
        for (GradleBuild includedBuild : build.getIncludedBuilds()) {
            this.collectRootModels(controller, includedBuild, models);
        }
    }

    public int hashCode() {
        return Objects.hash(this.modelType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeModelQuery other = (CompositeModelQuery)obj;
        return Objects.equals(this.modelType, other.modelType);
    }
}

