/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.sirius.analysis.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.Messages;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

abstract class ShowHideTask
extends AbstractCommandTask
implements ICreationTask {
    private Collection<EObject> selectedObjects = new ArrayList<EObject>();
    private Collection<EObject> deletedObjects = new ArrayList<EObject>();
    private EObject container;
    private MappingBasedToolDescription tool;

    public ShowHideTask(EObject container, MappingBasedToolDescription tool) {
        this.container = container;
        this.tool = tool;
    }

    public boolean canExecute() {
        return ((DSemanticDecorator)this.container).getTarget() != null;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public void execute() {
        HashMap<EObject, DDiagramElement> shown = new HashMap<EObject, DDiagramElement>();
        ArrayList semanticCandidates = new ArrayList();
        for (DDiagramElement dDiagramElement : this.getCandidateChildren(this.container)) {
            if (!this.getMappings(this.tool).contains(dDiagramElement.getMapping())) continue;
            shown.put(dDiagramElement.getTarget(), dDiagramElement);
        }
        EObject eObject = ((DSemanticDecorator)this.container).getTarget();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        for (AbstractNodeMapping abstractNodeMapping : this.getMappings(this.tool)) {
            String expression = abstractNodeMapping.getSemanticCandidatesExpression();
            if (expression != null && !expression.trim().isEmpty()) {
                try {
                    semanticCandidates.addAll((List)interpreter.evaluate(eObject, expression));
                    continue;
                }
                catch (EvaluationException e) {
                    return;
                }
            }
            Session session = SessionManager.INSTANCE.getSession(eObject);
            ModelAccessor accessor = session.getModelAccessor();
            for (Resource resource : session.getSemanticResources()) {
                for (EObject root : resource.getContents()) {
                    semanticCandidates.addAll(accessor.eAllContents(root, abstractNodeMapping.getDomainClass()));
                }
            }
        }
        semanticCandidates.removeAll(shown.keySet());
        boolean expandLeftViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandLeftViewerContent();
        boolean expandRightViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandRightViewerContent();
        int leftViewerExpandLevel = expandLeftViewer ? -1 : 0;
        int rightViewerExpandLevel = expandRightViewer ? -1 : 0;
        DSemanticDecorator decorator = (DSemanticDecorator)this.container;
        DiagramDescription diagramDescription = CapellaServices.getService().getDiagramContainer((EObject)decorator).getDescription();
        String elementTypeToInsert = MessageTranslator.INSTANCE.getMessage((EObject)diagramDescription, this.tool.getLabel());
        NamedElement semanticTarget = (NamedElement)decorator.getTarget();
        String wizardMessage = "Select " + elementTypeToInsert + " to show in " + semanticTarget.getName();
        TransferTreeListDialog transferTreeListDialog = new TransferTreeListDialog(this.getShell(), Messages.SelectElementFromListWizard_Title, wizardMessage, new DataLabelProvider(), new DataLabelProvider(), leftViewerExpandLevel, rightViewerExpandLevel);
        transferTreeListDialog.setRightInput(new ArrayList(shown.keySet()), (Object)eObject);
        transferTreeListDialog.setLeftInput(semanticCandidates, (Object)eObject);
        if (transferTreeListDialog.open() == 0) {
            Object[] objectArray = transferTreeListDialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (shown.remove(e) == null) {
                    this.selectedObjects.add((EObject)e);
                }
                ++n2;
            }
            for (DDiagramElement d : shown.values()) {
                EcoreUtil.remove((EObject)d);
                this.deletedObjects.add((EObject)d);
            }
        }
    }

    protected abstract Collection<? extends DDiagramElement> getCandidateChildren(EObject var1);

    protected abstract Collection<? extends AbstractNodeMapping> getMappings(MappingBasedToolDescription var1);

    public Collection<EObject> getAffectedElements() {
        return Collections.emptyList();
    }

    public Collection<EObject> getCreatedReferences() {
        return Collections.emptyList();
    }

    public String getLabel() {
        return "select elements task";
    }

    public Collection<EObject> getCreatedElements() {
        return this.selectedObjects;
    }

    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return Collections.emptyList();
    }
}

