/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.activityExplorer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.explorer.activity.ui.hyperlinkadapter.AbstractCapellaNewDiagramHyperlinkAdapter;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.cybersecurity.test.activityExplorer.ActivityExplorerTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public abstract class CyberDiagramActivityExplorerTestCase
extends ActivityExplorerTestCase {
    protected abstract String getDefaultName();

    @Override
    protected abstract ModelElement getTestModelElement();

    private int getNrOfDiagrams() {
        Collection myList = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Arrays.asList(this.structure));
        List filteredDiags = myList.stream().filter(x -> x.getName().equals(this.getDefaultName())).collect(Collectors.toList());
        return filteredDiags.size();
    }

    protected boolean getResultOfCreateDiagram() {
        if (this.link instanceof AbstractCapellaNewDiagramHyperlinkAdapter) {
            return ((AbstractCapellaNewDiagramHyperlinkAdapter)this.link).createDiagram(this.structure, this.session);
        }
        return false;
    }

    @Override
    protected void doTest() {
        int nrOfExistingDiagrams = this.getNrOfDiagrams();
        boolean result = this.getResultOfCreateDiagram();
        CyberDiagramActivityExplorerTestCase.assertTrue((boolean)result);
        CyberDiagramActivityExplorerTestCase.assertEquals((int)this.getNrOfDiagrams(), (int)(nrOfExistingDiagrams + 1));
        GuiActions.closeSession((Session)this.session, (boolean)false);
    }
}

