/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.config;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.cybersecurity.test.config.CybersecurityConfigProject;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;

public class CybersecurityDefaultConfigTest
extends CybersecurityConfigProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        Project project = SessionHelper.getCapellaProject((Session)session);
        CybersecurityDefaultConfigTest.assertNull((Object)CybersecurityQueries.getCybersecurityConfiguration((Project)project));
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        CybersecurityConfiguration cyberConfig = CybersecurityQueries.getCybersecurityConfiguration((Project)project);
        CybersecurityDefaultConfigTest.assertNotNull((Object)cyberConfig);
        this.checkSecurityNeedsType(CybersecurityQueries.getConfidentialityPropertyType((Project)project), "Security.Confidentiality");
        this.checkSecurityNeedsType(CybersecurityQueries.getIntegrityPropertyType((Project)project), "Security.Integrity");
        this.checkSecurityNeedsType(CybersecurityQueries.getAvailabilityPropertyType((Project)project), "Security.Availability");
        this.checkSecurityNeedsType(CybersecurityQueries.getTraceabilityPropertyType((Project)project), "Security.Traceability");
        this.checkThreatKindsType(CybersecurityQueries.getThreatKindPropertyType((Project)project), "Threat.Kind");
        this.updateType(CybersecurityQueries.getConfidentialityPropertyType((Project)project), 5, project);
        this.updateType(CybersecurityQueries.getAvailabilityPropertyType((Project)project), 5, project);
        this.updateType(CybersecurityQueries.getThreatKindPropertyType((Project)project), 7, project);
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        tedHelper.executeCommand(() -> {
            try {
                manager.desactivate("org.polarsys.capella.cybersecurity");
                manager.activate("org.polarsys.capella.cybersecurity");
                CybersecurityDefaultConfigTest.assertNotNull((Object)CybersecurityQueries.getCybersecurityConfiguration((Project)project));
            }
            catch (ViewpointActivationException e) {
                e.printStackTrace();
            }
            catch (EvaluationException e) {
                e.printStackTrace();
            }
        });
    }

    protected void checkSecurityNeedsType(EnumerationPropertyType type, String typeName) {
        CybersecurityDefaultConfigTest.assertNotNull((Object)type);
        CybersecurityDefaultConfigTest.assertEquals((String)type.getName(), (String)typeName);
        CybersecurityDefaultConfigTest.assertTrue((type.getOwnedLiterals().size() == 4 ? 1 : 0) != 0);
        int index = 0;
        for (EnumerationPropertyLiteral literal : type.getOwnedLiterals()) {
            CybersecurityDefaultConfigTest.assertTrue((Integer.valueOf(literal.getName()) == index++ ? 1 : 0) != 0);
        }
    }

    protected void checkThreatKindsType(EnumerationPropertyType type, String typeName) {
        CybersecurityDefaultConfigTest.assertNotNull((Object)type);
        CybersecurityDefaultConfigTest.assertEquals((String)type.getName(), (String)typeName);
        CybersecurityDefaultConfigTest.assertTrue((type.getOwnedLiterals().size() == 6 ? 1 : 0) != 0);
        int index = 0;
        for (EnumerationPropertyLiteral literal : type.getOwnedLiterals()) {
            CybersecurityDefaultConfigTest.assertEquals((String)literal.getName(), (String)this.threatKinds[index++]);
        }
    }

    protected void updateType(EnumerationPropertyType type, int no, Project project) {
        this.addLiteralType(type, project, "A1");
        this.addLiteralType(type, project, "A2");
        this.removeLiteralType(type, project, 0);
        CybersecurityDefaultConfigTest.assertTrue((type.getOwnedLiterals().size() == no ? 1 : 0) != 0);
    }
}

