/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import org.eclipse.emf.transaction.RollbackException;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.test.common.Allocators;
import org.polarsys.capella.cybersecurity.test.diagram.CyberOABDiagram;
import org.polarsys.capella.cybersecurity.test.diagram.CyberXABDiagramTest;

public class CyberOABDiagramTest
extends CyberXABDiagramTest {
    @Override
    protected String getSystemId() {
        return "bba24bed-20cd-4d6e-b981-12de37a4926d";
    }

    @Override
    protected String getDataPkgId() {
        return "fb3e1e54-1c28-4e30-b7a3-bf18e7be1c62";
    }

    @Override
    protected String getInterfacePkgId() {
        return "ff8580b4-8866-4660-b09c-2fb74f4e972b";
    }

    @Override
    protected BlockArchitectureExt.Type getType() {
        return BlockArchitectureExt.Type.OA;
    }

    @Override
    protected String getRepresentationName() {
        return "Operational Entity Blank";
    }

    protected CyberOABDiagram createDiagram() {
        return CyberOABDiagram.createDiagram(this.context, this.getSystemId());
    }

    @Override
    protected void createDiagramElements() {
        CyberOABDiagram diagram = (CyberOABDiagram)this.diagram;
        this.diagramElements.put("component1", diagram.createEntity("component1", diagram.getDiagramId()));
        this.diagramElements.put("component2", diagram.createEntity("component2", diagram.getDiagramId()));
        this.diagramElements.put("component3", diagram.createEntity("component3", diagram.getDiagramId()));
        this.diagramElements.put("component4", diagram.createEntity("component4", (String)this.diagramElements.get("component3")));
        this.diagramElements.put("component5", diagram.createEntity("component5", (String)this.diagramElements.get("component4")));
        this.diagramElements.put("component6", diagram.createEntity("component6", (String)this.diagramElements.get("component5")));
        this.diagramElements.put("actor4", diagram.createEntity("actor4", (String)this.diagramElements.get("component3")));
        this.diagramElements.put("actor5", diagram.createEntity("actor5", (String)this.diagramElements.get("actor4")));
        this.diagramElements.put("component7", diagram.createEntity("component7", (String)this.diagramElements.get("actor5")));
        this.diagramElements.put("component8", diagram.createEntity("component8", (String)this.diagramElements.get("component7")));
    }

    @Override
    protected void insertPrimaryAsset(PrimaryAsset pa) {
        ((CyberOABDiagram)this.diagram).insertPrimaryAsset(pa);
    }

    @Override
    protected void removePrimaryAsset(PrimaryAsset pa) {
        ((CyberOABDiagram)this.diagram).removePrimaryAsset(pa);
    }

    @Override
    protected void insertThreat(Threat threat) {
        ((CyberOABDiagram)this.diagram).insertThreat(threat);
    }

    @Override
    protected void removeThreat(Threat threat) {
        ((CyberOABDiagram)this.diagram).removeThreat(threat);
    }

    @Override
    protected void step3() throws RollbackException, InterruptedException {
        CyberOABDiagram diagram = (CyberOABDiagram)this.diagram;
        this.executeCommand(() -> {
            String entity1Id = diagram.createEntity("e1", diagram.getDiagramId());
            String entity2Id = diagram.createEntity("e2", diagram.getDiagramId());
            String untrustedActorId = diagram.createActor("untrustedActor", entity1Id);
            String trustedActorId = diagram.createActor("trustedActor", entity2Id);
            Entity untrustedActor = (Entity)diagram.getSemanticObjectMap().get("untrustedActor");
            TrustBoundaryStorage storage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
            storage.setTrusted(false);
            untrustedActor.getOwnedExtensions().add((Object)storage);
            String func1 = diagram.createFunction("func1", untrustedActorId);
            String func2 = diagram.createFunction("func2", trustedActorId);
            diagram.createFunctionalExchange(func1, func2, "functional exchange");
            FunctionalExchange functionalExchange = (FunctionalExchange)diagram.getSemanticObjectMap().get("functional exchange");
            diagram.createComponentExchange(entity1Id, entity2Id, "component exchange");
            ComponentExchange componentExchange = (ComponentExchange)diagram.getSemanticObjectMap().get("component exchange");
            Allocators.allocate(functionalExchange).on(componentExchange);
            CyberOABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((FunctionalExchange)functionalExchange));
            CyberOABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((ComponentExchange)componentExchange));
        });
    }

    @Override
    protected void step6() throws RollbackException, InterruptedException {
        super.step6();
        this.checkComponentLooksNormal("component4");
    }

    @Override
    protected void step7() throws RollbackException, InterruptedException {
        super.step7();
        this.checkComponentLooksNormal("component4");
    }

    @Override
    protected void step8() {
        super.step8();
        this.checkComponentLooksNormal("component4");
    }

    @Override
    protected void step9() throws RollbackException, InterruptedException {
        super.step9();
        this.checkComponentLooksNormal("actor5");
    }

    @Override
    protected void step10CreateAndCheckPhysicalLink(ComponentExchange componentExchange) {
    }
}

