/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.Allocators;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.cybersecurity.test.diagram.CyberDiagramLayers;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public abstract class CyberXABDiagramTest
extends EmptyProject {
    protected TransactionalEditingDomainHelper tedHelper;
    protected FunctionalPrimaryAsset fpa;
    protected InformationPrimaryAsset ipa;
    protected EnterprisePrimaryAsset epa;
    protected Threat threat;
    protected HashMap<String, String> diagramElements;
    protected SessionContext context;
    protected Session session;
    protected XABDiagram diagram;
    protected CybersecurityServices services;
    protected static final RGBValues BLACK_COLOR = RGBValues.create((int)0, (int)0, (int)0);
    protected static final Integer HIGHLIGHTED_BORDER_SIZE = new Integer(5);
    protected static final Integer NORMAL_BORDER_SIZE = new Integer(1);

    protected abstract String getSystemId();

    protected abstract String getDataPkgId();

    protected abstract String getInterfacePkgId();

    protected abstract BlockArchitectureExt.Type getType();

    protected abstract String getRepresentationName();

    protected abstract XABDiagram createDiagram();

    protected abstract void insertPrimaryAsset(PrimaryAsset var1);

    protected abstract void removePrimaryAsset(PrimaryAsset var1);

    protected abstract void insertThreat(Threat var1);

    protected abstract void removeThreat(Threat var1);

    protected abstract void createDiagramElements();

    protected RGBValues getFpaColor() {
        return ((Ellipse)this.diagram.getView((EObject)this.fpa).getStyle()).getColor();
    }

    protected RGBValues getIpaColor() {
        return ((Ellipse)this.diagram.getView((EObject)this.ipa).getStyle()).getColor();
    }

    protected RGBValues getEpaColor() {
        return ((Ellipse)this.diagram.getView((EObject)this.epa).getStyle()).getColor();
    }

    protected RGBValues getThreatColor() {
        return ((Ellipse)this.diagram.getView((EObject)this.threat).getStyle()).getColor();
    }

    protected void checkComponentLooksNormal(String component) {
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get(component);
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
    }

    protected void undoAllChanges() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)this.session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        this.tedHelper = new TransactionalEditingDomainHelper(this.session.getTransactionalEditingDomain());
        this.diagramElements = new HashMap();
        this.diagram = this.createDiagram();
        this.services = new CybersecurityServices();
        this.createDiagramElements();
    }

    protected void step1() throws RollbackException, InterruptedException {
        String component1 = this.diagramElements.get("component1");
        String component2 = this.diagramElements.get("component2");
        String function1 = this.diagram.createFunction("function1", component1);
        String function2 = this.diagram.createFunction("function2", component2);
        this.diagramElements.put("function1", function1);
        this.diagramElements.put("function2", function2);
        this.diagram.createFunctionalExchange(function1, function2, "fe");
        this.executeCommand(() -> {
            this.fpa = this.services.createFunctionalPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            this.ipa = this.services.createInformationPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)this.diagram.getSemanticObjectMap().get(function1));
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)this.diagram.getSemanticObjectMap().get(function2));
            this.fpa.getOwnedMembers().add((Object)m1);
            this.fpa.getOwnedMembers().add((Object)m2);
            PrimaryAssetMember m3 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m3.setMember((ModelElement)this.fpa);
            this.epa.getOwnedMembers().add((Object)m3);
        });
        this.insertPrimaryAsset((PrimaryAsset)this.fpa);
        DNode f1Node = (DNode)this.diagram.getViewObjectMap().get(function1);
        DNode f2Node = (DNode)this.diagram.getViewObjectMap().get(function2);
        CyberXABDiagramTest.assertEquals((Object)this.getFpaColor(), (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)this.getFpaColor(), (Object)((Square)f2Node.getStyle()).getBorderColor());
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)f2Node.getStyle()).getBorderColor());
        this.removePrimaryAsset((PrimaryAsset)this.fpa);
        CyberXABDiagramTest.assertEquals((Object)this.getEpaColor(), (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)this.getEpaColor(), (Object)((Square)f2Node.getStyle()).getBorderColor());
    }

    protected void step2() throws RollbackException, InterruptedException {
        DNode f1Node = (DNode)this.diagram.getViewObjectMap().get(this.diagramElements.get("function1"));
        DNode f2Node = (DNode)this.diagram.getViewObjectMap().get(this.diagramElements.get("function2"));
        this.executeCommand(() -> {
            ExchangeItem ei1 = InformationFactory.eINSTANCE.createExchangeItem();
            ExchangeItem ei2 = InformationFactory.eINSTANCE.createExchangeItem();
            DataPkg p1 = (DataPkg)this.context.getSemanticElement(this.getDataPkgId());
            p1.getOwnedExchangeItems().add((Object)ei1);
            p1.getOwnedExchangeItems().add((Object)ei2);
            FunctionStorage f1Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f1Storage.getExchangedItems().add((Object)ei1);
            ((AbstractFunction)this.diagram.getSemanticObjectMap().get("function1")).getOwnedExtensions().add((Object)f1Storage);
            FunctionStorage f2Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f2Storage.getExchangedItems().add((Object)ei1);
            ((AbstractFunction)this.diagram.getSemanticObjectMap().get("function2")).getOwnedExtensions().add((Object)f2Storage);
            ((FunctionalExchange)this.diagram.getSemanticObjectMap().get("fe")).getExchangedItems().add((Object)ei2);
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)ei1);
            m2.setMember((ModelElement)ei2);
            this.ipa.getOwnedMembers().add((Object)m1);
            this.ipa.getOwnedMembers().add((Object)m2);
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m3 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m3.setMember((ModelElement)this.ipa);
            this.epa.getOwnedMembers().add((Object)m3);
        });
        this.insertPrimaryAsset((PrimaryAsset)this.ipa);
        DEdge feEdge = this.diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == this.diagram.getSemanticObjectMap().get("fe")).findFirst().get();
        CyberXABDiagramTest.assertEquals((Object)this.getIpaColor(), (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)this.getIpaColor(), (Object)((Square)f2Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)this.getIpaColor(), (Object)((EdgeStyle)feEdge.getStyle()).getStrokeColor());
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)f2Node.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((EdgeStyle)feEdge.getStyle()).getStrokeColor());
    }

    protected void step3() throws RollbackException, InterruptedException {
        this.executeCommand(() -> {
            String actor1Id = this.diagram.createActor("actor1", this.diagram.getDiagramId());
            String actor2Id = this.diagram.createActor("actor2", this.diagram.getDiagramId());
            String untrustedActorId = this.diagram.createActor("untrustedActor", actor1Id);
            String trustedActorId = this.diagram.createActor("trustedActor", actor2Id);
            AbstractType untrustedActor = ((Part)this.diagram.getSemanticObjectMap().get("untrustedActor")).getAbstractType();
            TrustBoundaryStorage storage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
            storage.setTrusted(false);
            untrustedActor.getOwnedExtensions().add((Object)storage);
            String function3 = this.diagram.createFunction("function3", untrustedActorId);
            String function4 = this.diagram.createFunction("function4", trustedActorId);
            this.diagram.createFunctionalExchange(function3, function4, "functional exchange");
            FunctionalExchange functionalExchange = (FunctionalExchange)this.diagram.getSemanticObjectMap().get("functional exchange");
            this.diagram.createPhysicalLink(untrustedActorId, trustedActorId, "physical link");
            PhysicalLink physicalLink = (PhysicalLink)this.diagram.getSemanticObjectMap().get("physical link");
            this.diagram.createComponentExchange(actor1Id, actor2Id, "component exchange");
            ComponentExchange componentExchange = (ComponentExchange)this.diagram.getSemanticObjectMap().get("component exchange");
            Allocators.allocate(functionalExchange).on(componentExchange);
            CyberXABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((FunctionalExchange)functionalExchange));
            CyberXABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((PhysicalLink)physicalLink));
            CyberXABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((ComponentExchange)componentExchange));
        });
    }

    protected void step4() throws RollbackException, InterruptedException {
        this.executeCommand(() -> {
            String actorId = this.diagram.createActor("actor", this.diagram.getDiagramId());
            String function5 = this.diagram.createFunction("function5", actorId);
            String function6 = this.diagram.createFunction("function6", actorId);
            String function7 = this.diagram.createFunction("function7", actorId);
            this.diagram.createFunctionalExchange(function5, function6, "functionalExchange");
            this.diagram.createFunctionalExchange(function6, function7, "functionalExchange2");
            this.diagram.createFunctionalChain("path", new String[]{"functionalExchange"});
            FunctionalChain funcChain = (FunctionalChain)this.diagram.getSemanticObjectMap().get("path");
            this.diagram.createFunctionalChain("path2", new String[]{"functionalExchange2"});
            FunctionalChain funcChain2 = (FunctionalChain)this.diagram.getSemanticObjectMap().get("path2");
            this.fpa = this.services.createFunctionalPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)funcChain2);
            m1.setMember((ModelElement)funcChain);
            this.fpa.getOwnedMembers().add((Object)m1);
            this.fpa.getOwnedMembers().add((Object)m2);
            this.insertPrimaryAsset((PrimaryAsset)this.fpa);
            this.diagram.removeFunctionalChain("path");
            this.diagram.removeFunctionalChain("path2");
            DDiagramElement functionView = this.diagram.getView((EObject)this.diagram.getSemanticObjectMap().get("function5"));
            Style functionStyle = functionView.getStyle();
            DDiagramElement primaryAssetView = this.diagram.getView((EObject)this.diagram.getSemanticObjectMap().get(this.fpa.getId()));
            Style primaryAssetStyle = primaryAssetView.getStyle();
            CyberXABDiagramTest.assertEquals((Object)((Square)functionStyle).getBorderColor(), (Object)((Ellipse)primaryAssetStyle).getColor());
            DDiagramElement middleFunctionView = this.diagram.getView((EObject)this.diagram.getSemanticObjectMap().get("function6"));
            Style middleFunctionStyle = middleFunctionView.getStyle();
            CyberXABDiagramTest.assertEquals((Object)((Square)middleFunctionStyle).getBorderColor(), (Object)((Ellipse)primaryAssetStyle).getColor());
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m3 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m3.setMember((ModelElement)this.fpa);
            this.epa.getOwnedMembers().add((Object)m3);
            this.insertPrimaryAsset((PrimaryAsset)this.epa);
            CyberXABDiagramTest.assertEquals((Object)((Square)functionStyle).getBorderColor(), (Object)BLACK_COLOR);
            CyberXABDiagramTest.assertEquals((Object)((Square)middleFunctionStyle).getBorderColor(), (Object)BLACK_COLOR);
            this.removePrimaryAsset((PrimaryAsset)this.fpa);
            CyberXABDiagramTest.assertEquals((Object)((Square)functionStyle).getBorderColor(), (Object)this.getEpaColor());
            CyberXABDiagramTest.assertEquals((Object)((Square)middleFunctionStyle).getBorderColor(), (Object)this.getEpaColor());
        });
    }

    protected void step5() throws RollbackException, InterruptedException {
        this.executeCommand(() -> {
            String actor3Id = this.diagram.createActor("actor3", this.diagram.getDiagramId());
            String function8 = this.diagram.createFunction("function8", actor3Id);
            String function9 = this.diagram.createFunction("function9", actor3Id);
            this.diagram.createFunctionalExchange(function8, function9, "exchange");
            ExchangeItem exchangeItem1 = InformationFactory.eINSTANCE.createExchangeItem();
            InterfacePkg pkg = (InterfacePkg)this.context.getSemanticElement(this.getInterfacePkgId());
            pkg.getOwnedExchangeItems().add((Object)exchangeItem1);
            FunctionalExchange fe = (FunctionalExchange)this.diagram.getSemanticObjectMap().get("exchange");
            fe.getExchangedItems().add((Object)exchangeItem1);
            PrimaryAssetMember member1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            member1.setMember((ModelElement)exchangeItem1);
            InformationPrimaryAsset ipa1 = this.services.createInformationPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            ipa1.getOwnedMembers().add((Object)member1);
            this.insertPrimaryAsset((PrimaryAsset)ipa1);
            DDiagramElement exchangeView = this.diagram.getView((EObject)fe);
            Style exchangeStyle = exchangeView.getStyle();
            DDiagramElement informationAssetView = this.diagram.getView((EObject)this.diagram.getSemanticObjectMap().get(ipa1.getId()));
            Style informationAssetStyle = informationAssetView.getStyle();
            CyberXABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)((Ellipse)informationAssetStyle).getColor());
            InformationPrimaryAsset ipa2 = this.services.createInformationPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember member2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            member2.setMember((ModelElement)exchangeItem1);
            ipa2.getOwnedMembers().add((Object)member2);
            this.insertPrimaryAsset((PrimaryAsset)ipa2);
            this.diagram.refreshDiagram();
            CyberXABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)BLACK_COLOR);
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)ipa1);
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)ipa2);
            this.epa.getOwnedMembers().add((Object)m1);
            this.epa.getOwnedMembers().add((Object)m2);
            this.insertPrimaryAsset((PrimaryAsset)this.epa);
            CyberXABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)BLACK_COLOR);
            this.removePrimaryAsset((PrimaryAsset)ipa1);
            CyberXABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)BLACK_COLOR);
            this.removePrimaryAsset((PrimaryAsset)ipa2);
            CyberXABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)this.getEpaColor());
        });
    }

    protected void step6() throws RollbackException, InterruptedException {
        String component3 = this.diagramElements.get("component3");
        String component4 = this.diagramElements.get("component4");
        String component5 = this.diagramElements.get("component5");
        String component6 = this.diagramElements.get("component6");
        String function10 = this.diagram.createFunction("function10", component6);
        this.diagramElements.put("function10", function10);
        this.executeCommand(() -> {
            this.fpa = this.services.createFunctionalPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)this.diagram.getSemanticObjectMap().get("function10"));
            this.fpa.getOwnedMembers().add((Object)m1);
            this.insertPrimaryAsset((PrimaryAsset)this.fpa);
            CyberDiagramLayers.activateLayer(this.session, this.diagram.getDiagram(), "Cybersecurity Supporting Assets");
            this.diagram.refreshDiagram();
        });
        DNode fNode = (DNode)this.diagram.getViewObjectMap().get("function10");
        CyberXABDiagramTest.assertEquals((Object)this.getFpaColor(), (Object)((Square)fNode.getStyle()).getBorderColor());
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component6");
        CyberXABDiagramTest.assertEquals((Object)this.getFpaColor(), (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component3");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component5");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        this.executeCommand(() -> {
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)this.fpa);
            this.epa.getOwnedMembers().add((Object)m2);
        });
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component6");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        this.removePrimaryAsset((PrimaryAsset)this.fpa);
        this.diagram.refreshDiagram();
        CyberXABDiagramTest.assertEquals((Object)this.getEpaColor(), (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)this.getEpaColor(), (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component5");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        this.insertPrimaryAsset((PrimaryAsset)this.fpa);
        this.removePrimaryAsset((PrimaryAsset)this.epa);
    }

    protected void step7() throws RollbackException, InterruptedException {
        this.executeCommand(() -> {
            this.threat = this.services.createThreat((EObject)this.fpa);
            this.services.createThreatApplication(this.threat, (PrimaryAsset)this.fpa);
            this.insertThreat(this.threat);
            this.diagram.refreshDiagram();
        });
        DNode fNode = (DNode)this.diagram.getViewObjectMap().get("function10");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((Square)fNode.getStyle()).getBorderSize());
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component6");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        this.step7_epa();
    }

    protected void step7_epa() throws RollbackException, InterruptedException {
        this.executeCommand(() -> this.services.createThreatApplication(this.threat, (PrimaryAsset)this.epa));
        this.removePrimaryAsset((PrimaryAsset)this.fpa);
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        DNode fNode = (DNode)this.diagram.getViewObjectMap().get("function10");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((Square)fNode.getStyle()).getBorderSize());
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component6");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
    }

    protected void step8() {
        this.removePrimaryAsset((PrimaryAsset)this.epa);
        DNode fNode = (DNode)this.diagram.getViewObjectMap().get("function10");
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((Square)fNode.getStyle()).getBorderSize());
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component6");
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
    }

    protected void step9() throws RollbackException, InterruptedException {
        String actor4 = this.diagramElements.get("actor4");
        String actor5 = this.diagramElements.get("actor5");
        String component7 = this.diagramElements.get("component7");
        String component8 = this.diagramElements.get("component8");
        String function11 = this.diagram.createFunction("function11", component8);
        this.executeCommand(() -> {
            PrimaryAssetMember m4 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m4.setMember((ModelElement)this.diagram.getSemanticObjectMap().get("function11"));
            this.fpa.getOwnedMembers().add((Object)m4);
            this.diagram.refreshDiagram();
        });
        this.diagramElements.put("function11", function11);
        DNode fNode = (DNode)this.diagram.getViewObjectMap().get("function11");
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((Square)fNode.getStyle()).getBorderSize());
        DNodeContainer fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component8");
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("actor4");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)this.diagram.getViewObjectMap().get("component7");
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberXABDiagramTest.assertEquals((Object)NORMAL_BORDER_SIZE, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
    }

    protected void step10() throws RollbackException, InterruptedException {
        this.diagram.createComponentExchange(this.diagramElements.get("component5"), this.diagramElements.get("component7"), "CE1");
        ComponentExchange componentExchange = (ComponentExchange)this.diagram.getSemanticObjectMap().get("CE1");
        ExchangeItem exchangeItem1 = InformationFactory.eINSTANCE.createExchangeItem();
        InterfacePkg pkg = (InterfacePkg)this.context.getSemanticElement(this.getInterfacePkgId());
        this.executeCommand(() -> {
            pkg.getOwnedExchangeItems().add((Object)exchangeItem1);
            this.diagram.createFunctionalExchange(this.diagramElements.get("function10"), this.diagramElements.get("function11"), "functionalExchange1");
            FunctionalExchange functionalExchange = (FunctionalExchange)this.diagram.getSemanticObjectMap().get("functionalExchange1");
            functionalExchange.getExchangedItems().add((Object)exchangeItem1);
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)exchangeItem1);
            this.ipa = this.services.createInformationPrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            this.ipa.getOwnedMembers().add((Object)m1);
            this.services.createThreatApplication(this.threat, (PrimaryAsset)this.ipa);
            Allocators.allocate(functionalExchange).on(componentExchange);
        });
        DEdge componentExchangeEdge = this.diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == this.diagram.getSemanticObjectMap().get("CE1")).findFirst().get();
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getStrokeColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getSize());
        this.executeCommand(() -> {
            this.epa = this.services.createEnterprisePrimaryAsset(this.context.getSemanticElement(this.getSystemId()));
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)this.ipa);
            this.epa.getOwnedMembers().add((Object)m2);
        });
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getStrokeColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getSize());
        this.removeThreat(this.threat);
        CyberXABDiagramTest.assertEquals((Object)this.getEpaColor(), (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getStrokeColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getSize());
        this.step10CreateAndCheckPhysicalLink(componentExchange);
    }

    protected void step10CreateAndCheckPhysicalLink(ComponentExchange componentExchange) throws RollbackException, InterruptedException {
        this.removePrimaryAsset((PrimaryAsset)this.epa);
        this.insertThreat(this.threat);
        this.executeCommand(() -> {
            this.diagram.createPhysicalLink(this.diagramElements.get("component4"), this.diagramElements.get("component3"), "PL1");
            PhysicalLink physicalLink = (PhysicalLink)this.diagram.getSemanticObjectMap().get("PL1");
            ComponentExchangeAllocation a1 = FaFactory.eINSTANCE.createComponentExchangeAllocation();
            a1.setSourceElement((TraceableElement)physicalLink);
            a1.setTargetElement((TraceableElement)componentExchange);
            physicalLink.getOwnedComponentExchangeAllocations().add((Object)a1);
        });
        DEdge physicalLinkEdge = this.diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == this.diagram.getSemanticObjectMap().get("PL1")).findFirst().get();
        CyberXABDiagramTest.assertEquals((Object)this.getThreatColor(), (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getStrokeColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getSize());
        this.insertPrimaryAsset((PrimaryAsset)this.epa);
        CyberXABDiagramTest.assertEquals((Object)BLACK_COLOR, (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getStrokeColor());
        CyberXABDiagramTest.assertEquals((Object)HIGHLIGHTED_BORDER_SIZE, (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getSize());
    }

    public void test() throws Exception {
        this.step1();
        this.executeCommand(() -> this.fpa.getOwnedMembers().clear());
        this.step2();
        this.step3();
        this.step4();
        this.step5();
        this.executeCommand(() -> this.fpa.getOwnedMembers().clear());
        this.step6();
        this.step7();
        this.step8();
        this.step9();
        this.step10();
    }

    protected final void executeCommand(Runnable r) throws RollbackException, InterruptedException {
        this.tedHelper.executeCommand(r);
    }
}

