/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.test.transition.PrimaryAssetTransitionTest;

public class EnterprisePrimaryAssetTransitionTest
extends PrimaryAssetTransitionTest {
    PrimaryAsset fpa;
    PrimaryAsset ipa;
    PrimaryAsset fpaSub;
    PrimaryAsset ipaSub;
    CybersecurityPkg subPkg;

    @Override
    protected PrimaryAsset createPrimaryAsset() {
        return CybersecurityFactory.eINSTANCE.createEnterprisePrimaryAsset();
    }

    @Override
    protected void checkPAMMembersTransitioned(BlockArchitectureExt.Type level) {
        switch (level) {
            case SA: {
                this.checkOnLevel(this.saPkg);
                break;
            }
            case LA: {
                this.checkOnLevel(this.laPkg);
                break;
            }
            case PA: {
                this.checkOnLevel(this.paPkg);
                break;
            }
        }
    }

    private void checkOnLevel(CybersecurityPkg pkg) {
        this.fpa = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.fpa.getId(), (EObject)pkg);
        this.ipa = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.ipa.getId(), (EObject)pkg);
        this.subPkg = (CybersecurityPkg)this.mustBeTransitionedDirecltyContainedBy(this.subPkg.getId(), (EObject)pkg);
        this.fpaSub = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.fpaSub.getId(), (EObject)this.subPkg);
        this.ipaSub = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.ipaSub.getId(), (EObject)this.subPkg);
    }

    @Override
    protected void addPAMMembers() {
        this.subPkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
        this.oaPkg.getOwnedCybersecurityPkgs().add((Object)this.subPkg);
        this.fpaSub = this.services.createFunctionalPrimaryAssetInPkg(this.subPkg);
        this.ipaSub = this.services.createInformationPrimaryAssetInPkg(this.subPkg);
        this.fpa = this.services.createFunctionalPrimaryAssetInPkg(this.oaPkg);
        this.ipa = this.services.createInformationPrimaryAssetInPkg(this.oaPkg);
        PrimaryAssetMember pam1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        pam1.setMember((ModelElement)this.fpa);
        PrimaryAssetMember pam2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        pam2.setMember((ModelElement)this.ipa);
        PrimaryAssetMember pam3 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        pam3.setMember((ModelElement)this.fpaSub);
        PrimaryAssetMember pam4 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        pam4.setMember((ModelElement)this.ipaSub);
        this.primaryAssetMembers.add(pam1);
        this.primaryAssetMembers.add(pam2);
        this.primaryAssetMembers.add(pam3);
        this.primaryAssetMembers.add(pam4);
    }
}

