/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model.activator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.impl.CybersecurityFactoryImpl;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class CybersecurityModelActivator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.polarsys.capella.cybersecurity.model";
    private static BundleContext context;
    private static CybersecurityModelActivator defaultActivator;
    private static ViewpointManager.OverallListener2 listener;
    public static final String CYBERSECURITY_CFG_KEYWORD = "Cybersecurity Configuration";
    public static final String CYBERSECURITY_CFG_SECURITY_CONFIDENTIALITY_KEYWORD = "Security.Confidentiality";
    public static final String CYBERSECURITY_CFG_SECURITY_INTEGRITY_KEYWORD = "Security.Integrity";
    public static final String CYBERSECURITY_CFG_SECURITY_TRACEABILITY_KEYWORD = "Security.Traceability";
    public static final String CYBERSECURITY_CFG_SECURITY_AVAILABILITY_KEYWORD = "Security.Availability";
    public static final String CYBERSECURITY_CFG_THREAT_KIND_KEYWORD = "Threat.Kind";
    public static final String THREAT_KIND_EAVESDROPPING_KEYWORD = "Eavesdropping";
    public static final String THREAT_KIND_THEFT_KEYWORD = "Theft";
    public static final String THREAT_KIND_DATA_ALTERATION_KEYWORD = "Data alteration";
    public static final String THREAT_KIND_DENIAL_OF_SERVICE_KEYWORD = "Denial of service";
    public static final String THREAT_KIND_INTRUSION_KEYWORD = "Intrusion";
    public static final String THREAT_KIND_TAMPERING_KEYWORD = "Tampering";
    public static final String VIEWPOINT_ID = "org.polarsys.capella.cybersecurity";

    public CybersecurityModelActivator() {
        listener = new ViewpointManager.OverallListener2(){

            public void handleReferencing(Object ctx, Resource vp) {
                TransactionalEditingDomain ted;
                IModel model;
                if (vp != null && vp.getId().equals(CybersecurityModelActivator.VIEWPOINT_ID) && (model = LibraryManager.INSTANCE.getModel(ted = TransactionUtil.getEditingDomain((Object)ctx))) instanceof ICapellaModel) {
                    final Project project = ((ICapellaModel)model).getProject(ted);
                    AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                        public void run() {
                            CybersecurityConfiguration cyberConfig = CybersecurityQueries.getCybersecurityConfiguration(project);
                            if (cyberConfig == null) {
                                CybersecurityModelActivator.this.addProjectCybersecurityConfig(project);
                            }
                        }
                    };
                    if (ViewpointManager.getInstance((EObject)project).isUsed(CybersecurityModelActivator.VIEWPOINT_ID) && !ViewpointManager.getInstance((EObject)project).isFiltered(CybersecurityModelActivator.VIEWPOINT_ID)) {
                        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)command);
                    }
                }
            }

            public void handleUnReferencing(Object ctx, Resource vp) {
            }

            public void handleActivation(Object ctx, Resource vp) {
            }

            public void handleInactivation(Object ctx, Resource vp) {
            }
        };
    }

    static BundleContext getContext() {
        return context;
    }

    public static CybersecurityModelActivator getDefault() {
        return defaultActivator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        defaultActivator = this;
        ViewpointManager.addOverallListener((ViewpointManager.OverallListener2)listener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        defaultActivator = null;
        context = null;
        ViewpointManager.removeOverallListener((ViewpointManager.OverallListener2)listener);
    }

    public CybersecurityConfiguration createCybersecurityConfiguration() {
        CybersecurityConfiguration config = CybersecurityFactoryImpl.eINSTANCE.createCybersecurityConfiguration();
        config.setName(CYBERSECURITY_CFG_KEYWORD);
        config.setConfidentiality(this.createEnumerationPropertySecurityType(CYBERSECURITY_CFG_SECURITY_CONFIDENTIALITY_KEYWORD, config));
        config.setIntegrity(this.createEnumerationPropertySecurityType(CYBERSECURITY_CFG_SECURITY_INTEGRITY_KEYWORD, config));
        config.setTraceability(this.createEnumerationPropertySecurityType(CYBERSECURITY_CFG_SECURITY_TRACEABILITY_KEYWORD, config));
        config.setAvailability(this.createEnumerationPropertySecurityType(CYBERSECURITY_CFG_SECURITY_AVAILABILITY_KEYWORD, config));
        config.setThreatKind(this.createEnumerationPropertyThreadKindType(CYBERSECURITY_CFG_THREAT_KIND_KEYWORD, config));
        return config;
    }

    public void addProjectCybersecurityConfig(Project project) {
        project.getOwnedExtensions().add((Object)this.createCybersecurityConfiguration());
    }

    private EnumerationPropertyType createEnumerationPropertySecurityType(String typeName, CybersecurityConfiguration config) {
        EnumerationPropertyType type = CapellacoreFactory.eINSTANCE.createEnumerationPropertyType(typeName);
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("0"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("1"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("2"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("3"));
        config.getOwnedEnumerationPropertyTypes().add((Object)type);
        return type;
    }

    private EnumerationPropertyType createEnumerationPropertyThreadKindType(String typeName, CybersecurityConfiguration config) {
        EnumerationPropertyType type = CapellacoreFactory.eINSTANCE.createEnumerationPropertyType(typeName);
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_EAVESDROPPING_KEYWORD));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_DENIAL_OF_SERVICE_KEYWORD));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_THEFT_KEYWORD));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_DATA_ALTERATION_KEYWORD));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_INTRUSION_KEYWORD));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(THREAT_KIND_TAMPERING_KEYWORD));
        config.getOwnedEnumerationPropertyTypes().add((Object)type);
        return type;
    }
}

