/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.rules.testcases.cy_dcon;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.impl.SystemFunctionImpl;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.DynamicValidationTest;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;

public class Rule_CY_DCON_05
extends DynamicValidationTest {
    private static final String RULE = "org.polarsys.capella.cybersecurity.validation.CY_DCON_05";
    protected XABDiagram diagram;
    CybersecurityServices service = new CybersecurityServices();
    ThreatSourceUse threatSourceUse;
    ThreatSourceUse threatSourceUseSuper;
    ThreatSourceUse threatSourceUse2;
    SystemComponent actor1;
    SystemComponent actor1Parent;
    SystemComponent actor2Parent;
    SystemComponent actor2;
    SystemComponentPkg componentPkg;
    SystemAnalysis architecture;
    ComponentExchange ce;
    PhysicalLink pl;
    EList<SystemComponent> systemComponents;

    @Override
    protected void initModel(CapellaModelSkeleton skeleton) {
        this.actor1Parent = ComponentExt.createSystemComponent();
        this.actor2Parent = ComponentExt.createSystemComponent();
        this.architecture = skeleton.getSystemAnalysis();
        ComponentExt.getAllSubUsedAndDeployedComponents((Component)this.actor1Parent);
        this.componentPkg = this.architecture.getOwnedSystemComponentPkg();
        this.systemComponents = this.architecture.getOwnedSystemComponentPkg().getOwnedSystemComponents();
        this.systemComponents.add((Object)this.actor1Parent);
        this.systemComponents.add((Object)this.actor2Parent);
        this.threatSourceUse = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        this.threatSourceUseSuper = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        this.threatSourceUseSuper.setUsed((Component)this.actor2Parent);
        this.actor1Parent.getOwnedExtensions().add((Object)this.threatSourceUseSuper);
        this.actor1 = ComponentExt.createSystemActor();
        this.actor2 = ComponentExt.createSystemActor();
        this.threatSourceUse.setUsed((Component)this.actor2);
        this.actor1.getOwnedExtensions().add((Object)this.threatSourceUse);
        this.addSubComponent(this.actor1Parent, this.actor1);
        this.addSubComponent(this.actor2Parent, this.actor2);
    }

    private void addSubComponent(SystemComponent parent, SystemComponent subComponent) {
        parent.getOwnedSystemComponents().add((Object)subComponent);
        new CsServices().createRepresentingPartIfNone((Component)subComponent);
    }

    public void test() throws Exception {
        this.ko((EObject)this.threatSourceUse, RULE);
        this.executeCommand(() -> {
            this.ce = FaFactory.eINSTANCE.createComponentExchange();
            ComponentPort cp1 = FaFactory.eINSTANCE.createComponentPort();
            ComponentPort cp2 = FaFactory.eINSTANCE.createComponentPort();
            this.actor1.getOwnedFeatures().add((Object)cp1);
            this.actor2.getOwnedFeatures().add((Object)cp2);
            this.ce.setSource((InformationsExchanger)cp1);
            this.ce.setTarget((InformationsExchanger)cp2);
            this.componentPkg.getOwnedComponentExchanges().add((Object)this.ce);
        });
        this.ok((EObject)this.threatSourceUse, RULE);
        this.ok((EObject)this.threatSourceUseSuper, RULE);
        this.executeCommand(() -> {
            this.componentPkg.getOwnedComponentExchanges().remove((Object)this.ce);
            this.pl = CsFactory.eINSTANCE.createPhysicalLink();
            PhysicalPort pp1 = CsFactory.eINSTANCE.createPhysicalPort();
            PhysicalPort pp2 = CsFactory.eINSTANCE.createPhysicalPort();
            this.actor1.getOwnedFeatures().add((Object)pp1);
            this.actor2.getOwnedFeatures().add((Object)pp2);
            this.pl.getLinkEnds().add((Object)pp1);
            this.pl.getLinkEnds().add((Object)pp2);
            this.componentPkg.getOwnedPhysicalLinks().add((Object)this.pl);
        });
        this.ok((EObject)this.threatSourceUse, RULE);
        this.ok((EObject)this.threatSourceUseSuper, RULE);
        this.executeCommand(() -> {
            this.componentPkg.getOwnedPhysicalLinks().remove((Object)this.pl);
            final FunctionalExchange fe = FaFactory.eINSTANCE.createFunctionalExchange();
            SystemFunction function1 = CtxFactory.eINSTANCE.createSystemFunction();
            function1.setId(IdGenerator.createId());
            SystemFunctionImpl function2 = new SystemFunctionImpl(){

                public EList<ActivityEdge> getIncoming() {
                    BasicEList list = new BasicEList();
                    list.add((Object)fe);
                    return list;
                }
            };
            FunctionInputPort fip = FaFactory.eINSTANCE.createFunctionInputPort();
            FunctionOutputPort fop = FaFactory.eINSTANCE.createFunctionOutputPort();
            fe.setTarget((ActivityNode)fip);
            fe.setSource((ActivityNode)fop);
            function1.getOutputs().add((Object)fop);
            function2.getInputs().add((Object)fip);
            function1.getOwnedFunctionalExchanges().add((Object)fe);
            ComponentFunctionalAllocation cfa1 = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
            cfa1.setTargetElement((TraceableElement)function1);
            cfa1.setSourceElement((TraceableElement)this.actor1);
            this.actor1.getOwnedFunctionalAllocation().add((Object)cfa1);
            ComponentFunctionalAllocation cfa2 = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
            cfa2.setTargetElement((TraceableElement)function2);
            cfa2.setSourceElement((TraceableElement)this.actor2);
            this.actor2.getOwnedFunctionalAllocation().add((Object)cfa2);
        });
        this.ok((EObject)this.threatSourceUse, RULE);
        this.ok((EObject)this.threatSourceUseSuper, RULE);
    }
}

