/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.business.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.cybersecurity.business.queries.AutoPruneTreeIterator;

public class BlockArchitecturePredicateQuery
implements IBusinessQuery {
    private final EReference theFeature;
    private final Predicate<EObject> adder;
    private final EClass extensionClass;

    public BlockArchitecturePredicateQuery(EReference theFeature, Predicate<EObject> adder, EClass extensionClass) {
        this.theFeature = theFeature;
        this.extensionClass = extensionClass;
        this.adder = adder;
    }

    public List<EObject> getAvailableElements(EObject element) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
        BlockArchitecture blockArchitecture = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)element, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        return this.getAvailableElementsOnArchitecture(blockArchitecture, domain);
    }

    protected List<EObject> getAvailableElementsOnArchitecture(BlockArchitecture blockArchitecture, TransactionalEditingDomain domain) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        this.walkProject((EObject)blockArchitecture, blockArchitecture, result, this.adder);
        for (IModel model : LibraryManagerExt.getAllActivesReferences((IModel)LibraryManager.INSTANCE.getModel(domain))) {
            if (!(model instanceof ICapellaModel)) continue;
            Project project = ((ICapellaModel)model).getProject(domain);
            this.walkProject((EObject)project, blockArchitecture, result, this.adder);
        }
        return result;
    }

    protected void walkProject(EObject root, BlockArchitecture archi, Collection<EObject> result, Predicate<EObject> adder) {
        TreeIterator<EObject> it = this.createIterator(root, archi.eClass());
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!adder.test(next)) continue;
            result.add(next);
        }
    }

    public List<EObject> getCurrentElements(EObject element, boolean onlyGenerated) {
        return (List)element.eGet((EStructuralFeature)this.theFeature);
    }

    public EClass getEClass() {
        return this.extensionClass;
    }

    public List<EReference> getEStructuralFeatures() {
        return Collections.singletonList(this.theFeature);
    }

    private TreeIterator<EObject> createIterator(EObject root, EClass blockArchitectureClass) {
        return new AutoPruneTreeIterator(Collections.singleton(root), e -> e instanceof BlockArchitecture && e.eClass() != blockArchitectureClass);
    }
}

