/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;

public class ExchangeItemAllocator {
    private final Collection<? extends ExchangeItem> allocations;
    private final boolean propagateToFunctionPorts;

    ExchangeItemAllocator(Collection<? extends ExchangeItem> eia, boolean propagateToFunctionPorts) {
        this.allocations = eia;
        this.propagateToFunctionPorts = propagateToFunctionPorts;
    }

    public ExchangeItemAllocator on(Interface i) {
        if (i != null) {
            for (ExchangeItem exchangeItem : this.allocations) {
                if (i.getExchangeItems().contains((Object)exchangeItem)) continue;
                ExchangeItemAllocation eia = CsFactory.eINSTANCE.createExchangeItemAllocation();
                eia.setAllocatedItem(exchangeItem);
                i.getOwnedExchangeItemAllocations().add((Object)eia);
            }
        }
        return this;
    }

    public ExchangeItemAllocator on(FunctionInputPort fip) {
        if (fip != null) {
            for (ExchangeItem exchangeItem : this.allocations) {
                fip.getIncomingExchangeItems().add((Object)exchangeItem);
            }
        }
        return this;
    }

    public ExchangeItemAllocator on(FunctionOutputPort fop) {
        if (fop != null) {
            for (ExchangeItem exchangeItem : this.allocations) {
                fop.getOutgoingExchangeItems().add((Object)exchangeItem);
            }
        }
        return this;
    }

    public ExchangeItemAllocator on(FunctionalExchange fe) {
        if (fe != null) {
            for (ExchangeItem exchangeItem : this.allocations) {
                fe.getExchangedItems().add((Object)exchangeItem);
            }
            if (this.propagateToFunctionPorts) {
                this.on(fe.getSourceFunctionOutputPort());
                this.on(fe.getTargetFunctionInputPort());
            }
        }
        return this;
    }

    public ExchangeItemAllocator on(ComponentExchange ce) {
        if (ce != null) {
            for (ExchangeItem exchangeItem : this.allocations) {
                ce.getConvoyedInformations().add((Object)exchangeItem);
            }
        }
        return this;
    }

    public ExchangeItemAllocator on(Collection<?> elements) {
        for (Object e : elements) {
            if (e instanceof FunctionalExchange) {
                this.on((FunctionalExchange)e);
                continue;
            }
            if (e instanceof ComponentExchange) {
                this.on((ComponentExchange)e);
                continue;
            }
            if (e instanceof FunctionInputPort) {
                this.on((FunctionInputPort)e);
                continue;
            }
            if (e instanceof FunctionOutputPort) {
                this.on((FunctionOutputPort)e);
                continue;
            }
            if (!(e instanceof Interface)) continue;
            this.on((Interface)e);
        }
        return this;
    }

    public static ExchangeItemAllocator allocate(ExchangeItem ei) {
        return ExchangeItemAllocator.allocate(Collections.singleton(ei));
    }

    public static ExchangeItemAllocator allocate(ExchangeItem ... exchangeItems) {
        return ExchangeItemAllocator.allocate(Arrays.asList(exchangeItems), true);
    }

    public static ExchangeItemAllocator allocate(Collection<? extends ExchangeItem> exchangeItems) {
        return ExchangeItemAllocator.allocate(exchangeItems, true);
    }

    public static ExchangeItemAllocator allocate(ExchangeItem exchangeItem, boolean propagateToFunctionPorts) {
        return ExchangeItemAllocator.allocate(Collections.singleton(exchangeItem), propagateToFunctionPorts);
    }

    public static ExchangeItemAllocator allocate(Collection<? extends ExchangeItem> exchangeItems, boolean propagateToFunctionPorts) {
        return new ExchangeItemAllocator(exchangeItems, propagateToFunctionPorts);
    }
}

