/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.cybersecurity.test.diagram.ThreatDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class ThreatDiagramTest
extends EmptyProject {
    Session session;
    SessionContext context;
    protected Threat threatSub;
    protected FunctionalPrimaryAsset fpaSub;
    protected InformationPrimaryAsset ipaSub;
    CybersecurityServices services;
    protected EnterprisePrimaryAsset epaSub;
    protected TransactionalEditingDomainHelper tedHelper;

    protected void undoAllChanges() {
    }

    public void test() throws Exception {
        this.session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.tedHelper = new TransactionalEditingDomainHelper(this.session.getTransactionalEditingDomain());
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)this.session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        this.services = new CybersecurityServices();
        this.testOnOA("bba24bed-20cd-4d6e-b981-12de37a4926d");
        this.testOnContext("826533be-e00c-468d-a47e-ba3ee51b4d35");
        this.testOnContext("826533be-e00c-468d-a47e-ba3ee51b4d35");
        this.testOnContext("b121dd59-9d3f-4c21-94ae-87e957aaa2a9");
        this.testOnContext("32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnContext("a59425f8-6827-48eb-ab41-cbf7e4d7674b");
        this.testOnContext("9a842ee5-662a-4534-a70a-d9241779d0ba");
        this.testOnContext("16953dc7-be25-45ef-9da9-32869d0cb53f");
    }

    protected void testOnContext(String containerId) throws Exception {
        ThreatDiagram td = ThreatDiagram.createDiagram(this.context, containerId);
        DNode threat = td.createThreat();
        DNode fpa = td.createFunctionalPrimaryAsset();
        DNode ipa = td.createInformationPrimaryAsset();
        DNode epa = td.createEnterprisePrimaryAsset();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)this.context.getSemanticElement(containerId));
        CybersecurityPkg cyberPkg = new CybersecurityServices().getDefaultCyberSecurityPackage((EObject)architecture, false);
        ThreatDiagramTest.assertNotNull((Object)cyberPkg);
        EList primaryAssets = cyberPkg.getOwnedPrimaryAssets();
        ThreatDiagramTest.assertTrue((boolean)primaryAssets.contains((Object)ipa.getTarget()));
        ThreatDiagramTest.assertTrue((boolean)primaryAssets.contains((Object)fpa.getTarget()));
        ThreatDiagramTest.assertTrue((boolean)primaryAssets.contains((Object)epa.getTarget()));
        DNode actor = td.createActor();
        DNode threatSource = td.createActor();
        td.createThreatApplication(threat, ipa);
        td.createThreatApplication(threat, fpa);
        td.createThreatApplication(threat, epa);
        td.createThreatInvolvement(threat, actor);
        CybersecurityPkg rootCyberPkg = new CybersecurityServices().getRootCibersecurityPkg(architecture);
        ThreatDiagramTest.assertEquals((Object)rootCyberPkg, (Object)cyberPkg);
        long threatsCount = this.services.getAllCurrentLevelThreats(threat.getTarget()).stream().count();
        long fpaCount = this.services.getAllCurrentLevelInformationPrimaryAssets(fpa.getTarget()).stream().count();
        long ipaCount = this.services.getAllCurrentLevelFunctionalPrimaryAssets(ipa.getTarget()).stream().count();
        long epaCount = this.services.getAllCurrentLevelFunctionalPrimaryAssets(epa.getTarget()).stream().count();
        this.executeCommand(() -> {
            CybersecurityPkg subPkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
            rootCyberPkg.getOwnedCybersecurityPkgs().add((Object)subPkg);
            this.threatSub = this.services.createThreatInPkg(subPkg);
            subPkg.getOwnedThreats().add((Object)this.threatSub);
            this.fpaSub = this.services.createFunctionalPrimaryAssetInPkg(subPkg);
            subPkg.getOwnedPrimaryAssets().add((Object)this.fpaSub);
            this.ipaSub = this.services.createInformationPrimaryAssetInPkg(subPkg);
            subPkg.getOwnedPrimaryAssets().add((Object)this.ipaSub);
            this.epaSub = this.services.createEnterprisePrimaryAssetInPkg(subPkg);
            subPkg.getOwnedPrimaryAssets().add((Object)this.epaSub);
            td.setThreatSource((CapellaElement)threatSource.getTarget());
        });
        td.dndThreat(td, (EObject)this.threatSub);
        td.dndFunctionalPrimaryAsset(td, (EObject)this.fpaSub);
        td.dndInformationPrimaryAsset(td, (EObject)this.ipaSub);
        td.dndEnterprisePrimaryAsset(td, (EObject)this.epaSub);
        td.createThreatSourceUse(threatSource, actor);
        ThreatDiagramTest.assertEquals((long)this.services.getAllCurrentLevelThreats((EObject)this.threatSub).stream().count(), (long)(threatsCount + 1L));
        ThreatDiagramTest.assertEquals((long)this.services.getAllCurrentLevelFunctionalPrimaryAssets((EObject)this.fpaSub).stream().count(), (long)(fpaCount + 1L));
        ThreatDiagramTest.assertEquals((long)this.services.getAllCurrentLevelInformationPrimaryAssets((EObject)this.ipaSub).stream().count(), (long)(ipaCount + 1L));
        ThreatDiagramTest.assertEquals((long)this.services.getAllCurrentLevelEnterprisePrimaryAssets((EObject)this.epaSub).stream().count(), (long)(epaCount + 1L));
        ExportFormat format = new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, ImageFileFormat.PNG);
        IPath dest = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)new Path("/" + this.getRequiredTestModel() + "/diagram.png"));
        DialectUIManager.INSTANCE.export((DRepresentation)td.getDiagram(), this.session, dest, format, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void testOnOA(String containerId) throws Exception {
        ThreatDiagram td = ThreatDiagram.createDiagram(this.context, containerId);
        DNode threat = td.createThreat();
        DNode ipa = td.createFunctionalPrimaryAsset();
        DNode fpa = td.createInformationPrimaryAsset();
        DNode epa = td.createEnterprisePrimaryAsset();
        DNode actor = td.createOperationalActor();
        DNode threatSource = td.createOperationalActor();
        this.executeCommand(() -> td.setThreatSource((CapellaElement)threatSource.getTarget()));
        td.createThreatSourceUse(threatSource, actor);
        td.createThreatApplication(threat, ipa);
        td.createThreatApplication(threat, fpa);
        td.createThreatApplication(threat, epa);
        td.createThreatInvolvement(threat, actor);
        Entity eActor = (Entity)actor.getTarget();
        ThreatDiagram tdActor = ThreatDiagram.createDiagram(this.context, eActor.getId());
        tdActor.createOperationalActor();
        tdActor.createOperationalEntity();
        tdActor.createThreat();
    }

    protected final void executeCommand(Runnable r) throws RollbackException, InterruptedException {
        this.tedHelper.executeCommand(r);
    }
}

