/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.ui.properties.sections.ActorUseController;
import org.polarsys.capella.cybersecurity.ui.properties.sections.CybersecurityPropertyButtonListener;
import org.polarsys.capella.cybersecurity.ui.properties.sections.CybersecuritySection;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ThreatSourceUseSection
extends CybersecuritySection {
    public ThreatSourceUseSection() {
        super(true);
    }

    public ThreatSourceUseSection(boolean showRealizations) {
        super(showRealizations);
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest instanceof Entity || eObjectToTest instanceof Component && ((Component)eObjectToTest).isActor();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        super.addUsedWidget("Uses");
        CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().registerPropertySection(this);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        this.loadData(newEObject);
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        super.loadRealizedWidget(capellaElement, EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS);
        CybersecurityServices service = new CybersecurityServices();
        this.setEnabled(service.isThreatSource(capellaElement));
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        super.addRealizedFields(fields);
        return fields;
    }

    @Override
    protected AbstractMultipleSemanticFieldController getController() {
        return new ActorUseController();
    }

    public void dispose() {
        super.dispose();
        CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().unregisterPropertySection(this);
    }
}

