/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.crossphases.handlers.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.capellaHelpers.HashMapSet;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.AbstractRule;
import org.polarsys.capella.core.transition.system.handlers.attachment.CapellaDefaultAttachmentHandler;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContextHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class CrossPhasesAttachmentHelper
extends CapellaDefaultAttachmentHandler {
    public static final String CROSS_PHASES_ATTACHMENT_HELPER = "CrossPhasesAttachment";
    protected static final String CROSS_PHASES_ATTACHMENT_MAP = "CrossPhasesAttachmentMap";
    protected static final String CROSS_PHASES_ATTACHMENT_REVERSE_MAP = "CrossPhasesAttachmentReverseMap";

    public static Collection<Part> getBestPartAncestors(boolean behaviorOnly, Part currentPart) {
        if (!behaviorOnly) {
            return ComponentExt.getBestPartAncestors((Part)currentPart);
        }
        LinkedList<Part> parents = new LinkedList<Part>();
        Component parent = ComponentExt.getDirectParent((Part)currentPart);
        if (parent instanceof PhysicalComponent && ((PhysicalComponent)parent).getNature().equals((Object)PhysicalComponentNature.NODE)) {
            parent = ComponentExt.getRootComponent((EObject)parent);
        }
        if (parent instanceof Component) {
            parents.addAll((Collection<Part>)parent.getRepresentingParts());
        }
        return parents;
    }

    public static boolean isBrothers(boolean behaviorOnly, Part source, Part target) {
        HashSet<EObject> deployingTarget;
        if (!behaviorOnly) {
            return ComponentExt.isBrothers((Part)source, (Part)target);
        }
        HashSet<EObject> deployingSource = new HashSet<EObject>();
        if (deployingSource.size() == 0) {
            EObject sourceContainer = EcoreUtil2.getFirstContainer((EObject)source, Arrays.asList(CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT_PKG));
            if (sourceContainer instanceof Component) {
                deployingSource.addAll((Collection<EObject>)((Component)sourceContainer).getRepresentingParts());
            } else if (sourceContainer instanceof ComponentPkg) {
                deployingSource.add(sourceContainer);
            }
        }
        if ((deployingTarget = new HashSet<EObject>()).size() == 0) {
            EObject targetContainer = EcoreUtil2.getFirstContainer((EObject)target, Arrays.asList(CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT_PKG));
            if (targetContainer instanceof Component) {
                deployingTarget.addAll((Collection<EObject>)((Component)targetContainer).getRepresentingParts());
            } else if (targetContainer instanceof ComponentPkg) {
                deployingTarget.add(targetContainer);
            }
        }
        if (deployingSource.size() == 0 && deployingTarget.size() == 0) {
            return true;
        }
        deployingSource.retainAll(deployingTarget);
        return deployingSource.size() > 0;
    }

    public void computeRelatedComponent(Component element, IContext context_p) {
        Collection transfoSources = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        boolean behaviorOnly = SubSystemContextHelper.isBehaviorSelectionOnly((IContext)context_p);
        Component relatedComponent = element;
        Collection<Part> sourceAndAncestors = this.getSourceAndAncestors(behaviorOnly, transfoSources);
        if (element != null) {
            boolean shouldMerge = this.shouldMerge(element, context_p);
            if (shouldMerge) {
                this.shouldMerge(element, context_p);
                for (Part part : element.getRepresentingParts()) {
                    if (!sourceAndAncestors.contains(part)) continue;
                    shouldMerge = false;
                }
            }
            if (shouldMerge) {
                for (Part part : element.getRepresentingParts()) {
                    if (!shouldMerge) continue;
                    for (Part source : sourceAndAncestors) {
                        if (!shouldMerge || !CrossPhasesAttachmentHelper.isBrothers(behaviorOnly, part, source)) continue;
                        shouldMerge = false;
                    }
                }
            }
            if (shouldMerge) {
                boolean componentFound = false;
                block3: for (Part partElement : element.getRepresentingParts()) {
                    if (componentFound) continue;
                    for (Part part : CrossPhasesAttachmentHelper.getBestPartAncestors(behaviorOnly, partElement)) {
                        Component type;
                        Component cache2;
                        if (componentFound || !(part.getAbstractType() instanceof Component) || (cache2 = this.getRelatedComponent(type = (Component)part.getAbstractType(), context_p)) == null) continue;
                        relatedComponent = cache2;
                        componentFound = true;
                        continue block3;
                    }
                }
            }
        }
        if (relatedComponent != null) {
            CrossPhasesAttachmentHelper.getInstance(context_p).setRelatedComponent(element, relatedComponent, context_p);
        }
    }

    protected boolean shouldMerge(Component element_p, IContext context_p) {
        return element_p instanceof PhysicalComponent || OptionsHandlerHelper.getInstance((IContext)context_p).getBooleanValue(context_p, "capella.core.transition.system2subsystem.crossphases", "componentMerge", true);
    }

    private Collection<Part> getSourceAndAncestors(boolean behaviorOnly, Collection<EObject> transfoSources_p) {
        HashSet<Part> sources = new HashSet<Part>();
        for (EObject eObject : transfoSources_p) {
            if (eObject instanceof Part) {
                sources.add((Part)eObject);
                sources.addAll(CrossPhasesAttachmentHelper.getPartAncestors(behaviorOnly, (Part)eObject));
                continue;
            }
            if (!(eObject instanceof Component)) continue;
            for (Part part : ((Component)eObject).getRepresentingParts()) {
                sources.add(part);
                sources.addAll(CrossPhasesAttachmentHelper.getPartAncestors(behaviorOnly, part));
            }
        }
        return sources;
    }

    public static Collection<Part> getPartAncestors(boolean behaviorOnly, Part child) {
        return CrossPhasesAttachmentHelper.getPartAncestors(behaviorOnly, child, false);
    }

    public static Collection<Part> getPartAncestors(boolean behaviorOnly, Part child, boolean addGeneralizationOfParents) {
        if (!behaviorOnly) {
            return ComponentExt.getPartAncestors((Part)child, (boolean)addGeneralizationOfParents);
        }
        ArrayList<Part> result = new ArrayList<Part>();
        HashSet<Part> visited = new HashSet<Part>();
        LinkedList<Part> toVisit = new LinkedList<Part>();
        if (child != null) {
            toVisit.add(child);
            while (toVisit.size() > 0) {
                Part pvisit;
                Component parent;
                Part visit = (Part)toVisit.removeFirst();
                if (!(visit instanceof Part) || (parent = ComponentExt.getDirectParent((Part)(pvisit = visit))) == null) continue;
                ArrayList<Component> container = new ArrayList<Component>();
                container.add(parent);
                if (addGeneralizationOfParents && parent instanceof GeneralizableElement) {
                    List list = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)parent);
                    container.addAll(list);
                }
                for (EObject eObject : container) {
                    if (!(eObject instanceof Component)) continue;
                    for (Part part : ((Component)eObject).getRepresentingParts()) {
                        if (visited.contains(part)) continue;
                        toVisit.addLast(part);
                        result.add(part);
                        visited.add(part);
                    }
                }
            }
        }
        return result;
    }

    private boolean isBrotherWithSource(boolean behaviorOnly, Component element_p, Collection<EObject> transfoSources_p) {
        HashSet<Part> sources = new HashSet<Part>();
        for (EObject eObject : transfoSources_p) {
            if (eObject instanceof Part) {
                sources.add((Part)eObject);
                continue;
            }
            if (!(eObject instanceof Component)) continue;
            for (Part part : ((Component)eObject).getRepresentingParts()) {
                sources.add(part);
            }
        }
        for (Part part : element_p.getRepresentingParts()) {
            for (Part source : sources) {
                if (!CrossPhasesAttachmentHelper.isBrothers(behaviorOnly, part, source)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAncestorOf(boolean behaviorOnly, Component element_p, Collection<EObject> transfoSources_p) {
        for (EObject source : transfoSources_p) {
            if (source instanceof Part) {
                for (Part part : CrossPhasesAttachmentHelper.getPartAncestors(behaviorOnly, (Part)source)) {
                    if (!element_p.equals(part.getAbstractType())) continue;
                    return true;
                }
                continue;
            }
            if (!(source instanceof Component)) continue;
            for (Part partSource : ((Component)source).getRepresentingParts()) {
                if (!(partSource instanceof Part)) continue;
                for (Part part : CrossPhasesAttachmentHelper.getPartAncestors(behaviorOnly, partSource)) {
                    if (!element_p.equals(part.getAbstractType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static CrossPhasesAttachmentHelper getInstance(IContext context_p) {
        CrossPhasesAttachmentHelper handler = (CrossPhasesAttachmentHelper)((Object)context_p.get((Object)CROSS_PHASES_ATTACHMENT_HELPER));
        if (handler == null) {
            handler = new CrossPhasesAttachmentHelper();
            handler.init(context_p);
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_HELPER, (Object)handler);
        }
        return handler;
    }

    public Component getRelatedComponent(Component source, IContext context_p) {
        Component cache = (Component)this.getMap(context_p).get(source);
        if (cache == null) {
            this.computeRelatedComponent(source, context_p);
            cache = (Component)this.getMap(context_p).get(source);
        }
        if (cache == null) {
            cache = source;
        }
        this.computeRelatedComponent(source, context_p);
        return cache;
    }

    public void setRelatedComponent(Component source, Component target, IContext context_p) {
        this.getMap(context_p).put((EObject)source, (EObject)target);
        this.getReverseMap(context_p).put((Object)target, (Object)source);
    }

    protected HashMapSet<EObject, EObject> getReverseMap(IContext context_p) {
        if (context_p.get((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP) == null) {
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP, (Object)new HashMapSet());
        }
        return (HashMapSet)context_p.get((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP);
    }

    public Map<EObject, EObject> getMap(IContext context_p) {
        if (context_p.get((Object)CROSS_PHASES_ATTACHMENT_MAP) == null) {
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_MAP, new HashMap());
        }
        return (Map)context_p.get((Object)CROSS_PHASES_ATTACHMENT_MAP);
    }

    public void clear(IContext context) {
        this.getMap(context).clear();
        this.getReverseMap(context).clear();
    }

    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public void attachRelatedElements(EObject source_p, EObject target_p, EReference feature_p, IContext context_p) {
        for (EObject traced : this.retrieveReferenceAsList(source_p, feature_p)) {
            if (traced instanceof Component) {
                traced = this.getRelatedComponent((Component)traced, context_p);
            }
            for (EObject related : TraceabilityHandlerHelper.getInstance((IContext)context_p).retrieveTracedElements(traced, context_p)) {
                this.attachElementByReference(source_p, target_p, traced, related, feature_p, feature_p);
            }
        }
    }

    public void attachRelatedOfMergedElements(EObject element_p, EObject result_p, EReference reference_p, IContext context_p) {
        Collection values = this.getReverseMap(context_p).get((Object)element_p);
        if (values != null && values.size() > 0) {
            for (EObject value : values) {
                if (value == null || element_p.equals(value)) continue;
                this.attachRelatedElements(value, result_p, reference_p, context_p);
            }
        }
    }

    public void addPremicesRelatedOfMergedComponent(EObject element_p, AbstractRule rule, EReference feature, ArrayList<IPremise> needed_p, IContext context_p) {
        Collection values = this.getReverseMap(context_p).get((Object)element_p);
        if (values != null && values.size() > 0) {
            for (EObject value : values) {
                if (value == null || element_p.equals(value)) continue;
                needed_p.addAll(rule.createDefaultPrecedencePremices(value, feature));
            }
        }
    }
}

