/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.preferences;

import org.eclipse.capra.ui.office.Activator;
import org.eclipse.capra.ui.office.views.OfficeView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class OfficePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String CHAR_COUNT = "org.eclipse.capra.ui.office.preferences.charCount";
    public static final String EXCEL_COLUMN_RADIO_CHOICE = "org.eclipse.capra.ui.office.preferences.excelColumnRadioChoice";
    public static final String EXCEL_CUSTOM_COLUMN = "org.eclipse.capra.ui.office.preferences.excelCustomColumn";
    public static final String EXCEL_COLUMN_VALUE = "org.eclipse.capra.ui.office.preferences.excelColumnValue";
    public static final String WORD_FIELD_NAME = "org.eclipse.capra.ui.office.preferences.wordFieldId";
    public static final String CHAR_COUNT_DEFAULT = "80";
    public static final boolean EXCEL_COLUMN_RADIO_ID_IS_LINE_NUMBER = true;
    public static final String EXCEL_CUSTOM_COLUMN_DEFAULT = "A";
    public static final String EXCEL_COLUMN_VALUE_DEFAULT = "0";
    public static final String WORD_FIELD_NAME_DEFAULT = "REQ";
    private static final String CHAR_COUNT_DESC = "Number of characters that are shown per line in the Office view:";
    private static final String EXCEL_COLUMN_RADIO_CHOICE_DESC = "Unique identifier in spreadsheets:";
    private static final String EXCEL_COLUMN_IS_LINE_NUMBER_OPTION_DESC = "Use the line number as the ID";
    private static final String EXCEL_COLUMN_IS_CUSTOM_OPTION_DESC = "Use this column as the ID: ";
    private static final String EXCEL_COLUMN_IS_CUSTOM_OPTION_HINT = "(e.g. \"A\", \"BC\"...)";
    private static final String WORD_FIELD_NAME_DESC = "Name of Word field to display:";
    private static final int FIXED_TEXT_FIELD_WIDTH = 35;
    private Text charCount;
    private Button excelRowIdIsRowNumber;
    private Button excelRowIdIsCustomColumn;
    private Text excelCustomIdColumnName;
    private Text wordFieldName;

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    private void storeValues() {
        boolean idIsRowNumber;
        String idColumn;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (this.excelRowIdIsRowNumber.getSelection()) {
            idColumn = EXCEL_COLUMN_VALUE_DEFAULT;
            this.excelCustomIdColumnName.setText("");
            idIsRowNumber = true;
        } else {
            if (this.excelCustomIdColumnName.getText().isEmpty()) {
                this.excelCustomIdColumnName.setText(EXCEL_CUSTOM_COLUMN_DEFAULT);
            }
            idColumn = this.excelCustomIdColumnName.getText();
            idIsRowNumber = false;
        }
        store.setValue(CHAR_COUNT, this.charCount.getText());
        store.setValue(EXCEL_COLUMN_RADIO_CHOICE, idIsRowNumber);
        store.setValue(EXCEL_CUSTOM_COLUMN, this.excelCustomIdColumnName.getText());
        store.setValue(EXCEL_COLUMN_VALUE, idColumn);
        store.setValue(WORD_FIELD_NAME, this.wordFieldName.getText());
    }

    private void initializeValues() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean idIsRowNumber = store.getBoolean(EXCEL_COLUMN_RADIO_CHOICE);
        if (idIsRowNumber) {
            this.excelRowIdIsRowNumber.setSelection(true);
            this.excelCustomIdColumnName.setText("");
            this.excelCustomIdColumnName.setEnabled(false);
        } else {
            this.excelRowIdIsCustomColumn.setSelection(true);
            this.excelCustomIdColumnName.setText(store.getString(EXCEL_CUSTOM_COLUMN));
        }
        this.charCount.setText(store.getString(CHAR_COUNT));
        this.wordFieldName.setText(store.getString(WORD_FIELD_NAME));
    }

    private void initializeDefaults() {
        this.excelRowIdIsRowNumber.setSelection(true);
        this.excelRowIdIsCustomColumn.setSelection(false);
        if (this.excelRowIdIsRowNumber.getSelection()) {
            this.excelCustomIdColumnName.setText("");
            this.excelCustomIdColumnName.setEnabled(false);
        }
        this.charCount.setText(CHAR_COUNT_DEFAULT);
        this.wordFieldName.setText(WORD_FIELD_NAME_DEFAULT);
    }

    protected Control createContents(Composite parent) {
        Composite compositeCharCount = this.createComposite(parent, 2);
        this.createLabel(compositeCharCount, CHAR_COUNT_DESC, 1);
        this.charCount = this.createTextField(compositeCharCount, 1, 35);
        Composite compositeExcelIdColumn = this.createComposite(parent, 2);
        this.createLabel(compositeExcelIdColumn, EXCEL_COLUMN_RADIO_CHOICE_DESC, 2);
        Composite compositeRadioButtons = this.createComposite(compositeExcelIdColumn, 3);
        this.excelRowIdIsRowNumber = this.createRadioButton(compositeRadioButtons, EXCEL_COLUMN_IS_LINE_NUMBER_OPTION_DESC, 3);
        this.excelRowIdIsCustomColumn = this.createRadioButton(compositeRadioButtons, EXCEL_COLUMN_IS_CUSTOM_OPTION_DESC, 1);
        this.excelCustomIdColumnName = this.createTextField(compositeRadioButtons, 1, 35);
        this.createLabel(compositeRadioButtons, EXCEL_COLUMN_IS_CUSTOM_OPTION_HINT, 1);
        this.excelRowIdIsRowNumber.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OfficePreferences.this.excelCustomIdColumnName.setText("");
                OfficePreferences.this.excelCustomIdColumnName.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.excelRowIdIsCustomColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OfficePreferences.this.excelCustomIdColumnName.setEnabled(true);
                OfficePreferences.this.excelCustomIdColumnName.setText(OfficePreferences.EXCEL_CUSTOM_COLUMN_DEFAULT);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite compositeWordRequirementFieldName = this.createComposite(parent, 2);
        this.createLabel(compositeWordRequirementFieldName, WORD_FIELD_NAME_DESC, 1);
        this.wordFieldName = this.createTextField(compositeWordRequirementFieldName, 1, 35);
        this.initializeValues();
        return new Composite(parent, 0);
    }

    private Label createLabel(Composite parent, String text, int numOfColumns) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = numOfColumns;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createTextField(Composite parent, int numOfColumns, int minimumWidth) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.horizontalSpan = numOfColumns;
        data.minimumWidth = minimumWidth;
        text.setLayoutData((Object)data);
        return text;
    }

    private Button createRadioButton(Composite parent, String label, int numOfColumns) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = numOfColumns;
        button.setLayoutData((Object)data);
        return button;
    }

    public void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public void performApply() {
        super.performApply();
        this.storeValues();
    }

    public boolean performOk() {
        super.performOk();
        this.storeValues();
        OfficeView.getOpenedView().refreshView();
        return true;
    }
}

